function [ Data, Data_additional_output, available_preProcessing_option_names ] = optionsPreProcessing( varargin )
% =====================
% FUNCTION DESCRIPTION:
% =====================
% The function "optionsPreProcessing.m" contains the definition of all 
% available pre-processing options. To implement new options
% follow these two steps:
% 
%
% 1. Name new pre-processing option:
% ==================================
%       - Specify the name following the examples. (Names contained 
%           in cell "available_preProcessing_option_names")
% 
%       (HINT: 
%           - Name will appear in pre-processing popupmenu after restarting interface)
% 
% 
% 2. Define pre-processing:
% =========================
%       - Define any data pre-processing in respective "elseif chosenPreProcessingOption == #"
%       - The pre-processing checkbox must be activated AND the respective
%         pre-processing option selected in pre-processing popup
%       
%       (HINT: 
%           - The read in data is called "Data" and can be pre-processed (Must also be called "Data" at the end of pre-processing step)
%           - The pre-processing can be perfomred at three stages of the computation
%               --> "nr_preProcStep == 1", after deleting columns/rows/markers as selected in interface
%               --> "nr_preProcStep == 2", after gap-filling
%               --> "nr_preProcStep == 3", after coordinate transformation and filtering)


if nargin == 0
    available_preProcessing_option_names = char('01. Pre-Processing: Center data towards center of mass!', ...
        '02. Pre-Processing: Tandem_uso_flip!', ...
        '03. Pre-Processing: Define NEW OPTION in "preProcessingOptions"!', ...
        '04. Pre-Processing: Define NEW OPTION in "preProcessingOptions"!', ...
        '05. Pre-Processing: Define NEW OPTION in "preProcessingOptions"!', ...
        '06. Pre-Processing: Define NEW OPTION in "preProcessingOptions"!', ...
        '   *** Create new options in function "preProcessingOptions" ***' ...
        );
    
    chosenPreProcessingOption = 0;
    Data = [];
    Data_additional_output = [];
else
    Data = varargin{1};                     % The data to be pre-processed
    Data_additional_input = varargin{2};    % Additional data computed and saved fro previous computational steps
    Data_additional_output = [];            % Can be used as to extract other data that will not undergo the PCA but will be saved with the other saved data!
    
    chosenPreProcessingOption = varargin{3};% The chosen pre-processing option
    nr_preProcStep = varargin{4};           % The chosen pre-processing step
    if nr_preProcStep == 2
        DataToFlip = Data;
        DataFlipped = DataToFlip;
    end
    TrialNow = varargin{5};
    SubjNow = varargin{6};
    available_preProcessing_option_names = 0;
end


Data_additional_output = 'This String is saved as Test';


if  chosenPreProcessingOption == 0
    % nothing else
elseif chosenPreProcessingOption == 1
    if nr_preProcStep == 1
        fprintf('      Moving center of mass position is subtracted for each timestep\n')
        COM_data = COM_computation(Data);
        Data(:,1:3:end-2) = Data(:,1:3:end-2) - repmat(COM_data(:,1),1,size(Data,2)/3);
        Data(:,2:3:end-1) = Data(:,2:3:end-1) - repmat(COM_data(:,2),1,size(Data,2)/3);
        Data(:,3:3:end-0) = Data(:,3:3:end-0) - repmat(COM_data(:,3),1,size(Data,2)/3);
    elseif nr_preProcStep == 2
    elseif nr_preProcStep == 3
    end
elseif chosenPreProcessingOption == 2 %Tandem_uso_flip
    if nr_preProcStep == 1
        cut_markers = [31,29,25,23,21,12,10,6,4];
        cut_markers = sort(cut_markers,2,'descend');
        cut_out = zeros(1,length(cut_markers)*3);
        for i=1:length(cut_markers)
            cut_out(3*i-2+0)= 3*cut_markers(i)-2+0;
            cut_out(3*i-2+1)= 3*cut_markers(i)-2+1;
            cut_out(3*i-2+2)= 3*cut_markers(i)-2+2;
        end
        Data(:,cut_out) = [];
        fprintf('      (Tommyuso_flip: Markers %s were cut out. %d columns remaining)\n', num2str(cut_markers), size(Data,2))
    elseif nr_preProcStep == 2
        if size(DataToFlip,2) == 84
        else
            msgbox('This flipping option does not correspond to the data! DataToFlip must have 84 columns!', 'Error', 'Error')
            error('This flipping option does not correspond to the data! DataToFlip must have 84 columns!')
        end
        flipping_vector = [13:24, 1:12, 28:30,25:27,34:36,31:33, 37:48, 61:72, 49:60, 76:78,73:75,82:84,79:81];
        if DataToFlip(12,19) < DataToFlip(12,1) % Subjects are standing facing towards left side 1-->Left toe, 19-->Right Toe
        else
            mean_y = mean( DataToFlip(1,2:3:size(DataToFlip,2)-1));
            for i=2:3:size(DataToFlip,2)-1 %flip second entry: y
                DataFlipped(:,i) = DataToFlip(:,i)*(-1)+2*mean_y; % Flip values and move them back to the correct
            end
            DataFlipped = DataFlipped(:, flipping_vector); %Change Right side with left side data
            fprintf('       Trial %d, subj %d was flipped (from left foot in front to right foot in front)!\n', TrialNow, SubjNow)
        end
        Data = DataFlipped;
    elseif nr_preProcStep == 3
    end
   
elseif chosenPreProcessingOption == 3
    if nr_preProcStep == 1 % Pre-processing after deleting columns/rows/markers
        fprintf('      Edit pre-processing option 9 (step 1) in function "preProcessingOptions"\n')
    elseif nr_preProcStep == 2 % Pre-processing after gap-filling 
        fprintf('      Edit pre-processing option 9 (step 2) in function "preProcessingOptions"\n')
    elseif nr_preProcStep == 3 % Pre-processing after deleting coordinate transformation and filtering
        fprintf('      Edit pre-processing option 9 (step 3) in function "preProcessingOptions"\n')
    end
    
elseif chosenPreProcessingOption == 4
    if nr_preProcStep == 1 % Pre-processing after deleting columns/rows/markers
        fprintf('      Edit pre-processing option 10 (step 1) in function "preProcessingOptions"\n')
    elseif nr_preProcStep == 2  % Pre-processing after gap-filling 
        fprintf('      Edit pre-processing option 10 (step 2) in function "preProcessingOptions"\n')
    elseif nr_preProcStep == 3  % Pre-processing after deleting coordinate transformation and filtering
        fprintf('      Edit pre-processing option 10 (step 3) in function "preProcessingOptions"\n')
    end
    
elseif chosenPreProcessingOption == 5
    if nr_preProcStep == 1 % Pre-processing after deleting columns/rows/markers
        fprintf('      Edit pre-processing option 9 (step 1) in function "preProcessingOptions"\n')
    elseif nr_preProcStep == 2 % Pre-processing after gap-filling 
        fprintf('      Edit pre-processing option 9 (step 2) in function "preProcessingOptions"\n')
    elseif nr_preProcStep == 3 % Pre-processing after deleting coordinate transformation and filtering
        fprintf('      Edit pre-processing option 9 (step 3) in function "preProcessingOptions"\n')
    end
    
elseif chosenPreProcessingOption == 6
    if nr_preProcStep == 1 % Pre-processing after deleting columns/rows/markers
        fprintf('      Edit pre-processing option 10 (step 1) in function "preProcessingOptions"\n')
    elseif nr_preProcStep == 2  % Pre-processing after gap-filling 
        fprintf('      Edit pre-processing option 10 (step 2) in function "preProcessingOptions"\n')
    elseif nr_preProcStep == 3  % Pre-processing after deleting coordinate transformation and filtering
        fprintf('      Edit pre-processing option 10 (step 3) in function "preProcessingOptions"\n')
    end

else
    msgbox('Careful! You selected "Special data treatment"! No selection fit! Check selection!', 'Error', 'error')
    error('Check cutout option!')
    
end


end

