function [ data_normed, d_norm , available_normalization_option_names] = optionsNormalization( varargin )
% =====================
% FUNCTION DESCRIPTION:
% =====================
% The function "optionsNormalization.m" contains the definition of all 
% available normalization options. To implement new options
% follow these two steps:
% 
%
% 1. Name new normalization option:
% =================================
%       - Specify the name following the examples. (Names contained 
%           in cell "available_normalization_option_names")
% 
%       (HINT: 
%           - Name will appear in normalization popupmenu after restarting interface)
% 
% 
% 2. Define pre-processing:
% =========================
%       - Define any data normalization in respective "elseif norm_assignment == #"
%       
%       (HINT: 
%           - Typically the normalization is performed after centering and
%             weighting (also needed for MED normalization, e.g.). This is
%             also the DEFAULT!
%           - For options that require the normalization to happen before
%             centering (estimate body height out of data, e.g.) go to
%             function "pca_PMAnalyzer" in subdirectory 
%             "CoreFunctions\2. PCA". Add the number of the respective
%             norm_assignment to [5, 6, 7] in line 55)


if nargin == 0 
    available_normalization_option_names = char('1.   Norm: "No normalization"', ...
        '2.   Norm: "MED" (Mean euclidean distance)', ...
        '3.   Norm: "SpecifyHeight" (Bottom and Top markers specified in code)', ...
        '4.   Norm: "AutoMeanHeight"(Bottom and Top markers estimated by largest z-distance)', ...
        '5.   Norm: "MAXRange1"(Maximum range of all 1rd components)', ...
        '6.   Norm: "MAXRange2"(Maximum range of all 2rd components)', ...
        '7.   Norm: "MAXRange3"(Maximum range of all 3st components)', ...
        '8.   Norm: Template - Specify in function "optionsNormalization.m"', ...
        '9.   Norm: Template - Specify in function "optionsNormalization.m"', ...
        '  ', ...
        '	*** Future options ***');
    data_normed = 0;
    d_norm = 0;

else
    available_normalization_option_names = 0;
    dataToNorm = varargin{1};
    norm_assignment = varargin{2};

    
    
    
if norm_assignment == 1 %strcmp(norm_assignment, 'No_normalization')
    d_norm = 1;
    data_normed = dataToNorm/d_norm;
    fprintf('d_norm = %d', d_norm)
    
elseif norm_assignment == 2 %strcmp(norm_assignment, 'MED')
    d_norm = mean(sqrt(sum(dataToNorm.^2,2))); % Computes mean euclidean distance MED
    data_normed = dataToNorm/d_norm; % Normalizes data to mean euclidean distance MED
    fprintf('"MED" (mean euclidean distance) - d_norm = %d', d_norm)
    
elseif norm_assignment == 3 %strcmp(norm_assignment, 'HeightMean')
    bot_marker = 26; % 26; for tommy quiet stance, 32 Heel Tennis
    top_marker = 1; % 1 for tommy quiet stance; 3 for Back right head Tennis
    
    meanOrTimePoint = 1; %1: Computes mean height over whole trial, 2: Computes height at specified time ("TimeFrame")
    if meanOrTimePoint == 1
        d_norm = mean(dataToNorm(:,top_marker*3) - dataToNorm(:,bot_marker*3)); % Computes the mean height
    elseif meanOrTimePoint == 2
        TimeFrame = 1; % Selected TimeFrame to compute height
        d_norm = dataToNorm(TimeFrame,top_marker*3) - dataToNorm(TimeFrame,bot_marker*3); % Computes the height at time: "TimeFrame"
    end
    data_normed = dataToNorm/d_norm; % Normalize to computed height
    fprintf('"Height" of person (mean distance of top-marker %d and bottom-marker %d) - d_norm = %d', top_marker, bot_marker, d_norm)
    
elseif norm_assignment == 4 %strcmp(norm_assignment, 'HeightStart')
    Searchframe = 1;
    bot_marker = find(dataToNorm(Searchframe, 3:3:end) == min(dataToNorm(Searchframe, 3:3:end))); % Search for lowest marker at time: "Seachframe"
    top_marker = find(dataToNorm(Searchframe, 3:3:end) == max(dataToNorm(Searchframe, 3:3:end))); % Search for heighest marker at time: "Seachframe"
    
    meanOrTimePoint = 2;  %1: Computes mean height over whole trial, 2: Computes height at specified time ("TimeFrame")
    if meanOrTimePoint == 1
        d_norm = mean(dataToNorm(:,top_marker*3) - dataToNorm(:,bot_marker*3)); % Computes the mean height
    elseif meanOrTimePoint == 2
        TimePoint = 1;
        d_norm = dataToNorm(TimePoint,top_marker*3) - dataToNorm(TimePoint,bot_marker*3); % Computes the height at time: "TimeFrame"
    end
    data_normed = dataToNorm/d_norm; % Normalize to computed height
    fprintf('"Height" of person (mean distance of top-marker %d and bottom-marker %d) - d_norm = %d', top_marker, bot_marker, d_norm)
    
elseif norm_assignment == 5 %strcmp(norm_assignment, 'MAX1')
    d_norm = max(max(dataToNorm(:,1:3:end-2),[],2) - min(dataToNorm(:,1:3:end-2), [],2));% computed the maximum range in first coordinate
    data_normed = dataToNorm/d_norm; % Normalize to maximum range of 1. coordinate (usually x) 
    fprintf('"MAXRange1" (maximal extension at in 1st coordinate) - d_norm = %d', d_norm)

elseif norm_assignment == 6 %strcmp(norm_assignment, 'MAX2')
    d_norm = max(max(dataToNorm(:,2:3:end-1),[],2) - min(dataToNorm(:,2:3:end-1), [],2));% check Markers!!!!! (Tommy example: end = z_head, 3 = z_foot)
    data_normed = dataToNorm/d_norm; % Normalize to maximum range of 2. coordinate(usually y)
    fprintf('"MAXRange2" (maximal extension at in 2nd coordinate) - d_norm = %d', d_norm)
    
elseif norm_assignment == 7 %strcmp(norm_assignment, 'MAX3')
    d_norm = max(max(dataToNorm(:,3:3:end-0),[],2) - min(dataToNorm(:,3:3:end-0), [],2));% check Markers!!!!! (Tommy example: end = z_head, 3 = z_foot)
    data_normed = dataToNorm/d_norm; % Normalize to maximum range of 3. coordinate(usually z)
    fprintf('"MAXRange3" (maximal extension at in 3rd coordinate) - d_norm = %d', d_norm)
    
elseif norm_assignment == 8 % TEMPLATE
    d_norm = 1; % specify
    data_normed = dataToNorm/d_norm;  % Normalize trial to "d_norm"
    fprintf('\n           Data was devided by (normed with) "..." : d_norm = %d', d_norm)
    
elseif norm_assignment == 9 % TEMPLATE
    d_norm = 1; % specify
    data_normed = dataToNorm/d_norm;  % Normalize trial to "d_norm"
    fprintf('\n           Data was devided by (normed with) "..." : d_norm = %d', d_norm)
    
else % Default - no normalization
    d_norm = 1;
    data_normed = dataToNorm/d_norm;
    fprintf('d_norm = %d', d_norm)
end % end if
end
end % end function "optionsNormalization"
