function [ColorOptionsCell, available_coloring_option_names] = optionsColoringVids(varargin)
% =====================
% FUNCTION DESCRIPTION:
% =====================
% The function "optionsColoringVids.m" contains the definition of all 
% available coloring options. To implement new options
% follow these two steps:
% 
%
% 1. Name new coloring option:
% ============================
%       - Specify the name following the examples. (Names contained 
%           in cell "available_coloring_option_names")
% 
%       (HINT: 
%           - Name will appear in video coloring popupmenu after restarting interface)
% 
% 
% 2. Define 4 items of coloring option:
% =====================================
%       - Define any coloring in respective "elseif coloring_option_chosen == #"
%           -> 1. ColorOptionsCell{1,LineNumber}: Any number of lines!
%           -> 2. ColorOptionsCell{2,LineNumber}: Symbol, connection and color for each line (example: 'o-k' -> "o"...dot, "-"...line connection, "k" black)
%           -> 3. ColorOptionsCell{3,LineNumber}: Color of markerface (color above is only for marker surrounding an line connection color!)
%           -> 4. ColorOptionsCell{4,LineNumber}: Markersize
% 
%        (HINT: 
%           - See MATLAB documentation for symbols, connection and color options
%           - Template in "elseif coloring_option_chosen == 11" can be activated and used)


if nargin == 0 
    ColorOptionsCell = {};
    coloring_option_chosen = 0;
    available_coloring_option_names = char('01. Coloring option: No coloring (Black)!', ...
                                       '02. Coloring option: 37 Standard plug-in gait!', ...
                                       '03. Coloring option: 39 Standard plug-in (without rbak)!', ...
                                       '04. Coloring option: 28 Markers - Col.1 (Tandem stance: 37 Standard pluf-in gait -> unsymmetric markers deleted)!', ...
                                       '05. Coloring option: 28 Markers - Col.2 (Tandem stance: 37 Standard pluf-in gait -> unsymmetric markers deleted)!', ...
                                       '06. Coloring option: EDIT in function "optionsColoringVids.m"', ...
                                       '07. Coloring option: EDIT in function "optionsColoringVids.m"', ...
                                       '   *** Create new options in function "coloring_options_PcaVids" ***' ...
                                       );
else
    available_coloring_option_names = 0;
    coloring_option_chosen = varargin{1};




if coloring_option_chosen == 1
    fprintf('\n        Coloring option: No coloring option is chosen!')
    ColorOptionsCell = cell(1,1);
    n_Markers = varargin{2};
    
    % Markers to plot per line
    ColorOptionsCell{1,1} = 1:n_Markers;
    % Symbol and connection of each line     % Colors of each Markerface        % Markesizes for each line
    ColorOptionsCell{2,1} = 'ok';             ColorOptionsCell{3,1} = 'k';        ColorOptionsCell{4,1} = 4;

elseif coloring_option_chosen == 2
    fprintf('\n        Coloring option: Standard plug in gait 37 coloring option is chosen!')
    ColorOptionsCell = cell(4,4); % 4 lines
    
    % Markers to plot per line
    ColorOptionsCell{1,1} = [ 7,  9, 11, 13, 22, 23, 37, 35];
    ColorOptionsCell{1,2} = [ 1,  3,  5, 14, 28, 30, 36, 34];
    ColorOptionsCell{1,3} = [13, 14];
    ColorOptionsCell{1,4} = [22, 28];
    % Symbol and connection of each line      % Colors of each Markerface         % Markesizes for each line
    ColorOptionsCell{2,1} = 'o-';             ColorOptionsCell{3,1} = 'r';        ColorOptionsCell{4,1} = 5;
    ColorOptionsCell{2,2} = 'o-';             ColorOptionsCell{3,2} = 'g';        ColorOptionsCell{4,2} = 5;
    ColorOptionsCell{2,3} = 'o-';             ColorOptionsCell{3,3} = 'g';        ColorOptionsCell{4,3} = 1;
    ColorOptionsCell{2,4} = 'o-';             ColorOptionsCell{3,4} = 'g';        ColorOptionsCell{4,4} = 1;
elseif coloring_option_chosen == 3
    fprintf('\n        39 plug-in-gate without rbak-marker coloring video option is chosen!')
    ColorOptionsCell = cell(4,4); % 4 lines
    
    % Markers to plot per line
    ColorOptionsCell{1,1}  = [1, 2, 4, 3, 1, 4];
    ColorOptionsCell{1,2}  = [2, 3];
    ColorOptionsCell{1,3}  = [5, 6, 9, 5];
    ColorOptionsCell{1,4}  = [7, 8];
    ColorOptionsCell{1,5}  = [5, 8];
    ColorOptionsCell{1,6}  = [7, 6];
    ColorOptionsCell{1,7}  = [7 10 12 14 16];
    ColorOptionsCell{1,8}  = [12 15 14];
    ColorOptionsCell{1,9}  = [15 16];
    ColorOptionsCell{1,10} = [7 17 19 21 23];
    ColorOptionsCell{1,11} = [19 22 21];
    ColorOptionsCell{1,12} = [22 23];
    ColorOptionsCell{1,13} = [24 25 27 26 24 27];
    ColorOptionsCell{1,14} = [25 26];
    ColorOptionsCell{1,15} = [24 29 31 32 33 31];
    ColorOptionsCell{1,16} = [26 29];
    ColorOptionsCell{1,17} = [25 36 37 38 39 37];
    ColorOptionsCell{1,18} = [27 35];
    ColorOptionsCell{1,19} = [1 3 10 12 14 15 16 24 26 29 31 32 33];
    ColorOptionsCell{1,20} = [2 4 17 19 21 22 23 25 27 35 37 38 39];
    ColorOptionsCell{1,21} = [5 6 7 8 9];
    ColorOptionsCell{1,21} = [11 13 18 20 28 30 34 36];
    % Symbol and connection of each line     % Colors of each Markerface         % Markesizes for each line
    ColorOptionsCell{2,1}  = 'o-';           ColorOptionsCell{3,1}  = 'k';       ColorOptionsCell{4,1}  = .1;
    ColorOptionsCell{2,2}  = 'o-';           ColorOptionsCell{3,2}  = 'k';       ColorOptionsCell{4,2}  = .1;
    ColorOptionsCell{2,3}  = 'o-';           ColorOptionsCell{3,3}  = 'k';       ColorOptionsCell{4,3}  = .1;
    ColorOptionsCell{2,4}  = 'o-';           ColorOptionsCell{3,4}  = 'k';       ColorOptionsCell{4,4}  = .1;
    ColorOptionsCell{2,5}  = 'o-';           ColorOptionsCell{3,5}  = 'k';       ColorOptionsCell{4,5}  = .1;
    ColorOptionsCell{2,6}  = 'o-';           ColorOptionsCell{3,6}  = 'k';       ColorOptionsCell{4,6}  = .1;
    ColorOptionsCell{2,7}  = 'o-';           ColorOptionsCell{3,7}  = 'k';       ColorOptionsCell{4,7}  = .1;
    ColorOptionsCell{2,8}  = 'o-';           ColorOptionsCell{3,8}  = 'k';       ColorOptionsCell{4,8}  = .1;
    ColorOptionsCell{2,9}  = 'o-';           ColorOptionsCell{3,9}  = 'k';       ColorOptionsCell{4,9}  = .1;
    ColorOptionsCell{2,10} = 'o-';           ColorOptionsCell{3,10} = 'k';       ColorOptionsCell{4,10} = .1;
    ColorOptionsCell{2,11} = 'o-';           ColorOptionsCell{3,11} = 'k';       ColorOptionsCell{4,11} = .1;
    ColorOptionsCell{2,12} = 'o-';           ColorOptionsCell{3,12} = 'k';       ColorOptionsCell{4,12} = .1;
    ColorOptionsCell{2,13} = 'o-';           ColorOptionsCell{3,13} = 'k';       ColorOptionsCell{4,13} = .1;
    ColorOptionsCell{2,14} = 'o-';           ColorOptionsCell{3,14} = 'k';       ColorOptionsCell{4,14} = .1;
    ColorOptionsCell{2,15} = 'o--';          ColorOptionsCell{3,15} = 'k';       ColorOptionsCell{4,15} = .1;
    ColorOptionsCell{2,16} = 'o--';          ColorOptionsCell{3,16} = 'k';       ColorOptionsCell{4,16} = .1;
    ColorOptionsCell{2,17} = 'o-';           ColorOptionsCell{3,17} = 'k';       ColorOptionsCell{4,17} = .1;
    ColorOptionsCell{2,18} = '-';            ColorOptionsCell{3,18} = 'k';       ColorOptionsCell{4,18} = .1;
    ColorOptionsCell{2,19} = 'o';            ColorOptionsCell{3,19} = 'r';       ColorOptionsCell{4,19} = 3;
    ColorOptionsCell{2,20} = 'o';            ColorOptionsCell{3,20} = 'b';       ColorOptionsCell{4,20} = 3;
    ColorOptionsCell{2,21} = 'o';            ColorOptionsCell{3,21} = 'k';       ColorOptionsCell{4,21} = 3;
    ColorOptionsCell{2,21} = 'o';            ColorOptionsCell{3,21} = 'k';       ColorOptionsCell{4,21} = 3;
    
elseif coloring_option_chosen == 4
    fprintf('\n        Coloring option: Tandem 28 marker - Col.1 (37 Standard plug-in -> unsymmetric markers deleted!) coloring video option is chosen!')
    ColorOptionsCell = cell(4,4); % 4 lines
    
    % Markers to plot per line
    ColorOptionsCell{1,1} = [ 5,  7,  8,  9,  17,  18,  19,  20,  18,  17,  28,  26];
    ColorOptionsCell{1,2} = [ 1,  3,  4, 10,  21,  22,  23,  24,  22,  21,  27,  25];
    ColorOptionsCell{1,3} = [ 9, 10];
    ColorOptionsCell{1,4} = [17, 21];
    % Symbol and connection of each line      % Colors of each Markerface         % Markesizes for each line
    ColorOptionsCell{2,1} = 'o-';             ColorOptionsCell{3,1} = 'r';        ColorOptionsCell{4,1} = 5;
    ColorOptionsCell{2,2} = 'o-';             ColorOptionsCell{3,2} = 'g';        ColorOptionsCell{4,2} = 5;
    ColorOptionsCell{2,3} = 'o-';             ColorOptionsCell{3,3} = 'g';        ColorOptionsCell{4,3} = 1;
    ColorOptionsCell{2,4} = 'o-';             ColorOptionsCell{3,4} = 'g';        ColorOptionsCell{4,4} = 1;
    
elseif coloring_option_chosen == 5
    fprintf('\n        Coloring option: Tandem 28 marker - Col.2 (37 Standard plug-in -> unsymmetric markers deleted!) coloring video option is chosen!')
    ColorOptionsCell = cell(4,6); % 4 lines
    Markersize = 5;
    
    % Markers to plot per line
    ColorOptionsCell{1,1} = [ 5,  7,  8,  9,  17,  18,  19,  20,  18,  17,  28,  26];
    ColorOptionsCell{1,2} = [ 1,  3,  4, 10,  21,  22,  23,  24,  22,  21,  27,  25];
    ColorOptionsCell{1,3} = [ 9, 10];
    ColorOptionsCell{1,4} = [17, 21];
    ColorOptionsCell{1,5} = [27, 28];
    ColorOptionsCell{1,6} = [25, 26];

    % Symbol and connection of each Marker    % Colors of Markerface                % Markesizes for each Marker
    ColorOptionsCell{2,1} = 'o-k';            ColorOptionsCell{3,1} = 'w';          ColorOptionsCell{4,1} = Markersize;
    ColorOptionsCell{2,2} = 'o-k';            ColorOptionsCell{3,2} = 'k';          ColorOptionsCell{4,2} = Markersize;
    ColorOptionsCell{2,3} = '-k';             ColorOptionsCell{3,3} = 'k';          ColorOptionsCell{4,3} = Markersize/100;
    ColorOptionsCell{2,4} = '-k';             ColorOptionsCell{3,4} = 'k';          ColorOptionsCell{4,4} = Markersize/100;
    ColorOptionsCell{2,5} = '-k';             ColorOptionsCell{3,5} = 'k';          ColorOptionsCell{4,5} = Markersize/100;
    ColorOptionsCell{2,6} = '-k';             ColorOptionsCell{3,6} = 'k';          ColorOptionsCell{4,6} = Markersize/100;

elseif coloring_option_chosen == 6
%     fprintf('\n        Coloring option: Julians 14 marker coloring video option is chosen!')
%     ColorOptionsCell = cell(4,4); % 4 lines
%     
%     % Markers to plot per line
%     ColorOptionsCell{1,1} = [13, 14, 1, 2]; % Line 1 (Connection: Marker nr. 13-14-1-2)
%     ColorOptionsCell{1,2} = [11, 12]; % Line 2 (Connection: Marker nr. 11-12)
%     ColorOptionsCell{1,3} = [ 6,  1]; % Line 3 (Connection: Marker nr. 6-1)
%     ColorOptionsCell{1,4} = [ 2,  7]; % Line 4 (Connection: Marker nr. 1-7)
%     % Symbol and connection of each line      % Colors of each Markerface         % Markesizes for each line
%     ColorOptionsCell{2,1} = 'o-';             ColorOptionsCell{3,1} = 'r';        ColorOptionsCell{4,1} = 5;
%     ColorOptionsCell{2,2} = 'o-';             ColorOptionsCell{3,2} = 'g';        ColorOptionsCell{4,2} = 5;
%     ColorOptionsCell{2,3} = 'o-';             ColorOptionsCell{3,3} = 'b';        ColorOptionsCell{4,3} = 1;
%     ColorOptionsCell{2,4} = 'o-';             ColorOptionsCell{3,4} = 'b';        ColorOptionsCell{4,4} = 1;

elseif coloring_option_chosen == 7
%     fprintf('\n        Coloring option: Julians 14 marker coloring video option is chosen!')
%     ColorOptionsCell = cell(4,4); % 4 lines
%     
%     % Markers to plot per line
%     ColorOptionsCell{1,1} = [13, 14, 1, 2]; % Line 1 (Connection: Marker nr. 13-14-1-2)
%     ColorOptionsCell{1,2} = [11, 12]; % Line 2 (Connection: Marker nr. 11-12)
%     ColorOptionsCell{1,3} = [ 6,  1]; % Line 3 (Connection: Marker nr. 6-1)
%     ColorOptionsCell{1,4} = [ 2,  7]; % Line 4 (Connection: Marker nr. 1-7)
%     % Symbol and connection of each line      % Colors of each Markerface         % Markesizes for each line
%     ColorOptionsCell{2,1} = 'o-';             ColorOptionsCell{3,1} = 'r';        ColorOptionsCell{4,1} = 5;
%     ColorOptionsCell{2,2} = 'o-';             ColorOptionsCell{3,2} = 'g';        ColorOptionsCell{4,2} = 5;
%     ColorOptionsCell{2,3} = 'o-';             ColorOptionsCell{3,3} = 'b';        ColorOptionsCell{4,3} = 1;
%     ColorOptionsCell{2,4} = 'o-';             ColorOptionsCell{3,4} = 'b';        ColorOptionsCell{4,4} = 1;
    
else
    fprintf('\n        Video option chosen does not yet exist!!')
    msgbox('Video option Nr 6 is not yet implemented!', 'Error', 'Error')
    error('Video option Nr 6 is not yet implemented!')

end

end
end % function










