/*
 * Decompiled with CFR 0.152.
 */
package uibk.mtk.util;

import java.util.NoSuchElementException;
import uibk.mtk.util.Messages;

public abstract class ObjectIterator {
    double a;
    double b;
    int n;
    protected double step;
    protected int c;

    public ObjectIterator(int n) {
        this(0.0, 1.0, n);
    }

    protected ObjectIterator(double a, double b, int n) {
        if (n < 2) {
            throw new IllegalArgumentException(Messages.getString("ObjectIterator.0"));
        }
        this.n = n;
        this.a = a;
        this.b = b;
        this.step = (b - a) / (double)(n - 1);
    }

    public void reset() {
        this.c = 0;
    }

    public boolean hasNext() {
        return this.c < this.n;
    }

    public int getPos() {
        return this.c;
    }

    public int numberOfElements() {
        return this.n;
    }

    protected abstract Object getObjectAt(double var1);

    public Object next() throws NoSuchElementException {
        if (this.c >= this.n) {
            throw new NoSuchElementException("");
        }
        double t = this.getT();
        ++this.c;
        return this.getObjectAt(t);
    }

    public double getT() {
        double temp = this.a + (double)this.c * this.step;
        if (Math.abs(temp - this.b) < this.step / 2.0) {
            return this.b;
        }
        return temp;
    }
}

