/*
 * Decompiled with CFR 0.152.
 */
package uibk.mtk.math.regression;

import Jama.Matrix;
import Jama.QRDecomposition;
import uibk.mtk.math.regression.Messages;

public class Regression {
    Matrix X;
    Matrix Y;
    Matrix beta;
    private double rsquare;
    private double sse;
    private double ssr;
    private double syy;
    protected int k;
    protected int n;
    QRDecomposition qr;

    public Regression(int k) {
        this.k = k;
    }

    public Matrix getDataMatrix() {
        return this.X.copy();
    }

    public double[] getDependentVariable() {
        return this.Y.getColumnPackedCopy();
    }

    public void setDataMatrix(Matrix data) throws Exception {
        this.setDataMatrix(data.transpose().getArray());
    }

    public void setDataMatrix(double[][] data) throws Exception {
        if (data == null) {
            throw new IllegalArgumentException(Messages.getString("Regression.0"));
        }
        int rows = 0;
        int i = 0;
        while (i < data.length) {
            if (data[i] == null) {
                throw new IllegalArgumentException(Messages.getString("Regression.1"));
            }
            if (i == 0) {
                rows = data[0].length;
            } else if (rows != data[i].length) {
                throw new IllegalArgumentException(Messages.getString("Regression.2"));
            }
            ++i;
        }
        this.n = rows;
        this.X = this.setupRegressionMatrix(data);
        i = 0;
        while (i < this.X.getRowDimension()) {
            int j = 0;
            while (j < this.X.getColumnDimension()) {
                if (Double.isInfinite(this.X.get(i, j)) || Double.isNaN(this.X.get(i, j))) {
                    throw new Exception(Messages.getString("Regression.3"));
                }
                ++j;
            }
            ++i;
        }
        if (this.X.rank() != this.X.getColumnDimension()) {
            this.qr = null;
            throw new Exception(Messages.getString("Regression.4"));
        }
        this.qr = new QRDecomposition(this.X);
    }

    public void regress(double[] y) {
        if (y.length != this.X.getRowDimension()) {
            throw new IllegalArgumentException(Messages.getString("Regression.5"));
        }
        if (this.qr == null) {
            throw new IllegalStateException("");
        }
        this.n = y.length;
        this.Y = new Matrix(y, this.n);
        int i = 0;
        while (i < this.n) {
            this.Y.set(i, 0, y[i]);
            ++i;
        }
        this.beta = this.qr.solve(this.Y);
        this.calcAnova();
    }

    protected Matrix setupRegressionMatrix(double[][] data) {
        Matrix temp = new Matrix(this.n, this.k + 1);
        int i = 0;
        while (i < this.n) {
            temp.set(i, 0, 1.0);
            ++i;
        }
        i = 0;
        while (i < this.n) {
            int j = 0;
            while (j < this.k) {
                temp.set(i, j + 1, data[j][i]);
                ++j;
            }
            ++i;
        }
        return temp;
    }

    private double getYQuer() {
        double sum = 0.0;
        int i = 0;
        while (i < this.n) {
            sum += this.Y.get(i, 0);
            ++i;
        }
        return sum /= (double)this.n;
    }

    private void calcSSR() {
        double t1 = this.beta.transpose().times(this.X.transpose()).times(this.Y).get(0, 0);
        double yquer = this.getYQuer();
        this.ssr = t1 - (double)this.n * yquer * yquer;
    }

    private void calcAnova() {
        this.calcSSE();
        this.calcSSR();
        this.syy = this.ssr + this.sse;
        this.rsquare = this.ssr / this.syy;
    }

    private void calcSSE() {
        double t1 = this.Y.transpose().times(this.Y).get(0, 0);
        double t2 = this.beta.transpose().times(this.X.transpose()).times(this.Y).get(0, 0);
        this.sse = t1 - t2;
    }

    public double getSSR() {
        return this.ssr;
    }

    public double getSSY() {
        return this.syy;
    }

    public double getSSE() {
        return this.sse;
    }

    public double getrsquare() {
        return this.rsquare;
    }

    public double[] getCoefficients() {
        if (this.beta == null) {
            return null;
        }
        double[] coeff = new double[this.k + 1];
        int i = 0;
        while (i < this.k + 1) {
            coeff[i] = this.beta.get(i, 0);
            ++i;
        }
        return coeff;
    }

    public int getNumberVars() {
        return this.k;
    }
}

