/*
 * Decompiled with CFR 0.152.
 */
package uibk.mtk.math.regression;

import Jama.Matrix;
import java.util.Vector;
import uibk.mtk.math.functions.Function;
import uibk.mtk.math.regression.Messages;
import uibk.mtk.math.regression.Regression;

public class FormFunctionRegression
extends Regression {
    Vector formfuntions = new Vector();
    int numberofvars;

    public FormFunctionRegression(int n, Function[] functions) {
        super(functions.length);
        this.numberofvars = n;
        this.setFormFunctions(functions);
    }

    private void setFormFunctions(Function[] functions) {
        if (functions == null) {
            throw new IllegalArgumentException("");
        }
        int nvars = 0;
        int i = 0;
        while (i < this.k) {
            if (i == 0) {
                nvars = functions[i].getNumberVars();
            }
            if (functions[i].getNumberVars() != nvars && functions[i].getNumberFunctions() != 1) {
                throw new IllegalArgumentException(Messages.getString("FormFunctionRegression.1"));
            }
            this.formfuntions.add(functions[i]);
            ++i;
        }
    }

    @Override
    protected Matrix setupRegressionMatrix(double[][] data) {
        Matrix temp = new Matrix(this.n, this.k + 1);
        int i = 0;
        while (i < this.n) {
            temp.set(i, 0, 1.0);
            ++i;
        }
        double[] tt = new double[this.numberofvars];
        int i2 = 0;
        while (i2 < this.n) {
            int j = 0;
            while (j < this.numberofvars) {
                tt[j] = data[j][i2];
                ++j;
            }
            j = 0;
            while (j < this.k) {
                Function f = (Function)this.formfuntions.elementAt(j);
                temp.set(i2, j + 1, f.getValue(tt)[0]);
                ++j;
            }
            ++i2;
        }
        return temp;
    }

    public Function getPredictionFunction() {
        Function f = new Function(this.numberofvars, 1){

            @Override
            public double[] getValue(double[] x) {
                double sum = 0.0;
                int i = 0;
                while (i < FormFunctionRegression.this.formfuntions.size()) {
                    sum += ((Function)FormFunctionRegression.this.formfuntions.elementAt(i)).getValue(x)[0] * FormFunctionRegression.this.beta.get(i + 1, 0);
                    ++i;
                }
                double[] temp = new double[]{sum += FormFunctionRegression.this.beta.get(0, 0)};
                return temp;
            }
        };
        return f;
    }

    public String[] getFormFunctions() {
        if (this.formfuntions == null) {
            return new String[0];
        }
        String[] str = new String[this.formfuntions.size()];
        int i = 0;
        while (i < this.formfuntions.size()) {
            str[i] = ((Function)this.formfuntions.elementAt(i)).toString();
            ++i;
        }
        return str;
    }
}

