/*
 * Decompiled with CFR 0.152.
 */
package uibk.mtk.math.regression;

import Jama.Matrix;
import java.util.Hashtable;
import uibk.mtk.lang.ComputationException;
import uibk.mtk.lang.InputException;
import uibk.mtk.math.combinatorics.Combinations;
import uibk.mtk.math.combinatorics.Permutations;
import uibk.mtk.math.regression.IntegerSet;
import uibk.mtk.math.regression.Messages;
import uibk.mtk.math.regression.Regression;

public class ErklaerungsAnteil {
    Hashtable results = new Hashtable();
    private Matrix X;
    int k;
    double[] explanation;
    Regression regression;

    public ErklaerungsAnteil(Regression reg) {
        this.regression = reg;
        this.k = this.regression.getNumberVars();
        this.X = this.regression.getDataMatrix();
    }

    private double getPartBestimmtheit(int k, int[] vars) {
        if (vars == null) {
            int[] temp = new int[]{k};
            double ssr_with = (Double)this.results.get(new IntegerSet(temp));
            double ssr_without = 0.0;
            return (ssr_with - ssr_without) / this.regression.getSSY();
        }
        int[] varswithk = this.combine(vars, k);
        double ssr_with = (Double)this.results.get(new IntegerSet(varswithk));
        double ssr_without = (Double)this.results.get(new IntegerSet(vars));
        return (ssr_with - ssr_without) / this.regression.getSSY();
    }

    public void explain() throws Exception {
        this.explanation = null;
        if (this.k == 1) {
            this.explanation = new double[1];
            this.explanation[0] = this.regression.getrsquare();
            return;
        }
        if (this.k > 20) {
            throw new InputException(Messages.getString("ErklaerungsAnteil.0"));
        }
        this.computeRegressions();
        double[] sum = new double[this.k];
        long count = Permutations.factorial(this.k);
        Permutations permutations = new Permutations(this.k);
        while (permutations.hasNext()) {
            int[] perm = permutations.next();
            int j = 0;
            while (j < perm.length) {
                int var = perm[j];
                int n = var - 1;
                sum[n] = sum[n] + this.getPartBestimmtheit(var, this.get(perm, j));
                ++j;
            }
        }
        this.explanation = new double[this.k];
        int i = 0;
        while (i < this.k) {
            this.explanation[i] = sum[i] / (double)count;
            ++i;
        }
    }

    private int[] get(int[] array, int n) {
        int[] ret;
        if (n <= 0) {
            ret = null;
        } else {
            ret = new int[n];
            System.arraycopy(array, 0, ret, 0, n);
        }
        return ret;
    }

    private void computeRegressions() throws Exception {
        this.results.clear();
        double[] y = this.regression.getDependentVariable();
        int j = 1;
        while (j <= this.k) {
            Combinations combinations = new Combinations(this.k, j);
            while (combinations.hasNext()) {
                int[] vars = combinations.next();
                IntegerSet set = new IntegerSet(vars);
                Regression reg = new Regression(vars.length);
                reg.setDataMatrix(this.X.getMatrix(0, this.X.getRowDimension() - 1, vars));
                try {
                    reg.regress(y);
                }
                catch (Exception e) {
                    throw new ComputationException(Messages.getString("ErklaerungsAnteil.1"));
                }
                Double ssr = new Double(reg.getSSR());
                this.results.put(set, ssr);
            }
            ++j;
        }
    }

    private int[] combine(int[] a, int b) {
        int n = a.length;
        int[] temp = new int[n + 1];
        System.arraycopy(a, 0, temp, 0, n);
        temp[n] = b;
        return temp;
    }

    public double[] getExplanation() {
        if (this.explanation == null) {
            return null;
        }
        return (double[])this.explanation.clone();
    }

    public double[] getFullExplanation() {
        int n = this.explanation.length;
        double[] a = new double[n + 1];
        double sum = 0.0;
        int i = 0;
        while (i < n) {
            sum += this.explanation[i];
            a[i] = this.explanation[i];
            ++i;
        }
        a[n] = sum >= 1.0 ? 0.0 : 1.0 - sum;
        return a;
    }
}

