/*
 * Decompiled with CFR 0.152.
 */
package uibk.mtk.math.combinatorics;

import java.util.NoSuchElementException;
import uibk.mtk.math.combinatorics.Messages;

public class Permutations {
    private long fac;
    private int[] data;
    private int size;
    private long count;

    public Permutations(int k) {
        if (k > 20) {
            throw new IllegalArgumentException(Messages.getString("Permutations.0"));
        }
        if (k < 1) {
            throw new IllegalArgumentException(Messages.getString("Permutations.1"));
        }
        this.size = k;
        this.fac = Permutations.factorial(k);
        this.count = 0L;
        this.data = new int[k];
        int i = 0;
        while (i < k) {
            this.data[i] = i + 1;
            ++i;
        }
    }

    public static long factorial(int n) {
        long fac = 1L;
        int nn = Math.abs(n);
        if (nn > 20) {
            throw new IllegalArgumentException(Messages.getString("Permutations.2"));
        }
        if (nn >= 1) {
            int i = 1;
            while (i <= n) {
                fac *= (long)i;
                ++i;
            }
            return fac;
        }
        return 1L;
    }

    private void swap(int i, int j) {
        int temp = this.data[i];
        this.data[i] = this.data[j];
        this.data[j] = temp;
    }

    private void getNext() {
        int i = this.size - 1;
        while (this.data[i - 1] >= this.data[i]) {
            --i;
        }
        int j = this.size;
        while (this.data[j - 1] <= this.data[i - 1]) {
            --j;
        }
        this.swap(i - 1, j - 1);
        ++i;
        j = this.size;
        while (i < j) {
            this.swap(i - 1, j - 1);
            ++i;
            --j;
        }
    }

    public boolean hasNext() {
        return this.count < this.fac;
    }

    public int[] next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("");
        }
        if (this.count > 0L) {
            this.getNext();
        }
        ++this.count;
        return (int[])this.data.clone();
    }
}

