/*
 * Decompiled with CFR 0.152.
 */
package uibk.mtk.draw2d.objects;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.Vector;
import uibk.mtk.draw2d.base.Drawable2D;
import uibk.mtk.draw2d.base.MathPanel2D;
import uibk.mtk.draw2d.objects.Graph2D;
import uibk.mtk.draw2d.objects.MathPoint2D;
import uibk.mtk.geom.CoordinateRect2D;
import uibk.mtk.geom.Punkt2D;
import uibk.mtk.lang.ToolTipable;

public class PointPlot2D
extends Graph2D
implements ToolTipable {
    protected Color linecolor;
    protected int pointradius;
    protected boolean tooltipenabled;
    protected Vector points = new Vector();
    boolean connectpoints = false;

    public void connectPoints(boolean enable) {
        this.connectpoints = enable;
    }

    public void setPointRadius(int pointradius) {
        this.pointradius = pointradius;
    }

    public void setLineColor(Color linecolor) {
        this.linecolor = linecolor;
    }

    @Override
    public void setColor(Color pointcolor) {
        super.setColor(pointcolor);
        int i = 0;
        while (i < this.points.size()) {
            ((MathPoint2D)this.points.elementAt(i)).setColor(pointcolor);
            ++i;
        }
    }

    @Override
    public boolean tooltipcontains(int x, int y) {
        int ct = this.points.size();
        int i = 0;
        while (i < ct) {
            MathPoint2D p = (MathPoint2D)this.points.elementAt(i);
            if (p.tooltipcontains(x, y)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public String getToolTipText(MouseEvent ev) {
        int size = this.points.size();
        int i = 0;
        while (i < size) {
            MathPoint2D p = (MathPoint2D)this.points.elementAt(i);
            if (p.tooltipcontains(ev.getX(), ev.getY())) {
                return "(" + p.getX() + "," + p.getY() + ")";
            }
            ++i;
        }
        return null;
    }

    @Override
    public void setToolTipText(String tooltip) {
    }

    @Override
    public boolean isToolTipEnabled() {
        return this.tooltipenabled;
    }

    @Override
    public void enableToolTip(boolean enabled) {
        this.tooltipenabled = enabled;
    }

    @Override
    public void setMathPanel2D(MathPanel2D panel) {
        super.setMathPanel2D(panel);
        int ct = this.points.size();
        int i = 0;
        while (i < ct) {
            ((Drawable2D)this.points.elementAt(i)).setMathPanel2D(panel);
            ++i;
        }
    }

    public PointPlot2D() {
        this.linecolor = Color.blue;
        this.color = Color.red;
        this.pointradius = 2;
        this.stroke = new BasicStroke(1.0f);
        this.tooltipenabled = true;
    }

    public void setPoints(double[] x, double[] y) {
        this.points.clear();
        int i = 0;
        while (i < x.length) {
            this.addMathPoint(x[i], y[i]);
            ++i;
        }
        this.limitsdirty = true;
    }

    private void addMathPoint(double x, double y) {
        MathPoint2D mp = new MathPoint2D(x, y);
        mp.setMathPanel2D(this.panel);
        mp.setRadius(this.pointradius);
        mp.setColor(this.color);
        this.points.add(mp);
    }

    @Override
    public void draw(BufferedImage framebuffer, Graphics2D g2) {
        int size = this.points.size();
        int i = 0;
        while (i < size) {
            Drawable2D d = (Drawable2D)this.points.elementAt(i);
            if (d.isVisible()) {
                if (i < size - 1) {
                    MathPoint2D start = (MathPoint2D)this.points.elementAt(i);
                    MathPoint2D end = (MathPoint2D)this.points.elementAt(i + 1);
                    g2.setColor(this.linecolor);
                    g2.setStroke(this.stroke);
                    if (this.connectpoints) {
                        g2.drawLine(this.scene2d.xToPixel(start.getX()), this.scene2d.yToPixel(start.getY()), this.scene2d.xToPixel(end.getX()), this.scene2d.yToPixel(end.getY()));
                    }
                }
                d.draw(framebuffer, g2);
            }
            ++i;
        }
    }

    @Override
    public void setPoints(Vector points) {
        this.points = points;
        this.limitsdirty = true;
    }

    @Override
    public void addPoint(Punkt2D p) {
        this.addMathPoint(p.x, p.y);
        this.limitsdirty = true;
    }

    @Override
    public void addPoint(double x, double y) {
        this.points.add(new Punkt2D(x, y));
        this.limitsdirty = true;
    }

    @Override
    protected void recalcLimits() {
        this.limits = this.points != null && this.points.size() > 0 ? PointPlot2D.getLimits(this.points) : new CoordinateRect2D(-1.0, 1.0, -1.0, 1.0);
    }

    public static CoordinateRect2D getLimits(Vector points) {
        double maximumx = Double.NEGATIVE_INFINITY;
        double maximumy = Double.NEGATIVE_INFINITY;
        double minimumx = Double.POSITIVE_INFINITY;
        double minimumy = Double.POSITIVE_INFINITY;
        int i = 0;
        while (i < points.size()) {
            if (points.elementAt(i) != null && ((MathPoint2D)points.elementAt((int)i)).x > maximumx) {
                maximumx = ((MathPoint2D)points.elementAt((int)i)).x;
            }
            ++i;
        }
        i = 0;
        while (i < points.size()) {
            if (points.elementAt(i) != null && ((MathPoint2D)points.elementAt((int)i)).y > maximumy) {
                maximumy = ((MathPoint2D)points.elementAt((int)i)).y;
            }
            ++i;
        }
        i = 0;
        while (i < points.size()) {
            if (points.elementAt(i) != null && ((MathPoint2D)points.elementAt((int)i)).x < minimumx) {
                minimumx = ((MathPoint2D)points.elementAt((int)i)).x;
            }
            ++i;
        }
        i = 0;
        while (i < points.size()) {
            if (points.elementAt(i) != null && ((MathPoint2D)points.elementAt((int)i)).y < minimumy) {
                minimumy = ((MathPoint2D)points.elementAt((int)i)).y;
            }
            ++i;
        }
        return new CoordinateRect2D(minimumx, maximumx, minimumy, maximumy);
    }
}

