/*
 * Decompiled with CFR 0.152.
 */
package uibk.applets.regression;

import java.awt.Color;
import java.awt.Dimension;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import uibk.applets.regression.Messages;
import uibk.mtk.math.regression.FormFunctionRegression;
import uibk.mtk.swing.PieChart;
import uibk.mtk.swing.base.MPanel;

public class PanelOutput
extends MPanel {
    DecimalFormat format = new DecimalFormat("0.0000", new DecimalFormatSymbols(Locale.US));
    JLabel labelrsquare = new JLabel("");
    JLabel labelsse = new JLabel("");
    JLabel labelssr = new JLabel("");
    JLabel labelssy = new JLabel("");
    JLabel labelprediction = new JLabel("");
    JLabel labelheader1 = new JLabel(Messages.getString("PanelOutput.24"));
    JLabel labelheader2 = new JLabel("");
    PieChart piechart = new PieChart();
    private static String FORMATCOLOR = Messages.getString("PanelOutput.8");

    public PanelOutput() {
        this.initComponents();
    }

    void initComponents() {
        this.labelheader1.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.labelheader2.setBorder(BorderFactory.createEmptyBorder(20, 5, 5, 5));
        this.labelssr.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.labelsse.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.labelssy.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.labelrsquare.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.labelprediction.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setLayout(new BoxLayout(this, 1));
        this.setMinimumSize(new Dimension(300, 300));
        this.add(this.labelheader1);
        this.add(this.labelrsquare);
        this.add(this.labelssy);
        this.add(this.labelssr);
        this.add(this.labelsse);
        this.add(this.labelprediction);
        this.add(this.labelheader2);
        this.add(this.piechart);
    }

    public void createOutput(FormFunctionRegression regression, double[] fractions, String[] labels, Color[] colors) {
        this.labelssy.setText(this.makeString(Messages.getString("PanelOutput.9"), this.format.format(regression.getSSY())));
        this.labelsse.setText(this.makeString(Messages.getString("PanelOutput.10"), this.format.format(regression.getSSE())));
        this.labelssr.setText(this.makeString(Messages.getString("PanelOutput.11"), this.format.format(regression.getSSR())));
        this.labelrsquare.setText(this.makeString(Messages.getString("PanelOutput.12"), this.format.format(regression.getrsquare())));
        this.labelprediction.setText(this.makeString(Messages.getString("PanelOutput.13"), this.formatPredictionFunc(regression, this.format)));
        if (fractions != null) {
            this.labelheader2.setText(Messages.getString("PanelOutput.14"));
            this.piechart.setFractions(fractions, labels, colors);
            this.piechart.setVisible(true);
        } else {
            this.labelheader2.setText("");
            this.piechart.setVisible(false);
        }
    }

    public void clear() {
        this.labelrsquare.setText("");
        this.labelsse.setText("");
        this.labelrsquare.setText("");
        this.labelssy.setText("");
        this.labelssr.setText("");
        this.labelrsquare.setText("");
        this.labelprediction.setText("");
        this.labelheader2.setText("");
        this.labelheader1.setText(Messages.getString("PanelOutput.24"));
        this.piechart.setVisible(false);
    }

    private String formatPredictionFunc(FormFunctionRegression regression, DecimalFormat format) {
        String str = "";
        int k = regression.getNumberVars();
        String[] functions = regression.getFormFunctions();
        double[] coeffs = regression.getCoefficients();
        int i = 0;
        while (i <= k) {
            double coeff = coeffs[i];
            if (coeff != 0.0) {
                if (coeff > 0.0 && i > 0) {
                    str = String.valueOf(str) + "+";
                }
                str = String.valueOf(str) + format.format(coeff);
                if (i > 0) {
                    str = String.valueOf(str) + functions[i - 1];
                }
            }
            ++i;
        }
        return str;
    }

    private String makeString(String name, String value) {
        String str = "<html><font color=" + FORMATCOLOR + ">" + name + ": </font>" + value;
        return str;
    }
}

