/*
 * Decompiled with CFR 0.152.
 */
package uibk.applets.regression;

import java.awt.Color;
import java.util.Arrays;
import java.util.Vector;
import uibk.applets.regression.AppletRegression;
import uibk.applets.regression.Messages;
import uibk.applets.regression.PanelRegression;
import uibk.mtk.geom.CoordinateRect2D;
import uibk.mtk.geom.Punkt2D;
import uibk.mtk.math.functions.Function;
import uibk.mtk.math.parsing.Misc;
import uibk.mtk.math.regression.ErklaerungsAnteil;
import uibk.mtk.math.regression.RegressionCreator;
import uibk.mtk.text.Formatter;
import uibk.mtk.util.IntervalIterator;

public class Control {
    AppletRegression main;
    PanelRegression panelregression;
    int dependentvarindex;
    int[] independentvarsindex;
    String dependentvar;
    String[] independentvars;
    String[] formfunctions;
    private static Color[] colors = new Color[]{new Color(152, 198, 243), new Color(243, 244, 185), new Color(151, 232, 180), new Color(200, 200, 200), new Color(228, 184, 154), Color.yellow, new Color(196, 194, 117)};

    public Control(AppletRegression main, PanelRegression panelregression) {
        this.main = main;
        this.panelregression = panelregression;
    }

    private boolean getDependentVariable() {
        int k = this.main.table.getColumnCount() - 1;
        String temp = this.panelregression.textDependentVar.getText().trim();
        boolean match = false;
        int i = 1;
        while (i <= k) {
            if (temp.equals("x" + i)) {
                match = true;
                break;
            }
            ++i;
        }
        if (match) {
            this.dependentvar = temp;
            this.dependentvarindex = i;
            return true;
        }
        this.main.mathpanel2d.reportError(String.valueOf(Messages.getString("Control.0")) + "x" + "1,..," + "x" + k + Messages.getString("Control.2"));
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean getIndependentVariables() {
        String str = this.panelregression.textFormFunctions.getText().trim();
        if (str == null || str.equals("")) {
            this.main.mathpanel2d.reportError(Messages.getString("Control.4"));
            return false;
        }
        int[] indices = null;
        try {
            indices = Misc.parseVarsIndices(",", "x", str);
            if (indices == null || indices.length == 0) {
                this.main.mathpanel2d.reportError(Messages.getString("Control.6"));
                return false;
            }
            this.independentvarsindex = indices;
            int j = 0;
            while (j < this.independentvarsindex.length) {
                if (this.independentvarsindex[j] > this.main.table.getColumnCount() - 1 || this.independentvarsindex[j] == 0) {
                    this.main.mathpanel2d.reportError(String.valueOf(Messages.getString("Control.7")) + this.independentvarsindex[j]);
                    return false;
                }
                ++j;
            }
            this.independentvars = new String[indices.length];
            j = 0;
            while (j < indices.length) {
                this.independentvars[j] = "x" + indices[j];
                ++j;
            }
            return true;
        }
        catch (Exception e) {
            this.main.mathpanel2d.reportError(e);
            return false;
        }
    }

    private boolean getFormFunctions() {
        String strfunc = this.panelregression.textFormFunctions.getText();
        if (strfunc == null || strfunc.equals("")) {
            this.main.mathpanel2d.reportError(Messages.getString("Control.9"));
            return false;
        }
        this.formfunctions = Misc.split(strfunc, ",");
        return true;
    }

    double[] getDataY() {
        return this.main.table.getDataCol(this.dependentvarindex);
    }

    double[][] getDataX() {
        return this.main.table.getDataCols(this.independentvarsindex);
    }

    private boolean createRegression() {
        if (!(this.getDependentVariable() && this.getIndependentVariables() && this.getFormFunctions())) {
            return false;
        }
        int i = 0;
        while (i < this.independentvarsindex.length) {
            if (this.independentvarsindex[i] == this.dependentvarindex) {
                this.main.mathpanel2d.reportError(String.valueOf(Messages.getString("Control.11")) + this.dependentvar + Messages.getString("Control.12"));
                return false;
            }
            ++i;
        }
        try {
            this.main.regression = RegressionCreator.create(this.formfunctions, this.independentvars);
        }
        catch (Exception e) {
            this.main.mathpanel2d.reportError(e);
            return false;
        }
        return true;
    }

    private Color[] getPieChartColors(int n) {
        Color[] col = new Color[n + 1];
        col[n] = Color.red;
        int i = 0;
        while (i < n) {
            col[i] = colors[i];
            ++i;
        }
        return col;
    }

    void compute() {
        if (this.main.table.isEmpty()) {
            this.main.mathpanel2d.reportError(Messages.getString("Control.13"));
            return;
        }
        if (this.main.table.getRowCount() < this.main.table.getColumnCount() - 1) {
            this.main.mathpanel2d.reportError(Messages.getString("Control.14"));
            return;
        }
        if (!this.main.table.isComplete()) {
            this.main.mathpanel2d.reportError(Messages.getString("Control.15"));
            return;
        }
        if (!this.createRegression()) {
            return;
        }
        try {
            this.main.regression.setDataMatrix(this.getDataX());
            this.main.regression.regress(this.getDataY());
            double[] expl = null;
            if (this.main.regression.getNumberVars() <= 7) {
                this.main.erkl = new ErklaerungsAnteil(this.main.regression);
                this.main.erkl.explain();
                expl = this.main.erkl.getFullExplanation();
            }
            String[] names = this.formfunctions;
            String[] legend = this.append(names, Messages.getString("Control.16"));
            int n = this.main.regression.getNumberVars();
            Color[] chartcolors = this.getPieChartColors(n);
            this.main.paneloutput.createOutput(this.main.regression, expl, legend, chartcolors);
            this.plot();
            Formatter f = new Formatter();
            if (this.main.regression.getNumberVars() <= 7) {
                this.main.mathpanel2d.reportSuccess(String.valueOf(Messages.getString("Control.17")) + f.formatplaces(this.main.regression.getrsquare(), 4));
            } else {
                this.main.mathpanel2d.reportSuccess(String.valueOf(Messages.getString("Control.18")) + f.formatplaces(this.main.regression.getrsquare(), 4) + Messages.getString("Control.19") + 7 + Messages.getString("Control.20"));
            }
            this.main.paneloutput.repaint();
            this.main.mathpanel2d.repaint();
        }
        catch (Exception e) {
            this.main.mathpanel2d.reportError(e);
            this.main.paneloutput.clear();
        }
    }

    private String[] append(String[] a, String item) {
        int n = a.length;
        String[] temp = new String[n + 1];
        System.arraycopy(a, 0, temp, 0, n);
        temp[n] = item;
        return temp;
    }

    void plot() {
        this.main.graph2d.clearpoints();
        this.main.pointplot.clearpoints();
        if (this.independentvars.length != 1) {
            this.main.mathpanel2d.setVisible(false);
            return;
        }
        this.main.mathpanel2d.setVisible(true);
        double[][] data = this.getDataX();
        double[] x = data[0];
        this.main.graph2d.setColor(AppletRegression.PLOTCOLOR);
        double[] dummy = (double[])x.clone();
        Arrays.sort(dummy);
        double min = dummy[0];
        double max = dummy[x.length - 1];
        this.main.pointplot.setPoints(x, this.main.regression.getDependentVariable());
        Function f = this.main.regression.getPredictionFunction();
        double[] temp = new double[1];
        Vector<Punkt2D> v = new Vector<Punkt2D>();
        IntervalIterator it = new IntervalIterator(min, max, 300);
        while (it.hasNext()) {
            double t;
            temp[0] = t = it.nextdouble();
            v.add(new Punkt2D(t, f.getValue(temp)[0]));
        }
        this.main.graph2d.setPoints(v);
        CoordinateRect2D limits1 = this.main.graph2d.getLimits();
        CoordinateRect2D limits2 = this.main.pointplot.getLimits();
        this.main.mathpanel2d.getScene2d().setLimits(limits1.combine(limits2));
    }
}

