/*
 * Decompiled with CFR 0.152.
 */
package uibk.mtk.math.functions;

import uibk.mtk.lang.Messages;
import uibk.mtk.lang.Settings;
import uibk.mtk.math.functions.DerivationException;

public abstract class Function {
    private static final String BUNDLE_NAME = "uibk.mtk.math.functions.messages";
    protected int n;
    protected int m;
    static final double SAFETYFACTOR = 1000.0;
    private double[] temp;
    private double[] forwarddiff;
    private double[] backwarddiff;
    protected boolean checkdiff = true;

    public Function(int n, int m) {
        this.m = m;
        this.n = n;
        this.temp = new double[n];
        this.forwarddiff = new double[m];
        this.backwarddiff = new double[m];
    }

    public int getNumberVars() {
        return this.n;
    }

    public int getNumberFunctions() {
        return this.m;
    }

    public abstract double[] getValue(double[] var1);

    private double gethSymm1(double x) {
        double hsym = Math.pow(Settings.getMachinePrecision(), 0.3333333333333333);
        double s = Math.max(1.0, Math.abs(x));
        return hsym * s;
    }

    private double getHForBack1(double x) {
        double hsym = Math.pow(Settings.getMachinePrecision(), 0.5);
        double s = Math.max(1.0, Math.abs(x));
        return hsym * s;
    }

    private double gethSymm2(double x) {
        double hsym = Math.pow(Settings.getMachinePrecision(), 0.25);
        double s = Math.max(1.0, Math.abs(x));
        return hsym * s;
    }

    private double getHForBack2(double x) {
        double hsym = Math.pow(Settings.getMachinePrecision(), 0.3333333333333333);
        double s = Math.max(1.0, Math.abs(x));
        return hsym * s;
    }

    public double[][] getJacobian(double[] x) throws DerivationException {
        if (x.length != this.n) {
            throw new IllegalArgumentException(Messages.getString(BUNDLE_NAME, "Function.0"));
        }
        double[][] jacob = new double[this.m][this.n];
        System.arraycopy(x, 0, this.temp, 0, this.n);
        int j = 0;
        while (j < this.n) {
            if (this.checkdiff) {
                this.check_derivate1(x[j]);
            }
            double t = x[j];
            double h = this.gethSymm1(t);
            this.temp[j] = t + h;
            double[] forward = this.getValue(this.temp);
            this.temp[j] = t - h;
            double[] backward = this.getValue(this.temp);
            this.temp[j] = t;
            int k = 0;
            while (k < this.m) {
                jacob[k][j] = (forward[k] - backward[k]) / (2.0 * h);
                if (this.checkdiff && (Double.isInfinite(jacob[k][j]) || Double.isNaN(jacob[k][j]))) {
                    throw new DerivationException(Messages.getString(BUNDLE_NAME, "Function.1"));
                }
                ++k;
            }
            ++j;
        }
        return jacob;
    }

    private void check_derivate2(double x) throws DerivationException {
        double h = this.getHForBack2(x);
        double[] center = this.getValue(new double[]{x});
        double[] forward = this.getValue(new double[]{x + h});
        double[] backward = this.getValue(new double[]{x - h});
        double[] forward2 = this.getValue(new double[]{x + 2.0 * h});
        double[] backward2 = this.getValue(new double[]{x - 2.0 * h});
        double[] forward3 = this.getValue(new double[]{x + 3.0 * h});
        double[] backward3 = this.getValue(new double[]{x - 3.0 * h});
        int k = 0;
        while (k < this.m) {
            double forwardDiff = (2.0 * center[k] - 5.0 * forward[k] + 4.0 * forward2[k] - forward3[k]) / (h * h);
            double backwardDiff = (2.0 * center[k] - 5.0 * backward[k] + 4.0 * backward2[k] - backward3[k]) / (h * h);
            double scale = Math.max(1.0, Math.max(Math.abs(forward[k]), Math.abs(backward[k])));
            double estimated_acurracy = Math.pow(h, 0.6666666666666666) * scale;
            if (Double.isInfinite(forwardDiff) || Double.isNaN(forwardDiff) || Double.isInfinite(backwardDiff) || Double.isNaN(backwardDiff) || Math.abs(forwardDiff - backwardDiff) > 1000.0 * estimated_acurracy) {
                throw new DerivationException(Messages.getString(BUNDLE_NAME, "Function.2"));
            }
            ++k;
        }
    }

    void check_derivate1(double t) throws DerivationException {
        int j = 0;
        while (j < this.n) {
            double h = this.getHForBack1(t);
            this.temp[j] = t + h;
            double[] forward = this.getValue(this.temp);
            this.temp[j] = t - h;
            double[] backward = this.getValue(this.temp);
            this.temp[j] = t;
            double[] center = this.getValue(this.temp);
            int k = 0;
            while (k < this.m) {
                this.forwarddiff[k] = (forward[k] - center[k]) / h;
                this.backwarddiff[k] = (center[k] - backward[k]) / h;
                double scale = Math.max(1.0, Math.max(Math.abs(forward[k]), Math.abs(backward[k])));
                double estimated_acurracy = Math.sqrt(h) * scale;
                if (Double.isInfinite(backward[k]) || Double.isNaN(backward[k]) || Double.isInfinite(forward[k]) || Double.isNaN(forward[k]) || Math.abs(this.forwarddiff[k] - this.backwarddiff[k]) > 1000.0 * estimated_acurracy) {
                    throw new DerivationException(Messages.getString(BUNDLE_NAME, "Function.3"));
                }
                ++k;
            }
            ++j;
        }
    }

    protected double[] getDerivation2(double[] y) throws DerivationException {
        if (this.n != 1) {
            throw new IllegalArgumentException(Messages.getString(BUNDLE_NAME, "Function.4"));
        }
        if (y.length != 1) {
            throw new IllegalArgumentException(Messages.getString(BUNDLE_NAME, "Function.5"));
        }
        double x = y[0];
        if (this.checkdiff) {
            this.check_derivate2(x);
        }
        double h = this.gethSymm2(x);
        double[] ret = new double[this.m];
        double[] center = this.getValue(y);
        double[] forward = this.getValue(new double[]{x + h});
        double[] backward = this.getValue(new double[]{x - h});
        int k = 0;
        while (k < this.m) {
            ret[k] = (forward[k] - 2.0 * center[k] + backward[k]) / (h * h);
            if (this.checkdiff && (Double.isInfinite(ret[k]) || Double.isInfinite(ret[k]))) {
                throw new DerivationException(Messages.getString(BUNDLE_NAME, "Function.6"));
            }
            ++k;
        }
        return ret;
    }

    protected double getEstimatedErrorFirstDeriv(double x) {
        double h = this.gethSymm1(x);
        return Math.pow(h, 0.6666666666666666);
    }

    protected double getEstimatedErrorSecondDeriv(double x) {
        double h = this.gethSymm2(x);
        return Math.pow(h, 0.6666666666666666);
    }

    public double[] directionalDerivate(double[] x, double[] dir) throws DerivationException {
        if (x.length != this.n) {
            throw new IllegalArgumentException(Messages.getString(BUNDLE_NAME, "Function.7"));
        }
        double[] v = (double[])dir.clone();
        double sum = 0.0;
        int i = 0;
        while (i < this.n) {
            sum += v[i] * v[i];
            ++i;
        }
        sum = Math.sqrt(sum);
        i = 0;
        while (i < this.n) {
            int n = i++;
            v[n] = v[n] / sum;
        }
        if (this.checkdiff) {
            this.check_directional(x, v);
        }
        double h = this.gethSymm1(x[0]);
        double[] ftemp = new double[this.n];
        double[] btemp = new double[this.n];
        int i2 = 0;
        while (i2 < this.n) {
            ftemp[i2] = x[i2] + h * v[i2];
            btemp[i2] = x[i2] - h * v[i2];
            ++i2;
        }
        double[] forward = this.getValue(ftemp);
        double[] backward = this.getValue(btemp);
        double[] deriv = new double[this.m];
        int k = 0;
        while (k < this.m) {
            deriv[k] = (forward[k] - backward[k]) / (2.0 * h);
            if (this.checkdiff && (Double.isInfinite(deriv[k]) || Double.isNaN(deriv[k]))) {
                throw new DerivationException(Messages.getString(BUNDLE_NAME, "Function.8"));
            }
            ++k;
        }
        return deriv;
    }

    private void check_directional(double[] x, double[] v) throws DerivationException {
        double h = this.getHForBack1(x[0]);
        double[] ftemp = new double[this.n];
        double[] btemp = new double[this.n];
        int i = 0;
        while (i < this.n) {
            ftemp[i] = x[i] + h * v[i];
            btemp[i] = x[i] - h * v[i];
            ++i;
        }
        double[] forward = this.getValue(ftemp);
        double[] center = this.getValue(x);
        double[] backward = this.getValue(btemp);
        int k = 0;
        while (k < this.m) {
            this.forwarddiff[k] = (forward[k] - center[k]) / h;
            this.backwarddiff[k] = (center[k] - backward[k]) / h;
            double estimated_acuuracy = Math.sqrt(h);
            if (Double.isInfinite(backward[k]) || Double.isNaN(backward[k]) || Double.isInfinite(forward[k]) || Double.isNaN(forward[k]) || Math.abs(this.forwarddiff[k] - this.backwarddiff[k]) > 1000.0 * estimated_acuuracy) {
                throw new DerivationException(Messages.getString(BUNDLE_NAME, "Function.9"));
            }
            ++k;
        }
    }

    public void setDim(int m, int n) {
        this.m = m;
        this.n = n;
        this.temp = new double[n];
        this.forwarddiff = new double[m];
        this.backwarddiff = new double[m];
    }
}

