/*
 * Decompiled with CFR 0.152.
 */
package uibk.mtk.draw2d.objects;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.image.BufferedImage;
import uibk.mtk.draw2d.base.Drawable2D;
import uibk.mtk.draw2d.objects.MathPoint2D;
import uibk.mtk.geom.geom2d.Punkt2D;

public class MathLine2D
extends Drawable2D {
    Stroke stroke;
    Punkt2D a = new Punkt2D();
    Punkt2D b = new Punkt2D();

    public void setPoints(MathPoint2D p1, MathPoint2D p2) {
        this.a.x = p1.x;
        this.a.y = p1.y;
        this.b.x = p2.x;
        this.b.y = p2.y;
    }

    public MathLine2D(double x1, double y1, double x2, double y2) {
        this.a.x = x1;
        this.a.y = y1;
        this.b.x = x2;
        this.b.y = y2;
    }

    public void setPoints(double x1, double y1, double x2, double y2) {
        this.a.x = x1;
        this.a.y = y1;
        this.b.x = x2;
        this.b.y = y2;
    }

    public Punkt2D getP1() {
        return new Punkt2D(this.a);
    }

    public Punkt2D getP2() {
        return new Punkt2D(this.b);
    }

    public MathLine2D() {
        this.stroke = new BasicStroke();
    }

    public void setStroke(Stroke stroke) {
        this.stroke = stroke;
    }

    public void setP1(Punkt2D p) {
        this.a.setLocation(p);
    }

    public void setP2(Punkt2D p) {
        this.b.setLocation(p);
    }

    public void draw(BufferedImage framebuffer, Graphics2D g2) {
        g2.setColor(this.color);
        Stroke old = g2.getStroke();
        g2.setStroke(this.stroke);
        Point p = this.scene2d.project(this.a);
        Point q = this.scene2d.project(this.b);
        g2.drawLine(p.x, p.y, q.x, q.y);
        g2.setStroke(old);
    }
}

