/*
 * Decompiled with CFR 0.152.
 */
package uibk.applets.biegelinie;

import Jama.Matrix;
import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.text.NumberFormat;
import java.util.LinkedList;
import java.util.Vector;
import uibk.applets.biegelinie.AppletBiegelinie;
import uibk.mtk.draw2d.base.Drawable2D;
import uibk.mtk.draw2d.base.MathPanel2D;
import uibk.mtk.draw2d.objects.DragablePoint2D;
import uibk.mtk.draw2d.objects.MathArrow2D;
import uibk.mtk.draw2d.objects.MathLine2D;
import uibk.mtk.geom.geom2d.CoordinateRect2D;
import uibk.mtk.geom.geom2d.Punkt2D;
import uibk.mtk.lang.Dragable;
import uibk.mtk.lang.Drawable;
import uibk.mtk.lang.PrepaintComputable;
import uibk.mtk.math.MathUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VarStreckenlast
extends Drawable2D
implements PrepaintComputable,
Dragable {
    private AppletBiegelinie biegelinie;
    private double rightF = 0.0;
    private double leftF = 0.0;
    private final int numpoints = 400;
    LinkedList<Move> points = new LinkedList<Move>(){

        @Override
        public boolean add(Move arg0) {
            if (arg0.getX() >= 0.0 && arg0.getX() <= ((VarStreckenlast)VarStreckenlast.this).biegelinie.length && arg0.getY() >= 0.0) {
                for (Move point : VarStreckenlast.this.points) {
                    if (VarStreckenlast.this.points.indexOf(point) != VarStreckenlast.this.points.size() - 1) {
                        if (!(point.getX() >= arg0.getX())) continue;
                        super.add(VarStreckenlast.this.points.indexOf(point), arg0);
                        return true;
                    }
                    super.add(VarStreckenlast.this.points.size() - 1, arg0);
                    return true;
                }
            }
            return false;
        }
    };
    NumberFormat nf = NumberFormat.getInstance();
    Dragable dragged = null;
    Vector<MathLine2D> lines = new Vector();
    Vector<MathArrow2D> arrows = new Vector();

    public VarStreckenlast(AppletBiegelinie biegelinie) {
        this.biegelinie = biegelinie;
        this.points.addFirst(new Move(0.0, 0.0));
        this.points.addLast(new Move(biegelinie.length, 0.0));
    }

    private boolean onlyLeftButton(MouseEvent ev) {
        return ev.getModifiers() == 16;
    }

    public void compute() {
        Vector<Punkt2D> pointsGraph = new Vector<Punkt2D>();
        Vector<Vector<Punkt2D>> pointsLines = new Vector<Vector<Punkt2D>>();
        for (Move punkt : this.points) {
            pointsGraph.add(new Punkt2D(punkt.getX() / 100.0, punkt.getY() / 100.0));
            punkt.enableToolTip(true);
        }
        this.biegelinie.graph[0].setPoints(pointsGraph);
        this.biegelinie.mathpanel[0].repaint();
        this.calculateLines(pointsGraph, pointsLines);
        int i = 1;
        while (i < 5) {
            this.setGraph(i, pointsLines.get(i - 1));
            ++i;
        }
        this.rightF = pointsLines.get((int)0).get((int)399).y;
        this.leftF = pointsLines.get((int)0).get((int)0).y;
        this.biegelinie.power.power[0].setHead(new Punkt2D(0.0, 0.0));
        this.biegelinie.power.power[0].setBase(new Punkt2D(0.0, -this.leftF));
        this.biegelinie.power.power[0].setVisible(true);
        this.biegelinie.power.power[2].setHead(new Punkt2D(1.0, 0.0));
        this.biegelinie.power.power[2].setBase(new Punkt2D(1.0, this.rightF));
        this.biegelinie.power.power[2].setVisible(true);
        if (Math.abs(this.rightF) < 0.002) {
            this.biegelinie.power.power[2].setVisible(false);
        }
        if (Math.abs(this.leftF) < 0.002) {
            this.biegelinie.power.power[0].setVisible(false);
        }
        this.biegelinie.mathpanel[0].getScene2d().setLimits(0.0, 1.0, -Math.max(this.leftF, this.rightF), 0.8);
    }

    private void calculateLines(Vector<Punkt2D> pointsGraph, Vector<Vector<Punkt2D>> pointsLines) {
        int[][] rand = new int[2][2];
        Matrix matrix = new Matrix(4, 4);
        pointsLines.add(this.calculateQ(pointsGraph));
        pointsLines.add(this.calculateM(pointsLines.get(0)));
        pointsLines.add(this.calculatePsi(pointsLines.get(1)));
        pointsLines.add(this.calculateW(pointsLines.get(2)));
        int i = 0;
        while (i < 2) {
            LagerRandbedingungen[] lagerRandbedingungenArray = LagerRandbedingungen.values();
            int n = lagerRandbedingungenArray.length;
            int n2 = 0;
            while (n2 < n) {
                LagerRandbedingungen randbed = lagerRandbedingungenArray[n2];
                if (this.biegelinie.lagerArt[i] == randbed.getValue()) {
                    rand[i] = randbed.getRandbedingung();
                }
                ++n2;
            }
            ++i;
        }
        i = 0;
        while (i < 2) {
            matrix.set(i, rand[0][i], 1.0);
            ++i;
        }
        i = 0;
        while (i < 2) {
            int j = 0;
            while (j < rand[1][i] + 1) {
                if (rand[1][i] == j) {
                    matrix.set(i + 2, j, 1.0);
                }
                if (rand[1][i] > 1 && j < 2) {
                    matrix.set(i + 2, j, -1.0 / MathUtil.gamma(rand[1][i] - j + 1));
                } else {
                    matrix.set(i + 2, j, 1.0 / MathUtil.gamma(rand[1][i] - j + 1));
                }
                ++j;
            }
            ++i;
        }
        double[][] A = new double[][]{{0.0}, {0.0}, {-pointsLines.get((int)rand[1][0]).get((int)400).y}, {-pointsLines.get((int)rand[1][1]).get((int)400).y}};
        matrix = matrix.solve(Matrix.constructWithCopy(A));
        for (Punkt2D punkt : pointsLines.get(0)) {
            punkt.y += matrix.get(0, 0);
        }
        pointsLines.set(1, this.calculateMRand(pointsLines.get(1), matrix));
        pointsLines.set(2, this.calculatePsiRand(pointsLines.get(2), matrix));
        pointsLines.set(3, this.calculateWRand(pointsLines.get(3), matrix));
    }

    private Vector<Punkt2D> calculateWRand(Vector<Punkt2D> name, Matrix matrix) {
        Vector<Punkt2D> points = new Vector<Punkt2D>();
        double x = 0.0;
        points.add(new Punkt2D(0.0, matrix.get(3, 0)));
        int i = 0;
        while (i < 400) {
            x = name.get((int)(i + 1)).x;
            points.add(new Punkt2D(x, name.get((int)(i + 1)).y + matrix.get(3, 0) - matrix.get(0, 0) / 6.0 * x * x * x - matrix.get(1, 0) / 2.0 * x * x + matrix.get(2, 0) * x));
            ++i;
        }
        return points;
    }

    private Vector<Punkt2D> calculatePsiRand(Vector<Punkt2D> name, Matrix matrix) {
        Vector<Punkt2D> points = new Vector<Punkt2D>();
        double x = 0.0;
        points.add(new Punkt2D(0.0, matrix.get(2, 0)));
        int i = 0;
        while (i < 400) {
            x = name.get((int)(i + 1)).x;
            points.add(new Punkt2D(x, name.get((int)(i + 1)).y + matrix.get(2, 0) - matrix.get(0, 0) / 2.0 * x * x - matrix.get(1, 0) * x));
            ++i;
        }
        return points;
    }

    private Vector<Punkt2D> calculateMRand(Vector<Punkt2D> name, Matrix matrix) {
        Vector<Punkt2D> points = new Vector<Punkt2D>();
        double x = 0.0;
        points.add(new Punkt2D(0.0, matrix.get(1, 0)));
        int i = 0;
        while (i < 400) {
            x = name.get((int)(i + 1)).x;
            points.add(new Punkt2D(x, name.get((int)(i + 1)).y + matrix.get(1, 0) + matrix.get(0, 0) * x));
            ++i;
        }
        return points;
    }

    private void setGraph(int i, Vector<Punkt2D> pointsGraph) {
        if (i > 1) {
            for (Punkt2D punkt2D : pointsGraph) {
                punkt2D.y = -punkt2D.y;
            }
        }
        this.biegelinie.graph[i].setPoints(pointsGraph);
        CoordinateRect2D rect = this.biegelinie.graph[i].getLimits();
        rect.roundCoords(0.1, 3);
        rect.ymin = Math.abs(rect.ymin) < 2.0E-4 ? 0.0 : rect.ymin;
        this.biegelinie.mathpanel[i].getScene2d().setLimits(rect);
        this.biegelinie.mathpanel[i].repaint();
    }

    private Vector<Punkt2D> calculateM(Vector<Punkt2D> pointsGraph) {
        Vector<Punkt2D> points = new Vector<Punkt2D>();
        points.add(new Punkt2D(0.0, 0.0));
        int i = 0;
        while (i < 400) {
            points.add(new Punkt2D(pointsGraph.get((int)(i + 1)).x, points.get((int)i).y + this.sum(pointsGraph.get(i), pointsGraph.get(i + 1))));
            ++i;
        }
        return points;
    }

    private Vector<Punkt2D> calculatePsi(Vector<Punkt2D> pointsGraph) {
        Vector<Punkt2D> points = new Vector<Punkt2D>();
        points.add(new Punkt2D(0.0, 0.0));
        int i = 0;
        while (i < 400) {
            points.add(new Punkt2D(pointsGraph.get((int)(i + 1)).x, points.get((int)i).y - this.sum(pointsGraph.get(i), pointsGraph.get(i + 1))));
            ++i;
        }
        return points;
    }

    private Vector<Punkt2D> calculateW(Vector<Punkt2D> pointsGraph) {
        Vector<Punkt2D> points = new Vector<Punkt2D>();
        points.add(new Punkt2D(0.0, 0.0));
        int i = 0;
        while (i < 400) {
            points.add(new Punkt2D(pointsGraph.get((int)(i + 1)).x, points.get((int)i).y + this.sum(pointsGraph.get(i), pointsGraph.get(i + 1))));
            ++i;
        }
        return points;
    }

    private Vector<Punkt2D> calculateQ(Vector<Punkt2D> pointsGraph) {
        Vector<Punkt2D> points = new Vector<Punkt2D>();
        int j = 0;
        boolean step = false;
        points.add(new Punkt2D(0.0, 0.0));
        double i = 0.0;
        while (i < 400.0) {
            double x1 = i / 400.0;
            double x2 = (i + 1.0) / 400.0;
            Punkt2D p1 = new Punkt2D(x1, 0.0);
            Punkt2D p2 = new Punkt2D(x2, 0.0);
            Punkt2D pStreck1 = pointsGraph.get(j);
            Punkt2D pStreck2 = pointsGraph.get(j + 1);
            if (step) {
                p1 = new Punkt2D(pStreck1);
                step = false;
            } else {
                p1.y = pStreck1.y + (p1.x - pStreck1.x) * (pStreck2.y - pStreck1.y) / (pStreck2.x - pStreck1.x);
            }
            if (x2 >= pStreck2.x) {
                p2 = new Punkt2D(pStreck2);
                x2 = p2.x;
                ++j;
                step = true;
            } else {
                p2.y = pStreck1.y + (p2.x - pStreck1.x) * (pStreck2.y - pStreck1.y) / (pStreck2.x - pStreck1.x);
            }
            points.add(new Punkt2D(x2, points.get((int)(points.size() - 1)).y - this.sum(p1, p2)));
            i += 1.0;
        }
        return points;
    }

    private double sum(Punkt2D p1, Punkt2D p2) {
        if (p2.x - p1.x == 0.0) {
            return 0.0;
        }
        return (p2.x - p1.x) * (p2.y + p1.y) / 2.0;
    }

    @Override
    public void setMathPanel2D(MathPanel2D panel) {
        super.setMathPanel2D(panel);
    }

    @Override
    public void draw(BufferedImage framebuffer, Graphics2D g2) {
    }

    void draw() {
        this.points.getLast().setCoordinates(this.biegelinie.length, 0.0);
        this.clearLineArrows();
        int i = 0;
        for (Move point : this.points) {
            if (i != this.points.size() - 1) {
                this.lines.add(new MathLine2D(point.getPunkt2D().x, point.getPunkt2D().y, this.points.get((int)(i + 1)).getPunkt2D().x, this.points.get((int)(i + 1)).getPunkt2D().y));
                this.lines.get(i).setVisible(true);
                this.lines.get(i).setStroke(new BasicStroke(1.0f));
                this.panel.add(this.lines.get(i));
                if (i != 0) {
                    this.panel.add(point);
                    point.setVisible(true);
                }
            }
            int j = 1;
            while (j < 11) {
                if (this.arrows.size() < j && (double)j * this.biegelinie.length / 11.0 <= point.getX()) {
                    double x = (double)j * this.biegelinie.length / 11.0;
                    double baseY = this.points.get((int)(i - 1)).getPunkt2D().y + (-this.points.get((int)(i - 1)).getPunkt2D().y + point.getPunkt2D().y) / (-this.points.get((int)(i - 1)).getPunkt2D().x + point.getPunkt2D().x) * (x - this.points.get((int)(i - 1)).getPunkt2D().x);
                    this.arrows.add(j - 1, new MathArrow2D(new Punkt2D(x, baseY), new Punkt2D(x, 0.0)));
                    this.panel.add(this.arrows.elementAt(j - 1));
                    this.arrows.elementAt(j - 1).setVisible(baseY > 5.0);
                }
                ++j;
            }
            ++i;
        }
        this.panel.repaint();
    }

    @Override
    public void prepaintcompute() throws Exception {
    }

    @Override
    public void drag(MouseEvent ev) {
        if (!this.onlyLeftButton(ev)) {
            return;
        }
        this.dragged.drag(ev);
        this.biegelinie.power.draw();
    }

    @Override
    public boolean dragcontains(int xm, int ym) {
        for (Move point : this.points) {
            if (!point.dragcontains(xm, ym)) continue;
            this.dragged = point;
            return true;
        }
        return false;
    }

    @Override
    public void enabledrag(boolean enable) {
    }

    @Override
    public boolean isDragEnabled() {
        return true;
    }

    public void addMove(double x, double y) {
        this.points.add(new Move(x, y));
    }

    private void clearLineArrows() {
        this.setVisible(false);
        this.lines.removeAllElements();
        this.arrows.removeAllElements();
    }

    public void clear() {
        this.clearLineArrows();
        int size = this.points.size();
        int i = 1;
        while (i < size - 1) {
            this.points.remove(1);
            ++i;
        }
    }

    @Override
    public void setVisible(boolean visible) {
        int size = this.points.size();
        int i = 1;
        while (i < size - 1) {
            this.points.get(i).setVisible(visible);
            ++i;
        }
        for (MathLine2D line : this.lines) {
            line.setVisible(false);
        }
        for (MathArrow2D arrow : this.arrows) {
            arrow.setVisible(false);
        }
    }

    public void removeMove(MouseEvent arg0) {
        int i = 0;
        Drawable remove = null;
        for (Move point : this.points) {
            if (i != 0 && this.points.size() - 1 != i && point.dragcontains(arg0.getX(), arg0.getY())) {
                remove = point;
            }
            ++i;
        }
        if (remove != null) {
            remove.setVisible(false);
            this.points.remove(remove);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum LagerRandbedingungen {
        frei(0),
        frei_drehbar_versch(1),
        frei_drehbar_fest(2),
        eingespannt(3);

        private int[] lager = new int[2];
        private int value;

        private LagerRandbedingungen(int rand) {
            this.value = rand + 1;
            switch (rand) {
                case 0: {
                    this.lager[0] = 0;
                    this.lager[1] = 1;
                    break;
                }
                case 1: {
                    this.lager[0] = 1;
                    this.lager[1] = 3;
                    break;
                }
                case 2: {
                    this.lager[0] = 1;
                    this.lager[1] = 3;
                    break;
                }
                case 3: {
                    this.lager[0] = 2;
                    this.lager[1] = 3;
                }
            }
        }

        private LagerRandbedingungen() {
            this.value = -1;
            this.lager[0] = -1;
            this.lager[1] = -1;
        }

        int getValue() {
            return this.value;
        }

        int[] getRandbedingung() {
            return this.lager;
        }
    }

    class Move
    extends DragablePoint2D {
        public Move(double x, double y) {
            super(x, y);
            this.setRadius(5);
        }

        public String getToolTipText(MouseEvent ev) {
            if (this.toolTip == null) {
                String str = "(" + VarStreckenlast.this.nf.format(this.x / 100.0) + ";" + VarStreckenlast.this.nf.format(this.y / 100.0) + ")";
                return str;
            }
            return this.toolTip;
        }

        public void moveTo(double x) {
            int signature = (int)Math.signum(this.x - x);
            int index = VarStreckenlast.this.points.indexOf(this);
            this.x = x;
            if (signature != 0 && index - signature > 0 && index - signature < VarStreckenlast.this.points.size() - 1 && (double)signature * VarStreckenlast.this.points.get((int)(index - signature)).x >= (double)signature * x) {
                VarStreckenlast.this.points.get(index - signature).moveTo(x);
            }
        }

        public void drag(MouseEvent ev) {
            double t = this.scene2d.pixelToY(ev.getY());
            double u = this.scene2d.pixelToX(ev.getX());
            this.y = t < 0.0 ? 0.0 : (t > 100.0 ? 100.0 : t);
            if (u < 0.0) {
                u = 0.0;
            } else if (u > 100.0) {
                u = 100.0;
            }
            this.moveTo(u);
            this.getToolTipText(ev);
            ((VarStreckenlast)VarStreckenlast.this).biegelinie.power.draw();
        }
    }
}

