/*
 * Decompiled with CFR 0.152.
 */
package uibk.swing;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.Arc2D;
import javax.swing.JComponent;
import uibk.text.Formatter;

public class PieChart
extends JComponent {
    Formatter format = new Formatter();
    int width;
    int height;
    String[] labels;
    double factorpie = 0.5;
    int edge = 20;
    private final int numberofdigits = 2;
    int radius;
    double[] fractions;
    Color edgecolor = Color.black;
    Color[] usercolors;
    Color[] colors;
    int poslegendx;

    public PieChart(double[] fractions, String[] labels, String colors) {
        this.fractions = fractions;
        this.labels = labels;
        if (colors == null) {
            this.randomcolors();
        }
    }

    public PieChart() {
        this(null, null, null);
    }

    public void setFractions(double[] fractions, String[] labels, Color[] colors) {
        if (fractions.length != labels.length) {
            throw new IllegalArgumentException("Es m\u00fcssen gleich viele Labels wie Teile vorhanden sein");
        }
        this.fractions = fractions;
        this.labels = labels;
        if (colors == null) {
            this.randomcolors();
        } else {
            this.setColors(colors);
        }
    }

    public void setColors(Color[] colors) {
        if (colors == null || colors.length != this.fractions.length) {
            throw new IllegalArgumentException("Zu wenige Farben");
        }
        this.colors = colors;
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        if (this.fractions != null) {
            this.drawpie(g2);
            this.drawlegend(g2);
        }
    }

    public void computepos() {
        int piewidth = (this.getWidth() - 3 * this.edge) / 2;
        int height = this.getHeight() - 2 * this.edge;
        this.radius = Math.min(piewidth, height) / 2;
        this.poslegendx = 2 * this.edge + this.radius * 2;
    }

    public void drawpie(Graphics2D g2) {
        int n = this.fractions.length;
        int nc = this.colors.length;
        double phistart = 0.0;
        this.computepos();
        int i = 0;
        while (i < n) {
            double phi = this.fractions[i] * 360.0;
            Color color = this.colors[i % nc];
            this.fillArc(g2, this.edge, this.edge, this.radius * 2, this.radius * 2, phistart, phi, color);
            this.drawEdgeArc(g2, this.edge, this.edge, this.radius * 2, this.radius * 2, phistart, phi, this.edgecolor);
            phistart += phi;
            ++i;
        }
    }

    void randomcolors() {
        if (this.fractions == null) {
            return;
        }
        int n = this.fractions.length;
        this.colors = new Color[n + 1];
        this.colors[n] = Color.red;
        int i = 0;
        while (i < n) {
            int r = (int)(Math.random() * 255.0);
            int g = (int)(Math.random() * 255.0);
            int b = (int)(Math.random() * 255.0);
            this.colors[i] = new Color(r, g, b);
            ++i;
        }
    }

    public void fillArc(Graphics2D g2, double x, double y, double w, double h, double start, double end, Color color) {
        g2.setColor(color);
        g2.fill(new Arc2D.Double(x, y, w, h, start, end, 2));
    }

    public void drawEdgeArc(Graphics2D g2, double x, double y, double w, double h, double start, double end, Color color) {
        g2.setColor(color);
        g2.draw(new Arc2D.Double(x, y, w, h, start, end, 2));
    }

    private void drawlegend(Graphics2D g2) {
        if (this.labels == null) {
            return;
        }
        int posx = this.poslegendx;
        int posy = this.edge;
        FontMetrics metrics = g2.getFontMetrics();
        int fontheight = metrics.getHeight();
        int space = 5;
        int i = 0;
        while (i < this.fractions.length) {
            this.drawQuad(g2, this.getColor(i), new Point(posx, posy), fontheight);
            String percent = String.valueOf(this.format.formatplaces(this.fractions[i] * 100.0, 2)) + "%";
            g2.drawString(String.valueOf(this.labels[i]) + ": " + percent, posx + 30, posy + fontheight - 3);
            posy += fontheight;
            posy += space;
            ++i;
        }
    }

    private Color getColor(int i) {
        return this.colors[i];
    }

    void drawQuad(Graphics2D g2, Color color, Point pos, int w) {
        g2.setColor(color);
        g2.fillRect(pos.x, pos.y, w, w);
        g2.setColor(Color.black);
        g2.drawRect(pos.x, pos.y, w, w);
    }
}

