/*
 * Decompiled with CFR 0.152.
 */
package uibk.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.border.TitledBorder;
import uibk.draw2d.base.MathPanel2D;
import uibk.draw2d.base.Scene2D;
import uibk.geom.CoordinateRect2D;
import uibk.swing.ButtonNoFocus;
import uibk.swing.Panel;
import uibk.swing.RadioButton;

public class PanelScale2D
extends Panel
implements ActionListener {
    ButtonGroup groupAxesOpt = new ButtonGroup();
    RadioButton jRadioAxesEqual;
    RadioButton jRadioAxesIndependent;
    ButtonNoFocus jButtonBothZoomIn;
    ButtonNoFocus jButtonBothZoomOut;
    ButtonNoFocus jButtonXZoomIn;
    ButtonNoFocus jButtonXZoomOut;
    ButtonNoFocus jButtonYZoomIn;
    ButtonNoFocus jButtonYZoomOut;
    MathPanel2D mathpanel2d;
    private String strtitle = "Skalierung";
    private String strindependently = "unabh\u00e4ngig skalieren";
    private String strequal = "gleich skalieren";
    double originalxmin;
    double originalxmax;
    double originalymin;
    double originalymax;
    public static final int SCALE_TOGETHER = 0;
    public static final int SCALE_INDEPENDENT = 1;
    int mode = 0;
    private double scalefactor = 1.2;

    public int getMode() {
        return this.mode;
    }

    public void setMode(int mode) {
        if (mode == 0) {
            this.jButtonXZoomIn.setEnabled(false);
            this.jButtonXZoomOut.setEnabled(false);
            this.jButtonYZoomIn.setEnabled(false);
            this.jButtonYZoomOut.setEnabled(false);
            this.jButtonBothZoomIn.setEnabled(true);
            this.jButtonBothZoomOut.setEnabled(true);
            this.jRadioAxesEqual.setSelected(true);
            this.mode = mode;
        }
        if (mode == 1) {
            this.jButtonXZoomIn.setEnabled(true);
            this.jButtonXZoomOut.setEnabled(true);
            this.jButtonYZoomIn.setEnabled(true);
            this.jButtonYZoomOut.setEnabled(true);
            this.jButtonBothZoomIn.setEnabled(false);
            this.jButtonBothZoomOut.setEnabled(false);
            this.jRadioAxesIndependent.setSelected(true);
            this.mode = mode;
        }
    }

    public void setScaleFactor(double factor) {
        this.scalefactor = factor;
    }

    protected CoordinateRect2D calcRescaledLimits(double factor) {
        CoordinateRect2D coordsX = this.calcRescaledLimitsX(factor);
        CoordinateRect2D coordsY = this.calcRescaledLimitsY(factor);
        return new CoordinateRect2D(coordsX.xmin, coordsX.xmax, coordsY.ymin, coordsY.ymax);
    }

    protected CoordinateRect2D calcRescaledLimitsX(double factor) {
        Scene2D coords2d = this.mathpanel2d.getScene2d();
        double xmin = coords2d.getXmin();
        double xmax = coords2d.getXmax();
        double ymin = coords2d.getYmin();
        double ymax = coords2d.getYmax();
        double newxmin = xmin;
        double newxmax = xmax;
        double newymin = ymin;
        double newymax = ymax;
        int area = coords2d.getArea();
        if (area == 1 || area == 6 || area == 4) {
            newxmax = xmin + coords2d.getXRange() * factor;
        }
        if (area == 2 || area == 8 || area == 5) {
            newxmax = coords2d.getXmax() * factor;
            newxmin = coords2d.getXmin() * factor;
        }
        if (area == 0 || area == 7 || area == 3) {
            newxmin = xmax - coords2d.getXRange() * factor;
        }
        return new CoordinateRect2D(newxmin, newxmax, newymin, newymax);
    }

    protected CoordinateRect2D calcRescaledLimitsY(double factor) {
        Scene2D coords2d = this.mathpanel2d.getScene2d();
        double xmin = coords2d.getXmin();
        double xmax = coords2d.getXmax();
        double ymin = coords2d.getYmin();
        double ymax = coords2d.getYmax();
        double newxmin = xmin;
        double newxmax = xmax;
        double newymin = ymin;
        double newymax = ymax;
        int area = coords2d.getArea();
        if (area == 1 || area == 2 || area == 0) {
            newymax = ymin + coords2d.getYRange() * factor;
        }
        if (area == 7 || area == 8 || area == 6) {
            newymax = coords2d.getYmax() * factor;
            newymin = coords2d.getYmin() * factor;
        }
        if (area == 4 || area == 5 || area == 3) {
            newymin = ymax - coords2d.getYRange() * factor;
        }
        return new CoordinateRect2D(newxmin, newxmax, newymin, newymax);
    }

    void checkUpperLimitsAndSet(CoordinateRect2D coords) {
        if (coords.xmax < this.originalxmax || coords.xmin > this.originalxmin || coords.ymax < this.originalymax || coords.ymin > this.originalymin) {
            this.mathpanel2d.getScene2d().setLimits(this.originalxmin, this.originalxmax, this.originalymin, this.originalymax);
        } else {
            this.mathpanel2d.getScene2d().setLimits(coords);
        }
    }

    void rescale(double factor) {
        CoordinateRect2D coords = this.calcRescaledLimits(factor);
        if (coords.xmax < this.originalxmax || coords.xmin > this.originalxmin || coords.ymax < this.originalymax || coords.ymin > this.originalymin) {
            this.mathpanel2d.getScene2d().setLimits(this.originalxmin, this.originalxmax, this.originalymin, this.originalymax);
            this.mathpanel2d.getScene2d().equalizeCoords();
        } else {
            this.mathpanel2d.getScene2d().setLimits(coords);
        }
    }

    void rescaleX(double factor) {
        CoordinateRect2D coords = this.calcRescaledLimitsX(factor);
        if (coords.xmax < this.originalxmax || coords.xmin > this.originalxmin) {
            coords.xmin = this.originalxmin;
            coords.xmax = this.originalxmax;
            this.mathpanel2d.getScene2d().setLimits(coords);
        } else {
            this.mathpanel2d.getScene2d().setLimits(coords);
        }
    }

    void rescaleY(double factor) {
        CoordinateRect2D coords = this.calcRescaledLimitsY(factor);
        if (coords.ymax < this.originalymax || coords.ymin > this.originalymin) {
            coords.ymin = this.originalymin;
            coords.ymax = this.originalymax;
            this.mathpanel2d.getScene2d().setLimits(coords);
        } else {
            this.mathpanel2d.getScene2d().setLimits(coords);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (!enabled) {
            this.jButtonXZoomIn.setEnabled(false);
            this.jButtonXZoomOut.setEnabled(false);
            this.jButtonYZoomIn.setEnabled(false);
            this.jButtonYZoomOut.setEnabled(false);
            this.jButtonBothZoomIn.setEnabled(false);
            this.jButtonBothZoomOut.setEnabled(false);
            this.jRadioAxesIndependent.setEnabled(false);
            this.jRadioAxesEqual.setEnabled(false);
        } else {
            this.jRadioAxesIndependent.setEnabled(true);
            this.jRadioAxesEqual.setEnabled(true);
            this.setMode(this.mode);
        }
    }

    public void updateCoords() {
        CoordinateRect2D rect = this.mathpanel2d.getScene2d().getCoordinates();
        this.originalxmin = rect.xmin;
        this.originalxmax = rect.xmax;
        this.originalymin = rect.ymin;
        this.originalymax = rect.ymax;
        this.jRadioAxesEqual.setSelected(true);
        this.jRadioAxesIndependent.setSelected(false);
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.jRadioAxesEqual != null) {
            this.jRadioAxesEqual.setBackground(color);
        }
        if (this.jRadioAxesIndependent != null) {
            this.jRadioAxesIndependent.setBackground(color);
        }
        if (this.jButtonBothZoomIn != null) {
            this.jButtonBothZoomIn.setBackground(color);
        }
        if (this.jButtonBothZoomOut != null) {
            this.jButtonBothZoomOut.setBackground(color);
        }
        if (this.jButtonXZoomIn != null) {
            this.jButtonXZoomIn.setBackground(color);
        }
        if (this.jButtonXZoomOut != null) {
            this.jButtonXZoomOut.setBackground(color);
        }
        if (this.jButtonYZoomIn != null) {
            this.jButtonYZoomIn.setBackground(color);
        }
        if (this.jButtonYZoomOut != null) {
            this.jButtonYZoomOut.setBackground(color);
        }
    }

    public PanelScale2D(MathPanel2D mathpanel2d) {
        this.mathpanel2d = mathpanel2d;
        this.initComponents();
    }

    void initComponents() {
        this.originalxmin = this.mathpanel2d.getScene2d().getXmin();
        this.originalymin = this.mathpanel2d.getScene2d().getYmin();
        this.originalxmax = this.mathpanel2d.getScene2d().getXmax();
        this.originalxmax = this.mathpanel2d.getScene2d().getXmax();
        TitledBorder border = BorderFactory.createTitledBorder(this.strtitle);
        border.setTitleFont(border.getTitleFont().deriveFont(1));
        this.setBorder(border);
        this.setLayout(new GridBagLayout());
        this.jRadioAxesIndependent = new RadioButton(this.strindependently, false);
        this.jRadioAxesEqual = new RadioButton(this.strequal, true);
        this.jRadioAxesEqual.setActionCommand("axes_equal");
        this.jRadioAxesIndependent.setActionCommand("axes_independent");
        this.jRadioAxesEqual.addActionListener(this);
        this.jRadioAxesIndependent.addActionListener(this);
        this.groupAxesOpt.add(this.jRadioAxesEqual);
        this.groupAxesOpt.add(this.jRadioAxesIndependent);
        this.jRadioAxesEqual.setSelected(true);
        URL urlIconPlus = this.getClass().getResource("res/plus.gif");
        URL urlIconMinus = this.getClass().getResource("res/minus.gif");
        this.jButtonBothZoomIn = new ButtonNoFocus(new ImageIcon(urlIconPlus));
        this.jButtonBothZoomOut = new ButtonNoFocus(new ImageIcon(urlIconMinus));
        this.jButtonBothZoomIn.setActionCommand("bothzoomin");
        this.jButtonBothZoomOut.setActionCommand("bothzoomout");
        this.jButtonXZoomIn = new ButtonNoFocus(new ImageIcon(urlIconPlus));
        this.jButtonXZoomOut = new ButtonNoFocus(new ImageIcon(urlIconMinus));
        this.jButtonXZoomIn.setActionCommand("xzoomin");
        this.jButtonXZoomOut.setActionCommand("xzoomout");
        this.jButtonYZoomIn = new ButtonNoFocus(new ImageIcon(urlIconPlus));
        this.jButtonYZoomOut = new ButtonNoFocus(new ImageIcon(urlIconMinus));
        this.jButtonYZoomIn.setActionCommand("yzoomin");
        this.jButtonYZoomOut.setActionCommand("yzoomout");
        this.jButtonBothZoomIn.setBorder(null);
        this.jButtonBothZoomOut.setBorder(null);
        this.jButtonXZoomIn.setBorder(null);
        this.jButtonXZoomOut.setBorder(null);
        this.jButtonYZoomIn.setBorder(null);
        this.jButtonYZoomOut.setBorder(null);
        this.jButtonBothZoomIn.addActionListener(this);
        this.jButtonBothZoomOut.addActionListener(this);
        this.jButtonXZoomIn.addActionListener(this);
        this.jButtonXZoomOut.addActionListener(this);
        this.jButtonYZoomIn.addActionListener(this);
        this.jButtonYZoomOut.addActionListener(this);
        this.setMode(0);
        this.add((Component)this.jRadioAxesEqual, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.jButtonBothZoomOut, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.jButtonBothZoomIn, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
        this.add((Component)this.jButtonYZoomIn, new GridBagConstraints(1, 1, 2, 1, 0.0, 0.0, 17, 0, new Insets(10, 15, 0, 0), 0, 0));
        this.add((Component)this.jRadioAxesIndependent, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.jButtonXZoomOut, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.jButtonXZoomIn, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
        this.add((Component)this.jButtonYZoomOut, new GridBagConstraints(1, 3, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 15, 0, 0), 0, 0));
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        if (ev.getActionCommand().equals("bothzoomout")) {
            this.rescale(this.scalefactor);
            this.mathpanel2d.repaint();
        }
        if (ev.getActionCommand().equals("xzoomout")) {
            this.rescaleX(this.scalefactor);
            this.mathpanel2d.repaint();
        }
        if (ev.getActionCommand().equals("yzoomout")) {
            this.rescaleY(this.scalefactor);
            this.mathpanel2d.repaint();
        }
        if (ev.getActionCommand().equals("bothzoomin")) {
            this.rescale(1.0 / this.scalefactor);
            this.mathpanel2d.repaint();
        }
        if (ev.getActionCommand().equals("xzoomin")) {
            this.rescaleX(1.0 / this.scalefactor);
            this.mathpanel2d.repaint();
        }
        if (ev.getActionCommand().equals("yzoomin")) {
            this.rescaleY(1.0 / this.scalefactor);
            this.mathpanel2d.repaint();
        }
        if (ev.getActionCommand().equals("axes_equal")) {
            this.mathpanel2d.getScene2d().setLimits(this.originalxmin, this.originalxmax, this.originalymin, this.originalymax);
            this.mathpanel2d.getScene2d().equalizeCoords();
            this.setMode(0);
            this.mathpanel2d.repaint();
        }
        if (ev.getActionCommand().equals("axes_independent")) {
            this.setMode(1);
            this.mathpanel2d.getScene2d().setLimits(this.originalxmin, this.originalxmax, this.originalymin, this.originalymax);
            this.mathpanel2d.repaint();
        }
    }
}

