/*
 * Decompiled with CFR 0.152.
 */
package uibk.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.border.TitledBorder;
import uibk.draw3d.base.MathPanel3D;
import uibk.swing.ButtonNoFocus;
import uibk.swing.Label;
import uibk.swing.Panel;

public class PanelRotate3D
extends Panel
implements ActionListener {
    ButtonNoFocus jButtonRotXPlus;
    ButtonNoFocus jButtonRotXMinus;
    ButtonNoFocus jButtonRotYPlus;
    ButtonNoFocus jButtonRotYMinus;
    ButtonNoFocus jButtonRotZPlus;
    ButtonNoFocus jButtonRotZMinus;
    private static final double ROT = 0.05;
    private double rotchange = 0.05;
    MathPanel3D mathpanel3d;

    public void setRotationChange(double rot) {
        this.rotchange = rot;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.jButtonRotXPlus.setEnabled(enabled);
        this.jButtonRotXMinus.setEnabled(enabled);
        this.jButtonRotYPlus.setEnabled(enabled);
        this.jButtonRotYMinus.setEnabled(enabled);
        this.jButtonRotZPlus.setEnabled(enabled);
        this.jButtonRotZMinus.setEnabled(enabled);
    }

    public PanelRotate3D(MathPanel3D mathpanel3d) {
        this.mathpanel3d = mathpanel3d;
        TitledBorder border = BorderFactory.createTitledBorder("Rotation");
        border.setTitleFont(border.getTitleFont().deriveFont(1));
        this.setBorder(border);
        this.setLayout(new GridBagLayout());
        this.setMaximumSize(new Dimension(300, 120));
        this.setPreferredSize(new Dimension(300, 120));
        URL urlIconPlus = this.getClass().getResource("res/plus.gif");
        URL urlIconMinus = this.getClass().getResource("res/minus.gif");
        this.jButtonRotXPlus = new ButtonNoFocus(new ImageIcon(urlIconPlus));
        this.jButtonRotXMinus = new ButtonNoFocus(new ImageIcon(urlIconMinus));
        this.jButtonRotXPlus.setActionCommand("rotxplus");
        this.jButtonRotXMinus.setActionCommand("rotxminus");
        this.jButtonRotYPlus = new ButtonNoFocus(new ImageIcon(urlIconPlus));
        this.jButtonRotYMinus = new ButtonNoFocus(new ImageIcon(urlIconMinus));
        this.jButtonRotYPlus.setActionCommand("rotyplus");
        this.jButtonRotYMinus.setActionCommand("rotyminus");
        this.jButtonRotZPlus = new ButtonNoFocus(new ImageIcon(urlIconPlus));
        this.jButtonRotZMinus = new ButtonNoFocus(new ImageIcon(urlIconMinus));
        this.jButtonRotZPlus.setActionCommand("rotzplus");
        this.jButtonRotZMinus.setActionCommand("rotzminus");
        this.jButtonRotXPlus.setBorder(null);
        this.jButtonRotXMinus.setBorder(null);
        this.jButtonRotYPlus.setBorder(null);
        this.jButtonRotYMinus.setBorder(null);
        this.jButtonRotZPlus.setBorder(null);
        this.jButtonRotZMinus.setBorder(null);
        this.jButtonRotXPlus.addActionListener(this);
        this.jButtonRotXMinus.addActionListener(this);
        this.jButtonRotYPlus.addActionListener(this);
        this.jButtonRotYMinus.addActionListener(this);
        this.jButtonRotZPlus.addActionListener(this);
        this.jButtonRotZMinus.addActionListener(this);
        this.add((Component)new Label("x-Achse"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
        this.add((Component)this.jButtonRotXMinus, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 5, 0), 0, 0));
        this.add((Component)this.jButtonRotXPlus, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 5, 0), 0, 0));
        this.add((Component)new Label("y-Achse"), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
        this.add((Component)this.jButtonRotYMinus, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 5, 0), 0, 0));
        this.add((Component)this.jButtonRotYPlus, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 5, 0), 0, 0));
        this.add((Component)new Label("z-Achse"), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
        this.add((Component)this.jButtonRotZMinus, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 5, 0), 0, 0));
        this.add((Component)this.jButtonRotZPlus, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 5, 0), 0, 0));
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        double rot;
        if (ev.getActionCommand().equals("rotxplus")) {
            rot = this.mathpanel3d.getScene3D().getRotationX();
            this.mathpanel3d.getScene3D().setRotationX(rot + this.rotchange);
            this.mathpanel3d.repaint();
        }
        if (ev.getActionCommand().equals("rotxminus")) {
            rot = this.mathpanel3d.getScene3D().getRotationX();
            this.mathpanel3d.getScene3D().setRotationX(rot - this.rotchange);
            this.mathpanel3d.repaint();
        }
        if (ev.getActionCommand().equals("rotyplus")) {
            rot = this.mathpanel3d.getScene3D().getRotationY();
            this.mathpanel3d.getScene3D().setRotationY(rot + this.rotchange);
            this.mathpanel3d.repaint();
        }
        if (ev.getActionCommand().equals("rotyminus")) {
            rot = this.mathpanel3d.getScene3D().getRotationY();
            this.mathpanel3d.getScene3D().setRotationY(rot - this.rotchange);
            this.mathpanel3d.repaint();
        }
        if (ev.getActionCommand().equals("rotzplus")) {
            rot = this.mathpanel3d.getScene3D().getRotationZ();
            this.mathpanel3d.getScene3D().setRotationZ(rot + this.rotchange);
            this.mathpanel3d.repaint();
        }
        if (ev.getActionCommand().equals("rotzminus")) {
            rot = this.mathpanel3d.getScene3D().getRotationZ();
            this.mathpanel3d.getScene3D().setRotationZ(rot - this.rotchange);
            this.mathpanel3d.repaint();
        }
    }
}

