/*
 * Decompiled with CFR 0.152.
 */
package uibk.geom;

import java.awt.Point;
import uibk.geom.Vector2D;

public class Punkt2D {
    public double x;
    public double y;

    public Punkt2D(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public Punkt2D() {
    }

    public Punkt2D(Point p) {
        this.x = p.x;
        this.y = p.y;
    }

    public Punkt2D(Punkt2D p) {
        this.x = p.x;
        this.y = p.y;
    }

    public Punkt2D add(Punkt2D b) {
        return new Punkt2D(this.x + b.x, this.y + b.y);
    }

    public Punkt2D sub(Punkt2D b) {
        return new Punkt2D(this.x - b.x, this.y - b.y);
    }

    public static Punkt2D inverse(Punkt2D a) {
        return new Punkt2D(-a.x, -a.y);
    }

    public void setLocation(Punkt2D p) {
        this.x = p.x;
        this.y = p.y;
    }

    public void setLocation(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public Punkt2D scale(double s) {
        Punkt2D b = new Punkt2D();
        b.x = this.x * s;
        b.y = this.y * s;
        return b;
    }

    public void scaleself(double s) {
        this.x *= s;
        this.y *= s;
    }

    public double dotProd(Punkt2D b) {
        return this.x * b.x + this.y * b.y;
    }

    public double norm() {
        return Math.sqrt(this.x * this.x + this.y * this.y);
    }

    public double quadnorm() {
        return this.x * this.x + this.y * this.y;
    }

    public String toString() {
        return "(" + this.x + "," + this.y + ")";
    }

    public void normalize() {
        double n = this.norm();
        this.x /= n;
        this.y /= n;
    }

    public boolean isReal() {
        return !Double.isInfinite(this.x) && !Double.isInfinite(this.y) && !Double.isNaN(this.x) && !Double.isNaN(this.y);
    }

    public Vector2D toVector() {
        return new Vector2D(this.x, this.y);
    }
}

