/*
 * Decompiled with CFR 0.152.
 */
package uibk.geom;

import uibk.geom.Point3D;
import uibk.math.Interval;

public class CoordinateCube3D {
    public double xmin;
    public double xmax;
    public double ymin;
    public double ymax;
    public double zmin;
    public double zmax;

    public CoordinateCube3D(double xmin, double xmax, double ymin, double ymax, double zmin, double zmax) {
        this.xmin = xmin;
        this.xmax = xmax;
        this.ymin = ymin;
        this.ymax = ymax;
        this.zmin = zmin;
        this.zmax = zmax;
    }

    public CoordinateCube3D(Interval xrange, Interval yrange, Interval zrange) {
        this.xmin = xrange.a;
        this.xmax = xrange.b;
        this.ymin = yrange.a;
        this.ymax = yrange.b;
        this.zmin = zrange.a;
        this.zmax = zrange.b;
    }

    public CoordinateCube3D(CoordinateCube3D limits) {
        this.xmin = limits.xmin;
        this.xmax = limits.xmax;
        this.ymin = limits.ymin;
        this.ymax = limits.ymax;
        this.zmin = limits.zmin;
        this.zmax = limits.zmax;
    }

    public CoordinateCube3D() {
        this(-1.0, 1.0, -1.0, 1.0, -1.0, 1.0);
    }

    public double getXRange() {
        return Math.abs(this.xmax - this.xmin);
    }

    public double getYRange() {
        return Math.abs(this.ymax - this.ymin);
    }

    public double getZRange() {
        return Math.abs(this.zmax - this.zmin);
    }

    public Object clone() {
        return new CoordinateCube3D(this.xmin, this.xmax, this.ymin, this.ymax, this.zmin, this.zmax);
    }

    public Point3D getCenter() {
        return new Point3D((this.xmin + this.xmax) / 2.0, (this.ymin + this.ymax) / 2.0, (this.zmin + this.zmax) / 2.0);
    }

    public String toString() {
        return "[xmin=" + this.xmin + ",xmax=" + this.xmax + " ymin=" + this.ymin + ",ymax=" + this.ymax + ",zmin=" + this.zmin + ",zmax=" + this.zmax + "]";
    }

    public boolean isEmpty() {
        if (this.xmin == this.xmax) {
            return true;
        }
        if (this.ymin == this.ymax) {
            return true;
        }
        return this.zmin == this.zmax;
    }

    public double maxBoundingBox() {
        double x = Math.abs(this.xmax - this.xmin);
        double y = Math.abs(this.ymax - this.ymin);
        double z = Math.abs(this.zmax - this.zmin);
        return Math.max(x, Math.max(y, z));
    }

    public double minBoundingBox() {
        double x = Math.abs(this.xmax - this.xmin);
        double y = Math.abs(this.ymax - this.ymin);
        double z = Math.abs(this.zmax - this.zmin);
        return Math.min(x, Math.min(y, z));
    }

    public boolean contains(Point3D p) {
        if (p.x1 > this.xmax) {
            return false;
        }
        if (p.x1 < this.xmin) {
            return false;
        }
        if (p.x2 > this.ymax) {
            return false;
        }
        if (p.x2 < this.ymin) {
            return false;
        }
        if (p.x3 > this.zmax) {
            return false;
        }
        return !(p.x3 < this.zmin);
    }
}

