/*
 * Decompiled with CFR 0.152.
 */
package uibk.draw3d.surface3d;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import uibk.draw3d.base.Drawable3D;
import uibk.draw3d.base.MathPanel3D;
import uibk.draw3d.base.Rasterable3D;
import uibk.draw3d.rasterizer.Rasterizer;
import uibk.draw3d.surface3d.ArrowZ3D;
import uibk.draw3d.surface3d.Triangle;
import uibk.draw3d.surface3d.Vertex3D;
import uibk.geom.Point3D;
import uibk.geom.Punkt2D;
import uibk.geom.Vector2D;
import uibk.geom.Vector3D;
import uibk.lang.PrepaintComputable;
import uibk.math.functions.ParsedFunction2D;
import uibk.util.Grid2D;

public class PartialDerivates3D
extends Drawable3D
implements PrepaintComputable,
Rasterable3D {
    public static final int DIRECTIONALDERIVATE = 0;
    public static final int PARTIALALDERIVATES = 1;
    public static final int TANGENTPLANE = 2;
    int mode = 1;
    final int nx = 8;
    final int ny = 8;
    Triangle[] triangles = new Triangle[98];
    Vertex3D[] vertices;
    ArrowZ3D arrowx = new ArrowZ3D();
    ArrowZ3D arrowy = new ArrowZ3D();
    ArrowZ3D arrowdir = new ArrowZ3D();
    ParsedFunction2D f;
    Rasterizer rasterizer;
    Punkt2D base;
    Vector2D dir;
    private final Vector2D dirx = new Vector2D(1.0, 0.0);
    private final Vector2D diry = new Vector2D(0.0, 1.0);
    static final Color COLORPLANE = new Color(200, 200, 200);

    @Override
    public void setRasterizer(Rasterizer rasterizer) {
        this.rasterizer = rasterizer;
        this.arrowx.setRasterizer(rasterizer);
        this.arrowy.setRasterizer(rasterizer);
        this.arrowdir.setRasterizer(rasterizer);
    }

    public PartialDerivates3D(ParsedFunction2D f) {
        this.draw = false;
        this.f = f;
    }

    @Override
    public void setMathPanel3d(MathPanel3D panel3d) {
        super.setMathPanel3d(panel3d);
        this.arrowx.setMathPanel3d(panel3d);
        this.arrowy.setMathPanel3d(panel3d);
        this.arrowdir.setMathPanel3d(panel3d);
    }

    @Override
    public void draw(BufferedImage framebuffer, Graphics2D g2) {
        if (!this.draw) {
            return;
        }
        if (this.mode == 0) {
            this.arrowdir.draw(framebuffer, g2);
        }
        if (this.mode == 1) {
            this.arrowx.draw(framebuffer, g2);
            this.arrowy.draw(framebuffer, g2);
        }
        if (this.mode == 2) {
            this.drawTangentPlane();
        }
    }

    public void compute(Punkt2D p, Vector2D dir) throws Exception {
        this.base = p;
        this.dir = dir;
        if (this.mode == 0) {
            this.setupArrow(this.arrowdir, p, dir);
        }
        if (this.mode == 1) {
            this.setupArrow(this.arrowx, p, this.dirx);
            this.setupArrow(this.arrowy, p, this.diry);
        }
        if (this.mode == 2) {
            this.computeTangentPlane();
        }
        this.draw = true;
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public int getMode() {
        return this.mode;
    }

    void setupArrow(ArrowZ3D arrow, Punkt2D p, Vector2D direction) throws Exception {
        Point3D a = null;
        Vector3D vx = null;
        try {
            a = new Point3D(p.x, p.y, this.f.getValue(p.x, p.y));
            vx = this.f.getDerivationVector(p, direction);
        }
        catch (Exception e1) {
            this.draw = false;
            throw new Exception("Ableitung kann nicht gezeichnet werden (die Ableitung existert nicht)");
        }
        double length = this.panel.getScene3D().getBoundingBox().getXRange() / 2.0;
        vx.normalize();
        vx.scale(length);
        arrow.setBase(a);
        arrow.setHead(a.add(vx));
    }

    void computeTangentPlane() throws Exception {
        Punkt2D[][] gridpoints;
        double temp;
        Point3D a = new Point3D(this.base.x, this.base.y, this.f.getValue(this.base.x, this.base.y));
        Vector3D vx = null;
        Vector3D vy = null;
        try {
            vx = this.f.getDerivationVector(new Punkt2D(this.base.x, this.base.y), new Vector2D(1.0, 0.0));
            vy = this.f.getDerivationVector(new Punkt2D(this.base.x, this.base.y), new Vector2D(0.0, 1.0));
        }
        catch (Exception e1) {
            this.draw = false;
            throw new Exception("Tangentialeben kann nicht gezeichnet werden (die Ableitung existert nicht)");
        }
        Vector3D n = Vector3D.crossProd(vx, vy);
        double lengthx = this.panel.getScene3D().getBoundingBox().getXRange() / 4.0;
        vx.normalize();
        vx.scale(lengthx);
        vy.normalize();
        vy.scale(lengthx);
        double xmin = a.add((Point3D)vx).x1;
        double xmax = a.sub((Point3D)vx).x1;
        double ymin = a.add((Point3D)vy).x2;
        double ymax = a.sub((Point3D)vy).x2;
        if (xmin > xmax) {
            temp = xmax;
            xmax = xmin;
            xmin = temp;
        }
        if (ymin > ymax) {
            temp = ymax;
            ymax = ymin;
            ymin = temp;
        }
        if ((gridpoints = Grid2D.createGrid2D((double)xmin, (double)xmax, (double)ymin, (double)ymax, (int)8, (int)8)) == null) {
            this.draw = false;
            throw new Exception("Tangentialebene kann nicht gezeichnet werden");
        }
        double d = n.x1 * a.x1 + n.x2 * a.x2 + n.x3 * a.x3;
        int c = 0;
        double z = 0.0;
        int i = 0;
        while (i < 8) {
            int j = 0;
            while (j < 8) {
                Punkt2D point = gridpoints[i][j];
                z = n.x3 != 0.0 ? (d - point.x * n.x1 - point.y * n.x2) / n.x3 : a.x3;
                this.vertices[c] = new Vertex3D(point.x, point.y, z);
                ++c;
                ++j;
            }
            ++i;
        }
        c = 0;
        int k = 0;
        while (k < 7) {
            int i2 = 0;
            while (i2 < 7) {
                int p1 = k * 8 + i2;
                int p2 = (k + 1) * 8 + i2;
                int p3 = (k + 1) * 8 + i2 + 1;
                int p4 = k * 8 + i2 + 1;
                this.triangles[c] = new Triangle(this.vertices[p1], this.vertices[p2], this.vertices[p4]);
                this.triangles[++c] = new Triangle(this.vertices[p3], this.vertices[p4], this.vertices[p2]);
                ++c;
                ++i2;
            }
            ++k;
        }
    }

    void drawTangentPlane() {
        if (this.triangles[0] == null) {
            return;
        }
        this.rasterizer.enableZBuffer(true);
        int color = COLORPLANE.getRGB();
        int i = 0;
        while (i < this.triangles.length) {
            this.rasterizer.plotline(this.triangles[i].p1.dc, this.triangles[i].p2.dc, this.triangles[i].p1.distance, this.triangles[i].p2.distance, color);
            this.rasterizer.plotline(this.triangles[i].p1.dc, this.triangles[i].p3.dc, this.triangles[i].p1.distance, this.triangles[i].p3.distance, color);
            ++i;
        }
    }

    @Override
    public void prepaintcompute() {
        if (this.mode == 2) {
            int i;
            if (this.vertices == null) {
                this.vertices = new Vertex3D[64];
                i = 0;
                while (i < 64) {
                    this.vertices[i] = new Vertex3D();
                    ++i;
                }
            }
            i = 0;
            while (i < this.vertices.length) {
                this.vertices[i].dc = this.scene3d.project(this.vertices[i].mc);
                this.vertices[i].wc = this.scene3d.getWC(this.vertices[i].mc);
                this.vertices[i].distance = this.scene3d.calcdepth(this.vertices[i].wc);
                ++i;
            }
        }
    }
}

