/*
 * Decompiled with CFR 0.152.
 */
package uibk.draw3d.surface3d;

import java.util.Vector;
import uibk.draw3d.surface3d.Mesh;
import uibk.draw3d.surface3d.Triangle;
import uibk.draw3d.surface3d.Vertex3D;
import uibk.geom.CoordinateRect2D;
import uibk.geom.Punkt2D;
import uibk.math.functions.ParsedFunction2D;
import uibk.util.Grid2D;
import uibk.util.Line2DIterator;

public class Function2DMeshBuilder {
    ParsedFunction2D f;
    double thresh;
    static final double THRESHOLDFACTOR = 0.3;
    static final int SINGCHECK_DISCRETSIZE = 30;
    static final double FACMIN = 0.001;
    static final double FACDIFF = 10.0;
    private double zmin;
    private double zmax;
    private Vector mesh_vertices;
    private boolean[] added;
    Vertex3D[] vertices;

    public Function2DMeshBuilder(ParsedFunction2D f) {
        this.f = f;
    }

    private Mesh simpleTriangulization(Vertex3D[] vertices, int nx, int ny) throws Exception {
        Vector<Triangle> triangles = new Vector<Triangle>((nx - 1) * (ny - 1) * 2);
        Vector<Vertex3D> vert = new Vector<Vertex3D>(nx * ny);
        int i = 0;
        while (i < vertices.length) {
            if (!vertices[i].mc.isReal()) {
                throw new Exception("Division durch 0 oder \u00dcberlauf: Fl\u00e4che kann nicht trianguliert werden");
            }
            ++i;
        }
        int k = 0;
        while (k < nx - 1) {
            int i2 = 0;
            while (i2 < ny - 1) {
                int p1 = k * nx + i2;
                int p2 = (k + 1) * nx + i2;
                int p3 = (k + 1) * nx + i2 + 1;
                int p4 = k * nx + i2 + 1;
                triangles.add(new Triangle(vertices[p1], vertices[p2], vertices[p4]));
                triangles.add(new Triangle(vertices[p3], vertices[p4], vertices[p2]));
                ++i2;
            }
            ++k;
        }
        if (triangles.size() == 0) {
            throw new Exception("Fehler bei der Triangulierung: ");
        }
        i = 0;
        while (i < vertices.length) {
            vert.add(vertices[i]);
            ++i;
        }
        return new Mesh(triangles, vert);
    }

    private Mesh advancedTriangulization(Vertex3D[] vertices, int nx, int ny) throws Exception {
        Vector<Triangle> triangles = new Vector<Triangle>((nx - 1) * (ny - 1) * 2);
        this.mesh_vertices = new Vector(nx * ny);
        this.thresh = (this.zmax - this.zmin) * 0.3;
        Punkt2D a1 = new Punkt2D();
        Punkt2D a2 = new Punkt2D();
        Punkt2D a3 = new Punkt2D();
        Punkt2D a4 = new Punkt2D();
        int k = 0;
        while (k < nx - 1) {
            int i = 0;
            while (i < ny - 1) {
                int p1 = k * nx + i;
                int p2 = (k + 1) * nx + i;
                int p3 = (k + 1) * nx + i + 1;
                int p4 = k * nx + i + 1;
                a1.setLocation(vertices[p1].mc.x1, vertices[p1].mc.x2);
                a2.setLocation(vertices[p2].mc.x1, vertices[p2].mc.x2);
                a3.setLocation(vertices[p3].mc.x1, vertices[p3].mc.x2);
                a4.setLocation(vertices[p4].mc.x1, vertices[p4].mc.x2);
                if (!(this.hasSingularity(a1, a2) || this.hasSingularity(a2, a4) || this.hasSingularity(a4, a1))) {
                    this.add(p1);
                    this.add(p2);
                    this.add(p4);
                    triangles.add(new Triangle(vertices[p1], vertices[p2], vertices[p4]));
                }
                if (!(this.hasSingularity(a3, a2) || this.hasSingularity(a2, a4) || this.hasSingularity(a4, a3))) {
                    this.add(p3);
                    this.add(p2);
                    this.add(p4);
                    triangles.add(new Triangle(vertices[p3], vertices[p4], vertices[p2]));
                }
                ++i;
            }
            ++k;
        }
        if (triangles.size() == 0) {
            throw new Exception("Bei Test auf Singularit\u00e4ten wurden alle Dreicke aussortiert. Vergr\u00f6\u00dfern Sie die Anzahl der Gitterpunkte");
        }
        return new Mesh(triangles, this.mesh_vertices);
    }

    private void add(int i) {
        if (!this.added[i]) {
            this.mesh_vertices.add(this.vertices[i]);
            this.added[i] = true;
        }
    }

    public Mesh build(CoordinateRect2D rect, int nx, int ny, boolean checksing) throws Exception {
        this.vertices = new Vertex3D[nx * ny];
        this.added = new boolean[nx * ny];
        Punkt2D[][] grid = Grid2D.createGrid2D((double)rect.xmin, (double)rect.xmax, (double)rect.ymin, (double)rect.ymax, (int)nx, (int)ny);
        double z = 0.0;
        this.zmin = Double.POSITIVE_INFINITY;
        this.zmax = Double.NEGATIVE_INFINITY;
        int c = 0;
        int i = 0;
        while (i < nx) {
            int j = 0;
            while (j < ny) {
                z = this.f.getValue(grid[i][j].x, grid[i][j].y);
                if (!Double.isInfinite(z) && !Double.isNaN(z)) {
                    if (z < this.zmin) {
                        this.zmin = z;
                    }
                    if (z > this.zmax) {
                        this.zmax = z;
                    }
                }
                this.vertices[c] = new Vertex3D(grid[i][j].x, grid[i][j].y, z);
                ++c;
                ++j;
            }
            ++i;
        }
        if (checksing) {
            return this.advancedTriangulization(this.vertices, nx, ny);
        }
        return this.simpleTriangulization(this.vertices, nx, ny);
    }

    private boolean hasSingularity(Punkt2D p1, Punkt2D p2) {
        Line2DIterator it = new Line2DIterator(p1, p2, 30);
        double last = 0.0;
        double sum = 0.0;
        int c = 0;
        double threshmin = Math.max(0.001 * (this.zmax - this.zmin), 0.001);
        while (it.hasNext()) {
            Punkt2D p = (Punkt2D)it.next();
            double z = this.f.getValue(p.x, p.y);
            if (Double.isNaN(z) || Double.isInfinite(z)) {
                return true;
            }
            if (it.getPos() > 1) {
                double diff = Math.abs(z - last);
                if (diff > this.thresh) {
                    return true;
                }
                if (c > 0 && sum > threshmin && diff > sum / (double)c * 10.0) {
                    return true;
                }
                sum += diff;
                ++c;
            }
            last = z;
        }
        return false;
    }
}

