/*
 * Decompiled with CFR 0.152.
 */
package uibk.draw3d.objects;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.image.BufferedImage;
import java.util.Vector;
import uibk.draw2d.util.LineClipping2D;
import uibk.draw3d.base.Drawable3D;
import uibk.draw3d.util.LineClipping3D;
import uibk.geom.CoordinateCube3D;
import uibk.geom.Point3D;

public class Graph3D
extends Drawable3D {
    protected Stroke stroke = new BasicStroke();
    protected Vector points = new Vector();
    protected double xmin;
    protected double xmax;
    protected double ymin;
    protected double ymax;
    protected double zmin;
    protected double zmax;
    private static final int XCOMPONENT = 0;
    private static final int YCOMPONENT = 1;
    private static final int ZCOMPONENT = 2;

    public Graph3D() {
        this.color = Color.red;
    }

    public void recalcLimits() {
        this.xmin = Graph3D.min(this.points, 0);
        this.xmax = Graph3D.max(this.points, 0);
        this.ymin = Graph3D.min(this.points, 1);
        this.ymax = Graph3D.max(this.points, 1);
        this.zmin = Graph3D.min(this.points, 2);
        this.zmax = Graph3D.max(this.points, 2);
    }

    public void addPoint(Point3D p) {
        this.points.add(p);
    }

    public void clearpoints() {
        this.points.clear();
        this.xmin = -1.0;
        this.xmax = 1.0;
        this.ymin = -1.0;
        this.ymax = 1.0;
        this.zmin = -1.0;
        this.zmax = 1.0;
    }

    public void setStroke(Stroke stroke) {
        this.stroke = stroke;
    }

    public void setPoints(Vector points) {
        this.points = points;
        this.xmin = Graph3D.min(points, 0);
        this.xmax = Graph3D.max(points, 0);
        this.ymin = Graph3D.min(points, 1);
        this.ymax = Graph3D.max(points, 1);
        this.zmin = Graph3D.min(points, 2);
        this.zmax = Graph3D.max(points, 2);
    }

    public CoordinateCube3D getLimits() {
        return new CoordinateCube3D(this.xmin, this.xmax, this.ymin, this.ymax, this.zmin, this.zmax);
    }

    static double max(Vector points, int component) {
        int i;
        double maximum = 0.0;
        if (component == 0) {
            maximum = ((Point3D)points.elementAt((int)0)).x1;
            i = 1;
            while (i < points.size()) {
                if (((Point3D)points.elementAt((int)i)).x1 > maximum) {
                    maximum = ((Point3D)points.elementAt((int)i)).x1;
                }
                ++i;
            }
        }
        if (component == 1) {
            maximum = ((Point3D)points.elementAt((int)0)).x2;
            i = 1;
            while (i < points.size()) {
                if (((Point3D)points.elementAt((int)i)).x2 > maximum) {
                    maximum = ((Point3D)points.elementAt((int)i)).x2;
                }
                ++i;
            }
        }
        if (component == 2) {
            maximum = ((Point3D)points.elementAt((int)0)).x3;
            i = 1;
            while (i < points.size()) {
                if (((Point3D)points.elementAt((int)i)).x3 > maximum) {
                    maximum = ((Point3D)points.elementAt((int)i)).x3;
                }
                ++i;
            }
        }
        return maximum;
    }

    static double min(Vector points, int component) {
        int i;
        double minimum = 0.0;
        if (component == 0) {
            minimum = ((Point3D)points.elementAt((int)0)).x1;
            i = 1;
            while (i < points.size()) {
                if (((Point3D)points.elementAt((int)i)).x1 < minimum) {
                    minimum = ((Point3D)points.elementAt((int)i)).x1;
                }
                ++i;
            }
        }
        if (component == 1) {
            minimum = ((Point3D)points.elementAt((int)0)).x2;
            i = 1;
            while (i < points.size()) {
                if (((Point3D)points.elementAt((int)i)).x2 < minimum) {
                    minimum = ((Point3D)points.elementAt((int)i)).x2;
                }
                ++i;
            }
        }
        if (component == 2) {
            minimum = ((Point3D)points.elementAt((int)0)).x3;
            i = 1;
            while (i < points.size()) {
                if (((Point3D)points.elementAt((int)i)).x3 < minimum) {
                    minimum = ((Point3D)points.elementAt((int)i)).x3;
                }
                ++i;
            }
        }
        return minimum;
    }

    @Override
    public void draw(BufferedImage framebuffer, Graphics2D g2) {
        Stroke oldStroke = g2.getStroke();
        g2.setStroke(this.stroke);
        g2.setColor(this.color);
        Rectangle clippingrect = new Rectangle(0, 0, this.panel.getWidth(), this.panel.getHeight());
        double yc = this.scene3d.getClippingPlane();
        Point3D ca = new Point3D();
        Point3D cb = new Point3D();
        Point p = new Point();
        Point q = new Point();
        Point3D[] vertices = new Point3D[this.points.size()];
        int i = 0;
        while (i < vertices.length) {
            vertices[i] = this.scene3d.getWC((Point3D)this.points.elementAt(i));
            ++i;
        }
        i = 0;
        while (i < this.points.size() - 1) {
            Point p2;
            Point p1;
            Point3D start = vertices[i];
            Point3D end = vertices[i + 1];
            if (LineClipping3D.clipline3d(start, end, ca, cb, yc) && LineClipping2D.cohensutherland(p1 = this.scene3d.wctoDevice(ca), p2 = this.scene3d.wctoDevice(cb), p, q, clippingrect)) {
                g2.drawLine(p.x, p.y, q.x, q.y);
            }
            ++i;
        }
        g2.setStroke(oldStroke);
    }
}

