/*
 * Decompiled with CFR 0.152.
 */
package uibk.draw3d.base;

import java.awt.Point;
import uibk.draw3d.base.MathPanel3D;
import uibk.draw3d.base.Matrix3D;
import uibk.geom.CoordinateCube3D;
import uibk.geom.Point3D;
import uibk.geom.Punkt2D;
import uibk.geom.Vector2D;
import uibk.geom.Vector3D;

public class Scene3D {
    protected Matrix3D M;
    protected Matrix3D V;
    Matrix3D P;
    Matrix3D N;
    Matrix3D T;
    MathPanel3D mathpanel3d;
    boolean changed;
    int scalingmode;
    public double rotationx = 0.0;
    public double rotationz = 0.0;
    public double rotationy = 0.0;
    double distance = 4.0;
    double scalex = 0.7;
    double scaley = 0.7;
    double scalez = 0.7;
    private CoordinateCube3D nc_window = new CoordinateCube3D();
    private CoordinateCube3D boundingbox = new CoordinateCube3D();
    public static final int SCALE_EQUAL = 0;
    public static final int SCALE_INDEPENDENT = 1;
    static final double DEGREE90 = 1.5707963267948966;
    static final double DEGREE180 = Math.PI;
    public static final int PROJECT_PERSPECTIVE = 0;
    public static final int PROJECT_PARALLEL = 1;
    int projectiontype = 0;

    public void setScalingMode(int mode) {
        this.scalingmode = mode;
        this.changed = true;
    }

    public int getScalingMode() {
        return this.scalingmode;
    }

    public Point3D getWC(Point3D p) {
        return Matrix3D.multiplyVector3D(this.M, p);
    }

    public void defaultview() {
        this.projectiontype = 0;
        this.distance = 3.0;
        this.rotationx = 0.0;
        this.rotationz = 1.2;
        this.rotationy = 0.0;
        this.scalex = 0.45;
        this.scaley = 0.45;
        this.scalez = 0.45;
        this.changed = true;
    }

    public void projectXZPlane() {
        this.rotationx = 0.0;
        this.rotationz = Math.PI;
        this.rotationy = 0.0;
        this.changed = true;
    }

    public void projectXYPlane() {
        this.rotationx = 1.5707963267948966;
        this.rotationz = 0.0;
        this.rotationy = Math.PI;
        this.changed = true;
    }

    public void projectYZPlane() {
        this.rotationx = 0.0;
        this.rotationz = 1.5707963267948966;
        this.rotationy = 0.0;
        this.changed = true;
    }

    public int getProjectionType() {
        return this.projectiontype;
    }

    public void setDistance(double distance) {
        this.distance = distance;
        this.changed = true;
    }

    public void setXScaleFactor(double scalex) {
        this.scalex = scalex;
        this.changed = true;
    }

    public void setYScaleFactor(double scaley) {
        this.scaley = scaley;
        this.changed = true;
    }

    public void setZScaleFactor(double scalez) {
        this.scalez = scalez;
        this.changed = true;
    }

    public double getXScaleFactor() {
        return this.scalex;
    }

    public double getYScaleFactor() {
        return this.scaley;
    }

    public double getZScaleFactor() {
        return this.scalez;
    }

    public Scene3D() {
        this.defaultview();
    }

    public void setRotationX(double rot) {
        this.rotationx = rot;
        this.changed = true;
    }

    public void setRotationY(double rot) {
        this.rotationy = rot;
        this.changed = true;
    }

    public void setRotationZ(double rot) {
        this.rotationz = rot;
        this.changed = true;
    }

    public void setProjectionType(int type) {
        this.projectiontype = type;
        this.changed = true;
    }

    public boolean isClippingEnabled() {
        return true;
    }

    public double getRotationX() {
        return this.rotationx;
    }

    public double getRotationY() {
        return this.rotationy;
    }

    public double getRotationZ() {
        return this.rotationz;
    }

    public void setPanel(MathPanel3D mathpanel3d) {
        this.mathpanel3d = mathpanel3d;
    }

    public void setBoundingBox(CoordinateCube3D box) {
        this.boundingbox = box;
        if (box.getXRange() == 0.0) {
            this.boundingbox.xmin = -1.0;
            this.boundingbox.xmax = 1.0;
        }
        if (box.getZRange() == 0.0) {
            this.boundingbox.zmin = -1.0;
            this.boundingbox.zmax = 1.0;
        }
        if (box.getYRange() == 0.0) {
            this.boundingbox.ymin = -1.0;
            this.boundingbox.ymax = 1.0;
        }
        this.changed = true;
    }

    public CoordinateCube3D getBoundingBox() {
        return this.boundingbox;
    }

    public double getClippingPlane() {
        return this.distance - 0.1;
    }

    public void setupMatrices() {
        this.setupModelViewMatrix();
        this.P = this.projectiontype == 0 ? Matrix3D.getPerspectiveProjectionMatrixXZPlane(this.distance) : Matrix3D.getParallelProjectionMatrixXZPlane();
        this.setupViewPortTransformationMatrix();
        this.T = Matrix3D.multiply(this.V, Matrix3D.multiply(this.P, this.M));
        this.setupNormalTransMatrix();
    }

    public Point3D getCamera() {
        return new Point3D(0.0, this.distance, 0.0);
    }

    private void setupViewPortTransformationMatrix() {
        int vx_min = 0;
        int vy_min = 0;
        int vx_max = this.mathpanel3d.getWidth();
        int vy_max = this.mathpanel3d.getHeight();
        Matrix3D SN = Matrix3D.getScaleMatrix(1.0 / (this.nc_window.xmax - this.nc_window.xmin), 1.0 / (this.nc_window.ymax - this.nc_window.ymin), 1.0 / (this.nc_window.zmax - this.nc_window.zmin));
        Matrix3D SV = Matrix3D.getScaleMatrix(vx_max - vx_min, 1.0, vy_max - vy_min);
        Matrix3D TV = Matrix3D.getTranslationMatrix(vx_min, 0.0, vy_min);
        Matrix3D TW = Matrix3D.getTranslationMatrix(-this.nc_window.xmin, -this.nc_window.ymin, -this.nc_window.zmin);
        this.V = Matrix3D.multiply(TV, Matrix3D.multiply(SV, Matrix3D.multiply(SN, TW)));
    }

    public Point wctoDevice(Point3D a) {
        Matrix3D Z = Matrix3D.multiply(this.V, this.P);
        Vector3D p = Matrix3D.multiplyVector3D(Z, a);
        double h = p.h;
        p.x1 /= h;
        p.x3 /= h;
        return new Point(this.mathpanel3d.getWidth() - (int)p.x1, this.mathpanel3d.getHeight() - (int)p.x3);
    }

    public Point mcToDevice(Point3D a) {
        Vector3D p = Matrix3D.multiplyVector3D(this.T, a);
        double h = p.h;
        return new Point(this.mathpanel3d.getWidth() - (int)(p.x1 / h), this.mathpanel3d.getHeight() - (int)(p.x3 / h));
    }

    public Punkt2D project(Point3D a) {
        Vector3D p = Matrix3D.multiplyVector3D(this.T, a);
        double h = p.h;
        return new Punkt2D(this.mathpanel3d.getWidth() - (int)(p.x1 / h), this.mathpanel3d.getHeight() - (int)(p.x3 / h));
    }

    public double calcdepth(Point3D p) {
        return 1.0 / this.getCamera().sub(p).quadnorm();
    }

    void setupModelViewMatrix() {
        Point3D center = this.boundingbox == null ? new Point3D(0.0, 0.0, 0.0) : this.boundingbox.getCenter();
        Matrix3D TR = Matrix3D.getTranslationMatrix(-center.x1, -center.x2, -center.x3);
        double max = Math.max(Math.max(this.boundingbox.getXRange(), this.boundingbox.getYRange()), this.boundingbox.getZRange());
        Matrix3D SR = this.scalingmode == 0 ? Matrix3D.getScaleMatrix(this.nc_window.getXRange() / max, this.nc_window.getYRange() / max, this.nc_window.getZRange() / max) : Matrix3D.getScaleMatrix(this.nc_window.getXRange() / this.boundingbox.getXRange(), this.nc_window.getYRange() / this.boundingbox.getYRange(), this.nc_window.getZRange() / this.boundingbox.getZRange());
        Matrix3D SUSER = Matrix3D.getScaleMatrix(this.scalex, this.scaley, this.scalez);
        Matrix3D S = Matrix3D.multiply(SUSER, SR);
        Matrix3D rotX = Matrix3D.getRotationMatrixXAxis(this.rotationx);
        Matrix3D rotZ = Matrix3D.getRotationMatrixZAxis(this.rotationz);
        Matrix3D rotY = Matrix3D.getRotationMatrixYAxis(this.rotationy);
        Matrix3D R = Matrix3D.multiply(rotX, Matrix3D.multiply(rotZ, rotY));
        this.M = Matrix3D.multiply(R, Matrix3D.multiply(S, TR));
    }

    public Matrix3D getModelViewMatrix() {
        return this.M;
    }

    private void setupNormalTransMatrix() {
        try {
            Matrix3D temp = Matrix3D.inverse(this.M);
            this.N = Matrix3D.transpose(temp);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public double getDistance() {
        return this.distance;
    }

    public Vector3D transformNormal(Vector3D v) {
        return Matrix3D.multiplyVector3D(this.N, v);
    }

    public Vector2D projectVector(Point3D base, Vector3D mc_dir) {
        Vector2D dir;
        Vector3D wc_dir = this.transformNormal(mc_dir);
        Punkt2D pzero = this.project(base);
        if (wc_dir.x2 > 0.0) {
            mc_dir.scale(-this.getBoundingBox().maxBoundingBox());
            Punkt2D temp = this.project(base.add(mc_dir));
            dir = temp.sub(pzero).toVector();
            dir.x = -dir.x;
            dir.y = -dir.y;
        } else {
            mc_dir.scale(this.getBoundingBox().maxBoundingBox());
            Punkt2D temp = this.project(base.add(mc_dir));
            dir = temp.sub(pzero).toVector();
        }
        dir.normalize();
        return dir;
    }
}

