/*
 * Decompiled with CFR 0.152.
 */
package uibk.draw3d.base;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;
import java.util.Vector;
import javax.swing.JLabel;
import uibk.draw3d.base.Drawable3D;
import uibk.draw3d.base.Scene3D;
import uibk.lang.Dragable;
import uibk.lang.Options;
import uibk.lang.PrepaintComputable;
import uibk.lang.ToolTipable;
import uibk.swing.Panel;

public class MathPanel3D
extends Panel
implements ComponentListener {
    Dragable dragged = null;
    boolean listenForDrags = false;
    MathPanel3D mathpanel = this;
    private static final double ROT = 0.05;
    protected Scene3D scene3d;
    protected Vector drawItems = new Vector();
    protected Vector renderableItems = new Vector();
    int oldy;
    int oldx;
    private JLabel labelReports = null;
    private MyMouseListening mouseListener = new MyMouseListening();
    private MyMouseMotionListening mouseMotionListener = new MyMouseMotionListening();
    public static final int SUCCESS = 0;
    public static final int NORMAL = 1;
    public static final int ERROR = 2;
    public BufferedImage framebuffer;
    public double[][] zbuffer;

    public void requestRecompute() {
        this.scene3d.changed = true;
    }

    @Override
    public void componentShown(ComponentEvent ev) {
    }

    @Override
    public void componentHidden(ComponentEvent ev) {
    }

    @Override
    public void componentResized(ComponentEvent ev) {
        this.scene3d.changed = true;
        this.repaint();
    }

    @Override
    public void componentMoved(ComponentEvent ev) {
    }

    @Override
    public void repaint() {
        if (this.scene3d != null) {
            this.scene3d.changed = true;
        }
        super.repaint();
    }

    public MathPanel3D() {
        this.setDoubleBuffered(true);
        this.setBackground(Color.white);
        this.scene3d = new Scene3D();
        this.scene3d.setPanel(this);
        this.setListenForDrags(true);
        this.addComponentListener(this);
    }

    public Scene3D getScene3D() {
        return this.scene3d;
    }

    public void setListenForDrags(boolean listenForDrags) {
        if (listenForDrags == this.listenForDrags) {
            return;
        }
        this.listenForDrags = listenForDrags;
        if (listenForDrags) {
            this.addMouseListener(this.mouseListener);
            this.addMouseMotionListener(this.mouseMotionListener);
        } else {
            this.removeMouseListener(this.mouseListener);
            this.removeMouseMotionListener(this.mouseMotionListener);
        }
    }

    public synchronized void add(Object obj) {
        if (obj != null && obj instanceof Drawable3D && !this.drawItems.contains(obj)) {
            Drawable3D draw = (Drawable3D)obj;
            draw.setMathPanel3d(this);
            this.drawItems.addElement(draw);
        }
    }

    void resetZBuffer() {
        int i = 0;
        while (i < this.getWidth() - 1) {
            int j = 0;
            while (j < this.getHeight() - 1) {
                this.zbuffer[i][j] = Double.NEGATIVE_INFINITY;
                ++j;
            }
            ++i;
        }
    }

    @Override
    public synchronized void paint(Graphics g) {
        super.paint(g);
        this.preparebuffers();
        this.resetZBuffer();
        this.scene3d.setPanel(this);
        Graphics2D g2 = this.framebuffer.createGraphics();
        g2.setColor(Color.white);
        g2.fillRect(0, 0, this.framebuffer.getWidth(), this.framebuffer.getHeight());
        this.drawDrawables(this.framebuffer, g2);
        g.drawImage(this.framebuffer, 0, 0, null);
    }

    boolean preparebuffers() {
        int w = this.getWidth();
        int h = this.getHeight();
        if (this.framebuffer == null || w > this.framebuffer.getWidth() || h > this.framebuffer.getHeight()) {
            this.framebuffer = (BufferedImage)this.createImage(w, h);
            this.zbuffer = new double[w][h];
            return true;
        }
        return false;
    }

    protected synchronized void drawDrawables(BufferedImage framebuffer, Graphics2D g2) {
        int i;
        this.scene3d.setupMatrices();
        Options.setRenderingHints(g2);
        int ct = this.drawItems.size();
        if (this.scene3d.changed) {
            i = 0;
            while (i < ct) {
                if (this.drawItems.elementAt(i) instanceof PrepaintComputable && ((Drawable3D)this.drawItems.elementAt(i)).getVisible()) {
                    try {
                        ((PrepaintComputable)this.drawItems.elementAt(i)).prepaintcompute();
                    }
                    catch (Exception ex) {
                        System.out.println(ex.getMessage());
                    }
                }
                ++i;
            }
        }
        i = 0;
        while (i < ct) {
            Drawable3D d = (Drawable3D)this.drawItems.elementAt(i);
            if (d.getVisible()) {
                d.draw(framebuffer, g2);
            }
            ++i;
        }
        this.scene3d.changed = false;
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        int ct = this.drawItems.size();
        int i = 0;
        while (i < ct) {
            if (this.drawItems.elementAt(i) instanceof ToolTipable && ((ToolTipable)this.drawItems.elementAt(i)).isToolTipEnabled() && ((ToolTipable)this.drawItems.elementAt(i)).tooltipcontains(event.getX(), event.getY())) {
                return ((ToolTipable)this.drawItems.elementAt(i)).getToolTipText(event);
            }
            ++i;
        }
        return null;
    }

    public void report(String message) {
        this.labelReports.setForeground(Color.black);
        this.labelReports.setText(message);
    }

    public void reportError(String message) {
        this.labelReports.setForeground(new Color(255, 51, 0));
        this.labelReports.setText(message);
    }

    public void reportSuccess(String message) {
        this.labelReports.setForeground(new Color(0, 200, 0));
        this.labelReports.setText(message);
    }

    public void setReportingLabel(JLabel label) {
        this.labelReports = label;
    }

    private class MyMouseListening
    extends MouseAdapter {
        private MyMouseListening() {
        }

        @Override
        public void mousePressed(MouseEvent ev) {
            if (ev.getButton() == 2) {
                int i = MathPanel3D.this.drawItems.size() - 1;
                while (i >= 0) {
                    if (MathPanel3D.this.drawItems.elementAt(i) instanceof Dragable && ((Dragable)MathPanel3D.this.drawItems.elementAt(i)).dragcontains(ev.getX(), ev.getY())) {
                        MathPanel3D.this.dragged = (Dragable)MathPanel3D.this.drawItems.elementAt(i);
                        MathPanel3D.this.drawItems.remove(i);
                        MathPanel3D.this.drawItems.add((Drawable3D)MathPanel3D.this.dragged);
                    }
                    --i;
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent ev) {
            MathPanel3D.this.repaint();
        }
    }

    private class MyMouseMotionListening
    extends MouseMotionAdapter {
        private MyMouseMotionListening() {
        }

        @Override
        public void mouseDragged(MouseEvent ev) {
            double max = Math.max(Math.abs(ev.getY() - MathPanel3D.this.oldy), Math.abs(ev.getX() - MathPanel3D.this.oldx));
            if (max == 0.0) {
                max = 1.0;
            }
            double offx = ev.getY() < MathPanel3D.this.oldy ? 0.05 : -0.05;
            MathPanel3D.this.scene3d.setRotationX(MathPanel3D.this.scene3d.getRotationX() + (offx *= (double)Math.abs(ev.getY() - MathPanel3D.this.oldy) / max));
            MathPanel3D.this.oldy = ev.getY();
            double offz = ev.getX() < MathPanel3D.this.oldx ? -0.05 : 0.05;
            MathPanel3D.this.scene3d.setRotationZ(MathPanel3D.this.scene3d.getRotationZ() + (offz *= (double)Math.abs(ev.getX() - MathPanel3D.this.oldx) / max));
            MathPanel3D.this.oldx = ev.getX();
            MathPanel3D.this.mathpanel.repaint();
            if (MathPanel3D.this.dragged == null) {
                return;
            }
            MathPanel3D.this.dragged.drag(ev);
        }
    }
}

