/*
 * Decompiled with CFR 0.152.
 */
package uibk.draw2d.util;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.Rectangle2D;
import uibk.geom.Punkt2D;
import uibk.geom.Vector2D;
import uibk.lang.Options;

public final class MiscDrawing2D {
    private MiscDrawing2D() {
    }

    public static void drawArrow(Graphics2D g2, Punkt2D base, Punkt2D head, int lengtharrowhead, int offsetwings) {
        Options.setRenderingHints(g2);
        if (base.equals(head) || !base.isReal() || !head.isReal()) {
            return;
        }
        Vector2D dir = base.sub(head).toVector();
        dir.normalize();
        if (Double.isNaN(dir.x) || Double.isInfinite(dir.x) || Double.isNaN(dir.y) || Double.isInfinite(dir.y) || dir.x == 0.0 && dir.y == 0.0) {
            return;
        }
        Vector2D n = dir.normaldir();
        dir.scaleself(lengtharrowhead);
        n.scaleself(offsetwings);
        Punkt2D s = head.add(dir);
        Punkt2D left = s.add(n);
        Punkt2D right = s.add(Punkt2D.inverse(n));
        g2.drawLine((int)base.x, (int)base.y, (int)head.x, (int)head.y);
        g2.drawLine((int)left.x, (int)left.y, (int)head.x, (int)head.y);
        g2.drawLine((int)right.x, (int)right.y, (int)head.x, (int)head.y);
    }

    public static void fillCircle(Graphics2D g2, Point center, int radius) {
        g2.fillOval(center.x - radius, center.y - radius, 2 * radius + 1, 2 * radius + 1);
    }

    public static void drawCircle(Graphics2D g2, int x, int y, int radius) {
        g2.drawOval(x - radius, y - radius, 2 * radius + 1, 2 * radius + 1);
    }

    public static void fillCircle(Graphics2D g2, int x, int y, int radius) {
        g2.fillOval(x - radius, y - radius, 2 * radius + 1, 2 * radius + 1);
    }

    public static void drawStar(Graphics2D g2, Point p, int radius) {
        int rhalf = radius / 2;
        g2.drawLine(p.x - rhalf, p.y, p.x + rhalf, p.y);
        g2.drawLine(p.x, p.y - rhalf, p.x, p.y + rhalf);
        g2.drawLine(p.x - rhalf, p.y - rhalf, p.x + rhalf, p.y + rhalf);
        g2.drawLine(p.x - rhalf, p.y + rhalf, p.x + rhalf, p.y - rhalf);
    }

    public static void drawLabel(Graphics2D g2, Point pos, String label, Color background, Color font) {
        Color old = g2.getColor();
        FontMetrics metrics = g2.getFontMetrics();
        Rectangle2D rect = metrics.getStringBounds(label, g2);
        int w = (int)rect.getWidth() + 4;
        int h = (int)rect.getHeight();
        int x = pos.x - 2;
        int y = pos.y - (int)rect.getHeight() + 2;
        g2.setColor(background);
        g2.fillRect(x, y, w, h);
        g2.setColor(Color.black);
        g2.drawRect(x, y, w, h);
        g2.setColor(font);
        g2.drawString(label, pos.x, pos.y);
        g2.setColor(old);
    }
}

