/*
 * Decompiled with CFR 0.152.
 */
package uibk.draw2d.objects;

import java.awt.Color;
import java.awt.event.MouseEvent;
import uibk.draw2d.base.Drawable2D;
import uibk.draw2d.base.MathPanel2D;
import uibk.draw2d.objects.MathPoint2D;
import uibk.draw2d.objects.PointPlot2D;
import uibk.math.MathUtil;

public class GraphSequence
extends PointPlot2D {
    private String strFormula;

    public void setFormula(String formula) {
        this.strFormula = formula;
    }

    @Override
    public String getToolTipText(MouseEvent ev) {
        int size = this.points.size();
        int i = 0;
        while (i < size) {
            MathPoint2D p = (MathPoint2D)this.points.elementAt(i);
            if (p.tooltipcontains(ev.getX(), ev.getY())) {
                String str = p.getX() == 0.0 || p.getX() == (double)(size - 1) ? "<html>Formel: <b>a(n)=" + this.strFormula + "</b><br>a(" + p.getX() + ")=" + String.valueOf(p.getY()) : "a(" + String.valueOf((int)p.getX()) + ")=" + String.valueOf(p.getY());
                return str;
            }
            ++i;
        }
        return null;
    }

    @Override
    public void setMathPanel2d(MathPanel2D panel) {
        super.setMathPanel2d(panel);
        int ct = this.points.size();
        int i = 0;
        while (i < ct) {
            ((Drawable2D)this.points.elementAt(i)).setMathPanel2d(panel);
            ++i;
        }
    }

    public GraphSequence() {
        this.linecolor = Color.blue;
        this.pointcolor = Color.red;
        this.pointradius = 2;
        this.connectpoints = true;
        this.tooltipenabled = true;
    }

    public void setSequence(double[] a, int startIndex, int endIndex) {
        this.points.clear();
        this.ymax = MathUtil.max((double[])a);
        this.ymin = MathUtil.min((double[])a);
        this.xmin = startIndex;
        this.xmax = endIndex;
        int index = startIndex;
        int i = 0;
        while (i < a.length) {
            MathPoint2D temp = new MathPoint2D(index, a[i]);
            temp.setMathPanel2d(this.panel);
            temp.setRadius(this.pointradius);
            temp.setColor(this.pointcolor);
            this.points.add(temp);
            ++index;
            ++i;
        }
    }
}

