/*
 * Decompiled with CFR 0.152.
 */
package uibk.draw2d.objects;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.image.BufferedImage;
import java.util.Vector;
import uibk.draw2d.base.Drawable2D;
import uibk.geom.CoordinateRect2D;
import uibk.geom.Punkt2D;

public class Graph2D
extends Drawable2D {
    protected Stroke stroke;
    protected Vector points = new Vector();
    protected double xmin;
    protected double xmax;
    protected double ymin;
    protected double ymax;
    private boolean limitsdirty = true;
    private static final int XCOMPONENT = 0;
    private static final int YCOMPONENT = 1;

    public Graph2D() {
        this.color = Color.red;
        this.stroke = new BasicStroke();
    }

    public void setStroke(Stroke stroke) {
        this.stroke = stroke;
    }

    public void setPoints(Vector points) {
        this.points = points;
        this.limitsdirty = true;
    }

    public void addPoint(Punkt2D p) {
        this.points.add(p);
        this.limitsdirty = true;
    }

    private void recalcLimits() {
        if (this.points != null && this.points.size() > 0) {
            this.xmin = Graph2D.min(this.points, 0);
            this.xmax = Graph2D.max(this.points, 0);
            this.ymin = Graph2D.min(this.points, 1);
            this.ymax = Graph2D.max(this.points, 1);
        } else {
            this.xmin = -1.0;
            this.xmax = 1.0;
            this.ymin = -1.0;
            this.ymax = 1.0;
        }
    }

    public void clearpoints() {
        this.points.clear();
        this.xmin = -1.0;
        this.xmax = 1.0;
        this.ymin = -1.0;
        this.ymax = 1.0;
    }

    public Vector getPoints() {
        return this.points;
    }

    public int getNumberPoints() {
        return this.points.size();
    }

    public double getXmin() {
        return this.xmin;
    }

    public double getXmax() {
        return this.xmax;
    }

    public double getYmin() {
        return this.ymin;
    }

    public double getYmax() {
        return this.ymax;
    }

    public CoordinateRect2D getLimits() {
        if (this.limitsdirty) {
            this.recalcLimits();
        }
        return new CoordinateRect2D(this.xmin, this.xmax, this.ymin, this.ymax);
    }

    private static double max(Vector points, int component) {
        int i;
        double maximum = 0.0;
        if (component == 0) {
            maximum = Double.NEGATIVE_INFINITY;
            i = 0;
            while (i < points.size()) {
                if ((Punkt2D)points.elementAt(i) != null && ((Punkt2D)points.elementAt((int)i)).x > maximum) {
                    maximum = ((Punkt2D)points.elementAt((int)i)).x;
                }
                ++i;
            }
        }
        if (component == 1) {
            maximum = Double.NEGATIVE_INFINITY;
            i = 0;
            while (i < points.size()) {
                if ((Punkt2D)points.elementAt(i) != null && ((Punkt2D)points.elementAt((int)i)).y > maximum) {
                    maximum = ((Punkt2D)points.elementAt((int)i)).y;
                }
                ++i;
            }
        }
        return maximum;
    }

    private static double min(Vector points, int component) {
        int i;
        double minimum = 0.0;
        if (component == 0) {
            minimum = Double.POSITIVE_INFINITY;
            i = 0;
            while (i < points.size()) {
                if ((Punkt2D)points.elementAt(i) != null && ((Punkt2D)points.elementAt((int)i)).x < minimum) {
                    minimum = ((Punkt2D)points.elementAt((int)i)).x;
                }
                ++i;
            }
        }
        if (component == 1) {
            minimum = Double.POSITIVE_INFINITY;
            i = 0;
            while (i < points.size()) {
                if ((Punkt2D)points.elementAt(i) != null && ((Punkt2D)points.elementAt((int)i)).y < minimum) {
                    minimum = ((Punkt2D)points.elementAt((int)i)).y;
                }
                ++i;
            }
        }
        return minimum;
    }

    @Override
    public void draw(BufferedImage framebuffer, Graphics2D g2) {
        Stroke oldStroke = g2.getStroke();
        g2.setStroke(this.stroke);
        g2.setColor(this.color);
        int i = 0;
        while (i < this.points.size() - 1) {
            Punkt2D start = (Punkt2D)this.points.elementAt(i);
            Punkt2D end = (Punkt2D)this.points.elementAt(i + 1);
            int startx = this.scene2d.xToPixel(start.x);
            int starty = this.scene2d.yToPixel(start.y);
            int endx = this.scene2d.xToPixel(end.x);
            int endy = this.scene2d.yToPixel(end.y);
            g2.setColor(this.color);
            g2.drawLine(startx, starty, endx, endy);
            ++i;
        }
        g2.setStroke(oldStroke);
    }
}

