/*
 * Decompiled with CFR 0.152.
 */
package uibk.draw2d.base;

import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import uibk.draw2d.base.MathPanel2D;
import uibk.geom.CoordinateRect2D;
import uibk.geom.Punkt2D;
import uibk.math.Interval;
import uibk.math.Rounder;

public class Scene2D {
    public static final int ROUND_X = 0;
    public static final int ROUND_XY = 1;
    public static final int ROUND_Y = 2;
    public static final int AREA_UPPERLEFT = 0;
    public static final int AREA_UPPERRIGHT = 1;
    public static final int AREA_UPPER = 2;
    public static final int AREA_LOWERLEFT = 3;
    public static final int AREA_LOWERRIGHT = 4;
    public static final int AREA_LOWER = 5;
    public static final int AREA_RIGHT = 6;
    public static final int AREA_LEFT = 7;
    public static final int AREA_ALL = 8;
    protected boolean changed = true;
    private int edge = 15;
    boolean ensurezero = false;
    private Insets insets = new Insets(0, 0, 0, 0);
    private MathPanel2D mathpanel2d;
    private Insets requestedInsets = new Insets(0, 0, 0, 0);
    private double xmin;
    private double xmax;
    private double ymin;
    private double ymax;

    public Scene2D() {
        this(-1.0, 1.0, -1.0, 1.0);
    }

    public void reset() {
        this.setLimits(-1.0, 1.0, -1.0, 1.0);
    }

    public Rectangle getCoordinatePixelRectangle() {
        Rectangle rect = new Rectangle();
        rect.x = this.xToPixel(this.xmin);
        rect.y = this.yToPixel(this.ymax);
        rect.width = this.xToPixel(this.xmax) - this.xToPixel(this.xmin);
        rect.height = this.yToPixel(this.ymin) - this.yToPixel(this.ymax);
        return rect;
    }

    public Scene2D(double xmin, double xmax, double ymin, double ymax) {
        this.setLimits(xmin, xmax, ymin, ymax);
    }

    boolean isScaleTooSmall() {
        return this.pixelToX(0) - this.pixelToX(1) == 0.0 || this.pixelToY(0) - this.pixelToY(1) == 0.0;
    }

    public void setXInterval(Interval interval) {
        this.setLimits(interval.a, interval.b, this.ymin, this.ymax);
    }

    public void setYInterval(Interval interval) {
        this.setLimits(this.xmin, this.xmax, interval.a, interval.b);
    }

    public boolean containsCoordinateSystem(Scene2D coords) {
        return this.xmin <= coords.xmin && this.xmax >= coords.xmax && this.ymin <= coords.ymin && this.ymax >= coords.ymax;
    }

    public void coordsChanged() {
        this.changed = true;
    }

    public void equalizeCoords() {
        int width = this.mathpanel2d.getWidth() - 2 * this.edge - this.insets.left - this.insets.right;
        int height = this.mathpanel2d.getHeight() - 2 * this.edge - this.insets.top - this.insets.bottom;
        double newxmin = this.xmin;
        double newxmax = this.xmax;
        double newymin = this.ymin;
        double newymax = this.ymax;
        double scaleX = (this.xmax - this.xmin) / (double)width;
        double scaleY = (this.ymax - this.ymin) / (double)height;
        int area = this.getArea();
        if (scaleX < scaleY) {
            double adjustX = scaleY * (double)width - (this.xmax - this.xmin);
            if (area == 1 || area == 6 || area == 4) {
                newxmax = this.xmax + adjustX;
            }
            if (area == 2 || area == 8 || area == 5) {
                newxmin = this.xmin - adjustX / 2.0;
                newxmax = this.xmax + adjustX / 2.0;
            }
            if (area == 0 || area == 7 || area == 3) {
                newxmin = this.xmin - adjustX;
            }
        } else {
            double adjustY = scaleX * (double)height - (this.ymax - this.ymin);
            if (area == 1 || area == 2 || area == 0) {
                newymax = this.ymax + adjustY;
            }
            if (area == 7 || area == 8 || area == 6) {
                newymax = this.ymax + adjustY / 2.0;
                newymin = this.ymin - adjustY / 2.0;
            }
            if (area == 4 || area == 5 || area == 3) {
                newymin = this.ymin - adjustY;
            }
        }
        this.checkAndSetLimits(newxmin, newxmax, newymin, newymax);
    }

    public CoordinateRect2D getCoordinates() {
        return new CoordinateRect2D(this.xmin, this.xmax, this.ymin, this.ymax);
    }

    public int getEdge() {
        return this.edge;
    }

    public Insets getInsets() {
        return this.insets;
    }

    public double getXmax() {
        return this.xmax;
    }

    public double getXmin() {
        return this.xmin;
    }

    public double getXPixelScale() {
        return (this.xmax - this.xmin) / (double)(this.mathpanel2d.getWidth() - 2 * this.edge - this.insets.left - this.insets.right);
    }

    public double getYmax() {
        return this.ymax;
    }

    public double getYmin() {
        return this.ymin;
    }

    public double getYPixelScale() {
        return (this.ymax - this.ymin) / (double)(this.mathpanel2d.getHeight() - 2 * this.edge - this.insets.top - this.insets.bottom);
    }

    public double pixelToX(int x) {
        return this.xmin + (double)(x - this.edge - this.insets.left) * (this.xmax - this.xmin) / (double)(this.mathpanel2d.getWidth() - 2 * this.edge - this.insets.left - this.insets.right - 1);
    }

    public double pixelToY(int y) {
        return this.ymax - (double)(y - this.edge - this.insets.top) * (this.ymax - this.ymin) / (double)(this.mathpanel2d.getHeight() - 2 * this.edge - this.insets.top - this.insets.bottom - 1);
    }

    public void processRequests() {
        if (this.requestedInsets.left != 0 || this.requestedInsets.right != 0 || this.requestedInsets.top != 0 || this.requestedInsets.bottom != 0) {
            this.insets.left += this.requestedInsets.left;
            this.insets.right += this.requestedInsets.right;
            this.insets.top += this.requestedInsets.top;
            this.insets.bottom += this.requestedInsets.bottom;
            this.changed = true;
            this.requestedInsets.left = 0;
            this.requestedInsets.right = 0;
            this.requestedInsets.top = 0;
            this.requestedInsets.bottom = 0;
        }
    }

    public void requestSpaceBottom(int pixel) {
        if (pixel >= this.mathpanel2d.getHeight() - this.edge && Math.abs(pixel - this.mathpanel2d.getHeight() + this.edge) > this.requestedInsets.bottom) {
            this.requestedInsets.bottom = Math.abs(pixel - this.mathpanel2d.getHeight() + this.edge);
        }
    }

    public void requestSpaceLeft(int pixel) {
        if (pixel <= this.edge && Math.abs(this.edge - pixel) > this.requestedInsets.left) {
            this.requestedInsets.left = Math.abs(this.edge - pixel);
        }
    }

    public void requestSpaceRight(int pixel) {
        if (pixel >= this.mathpanel2d.getWidth() - this.edge && Math.abs(pixel - this.mathpanel2d.getWidth() + this.edge) > this.requestedInsets.right) {
            this.requestedInsets.right = Math.abs(pixel - this.mathpanel2d.getWidth() + this.edge);
        }
    }

    public void requestSpaceTop(int pixel) {
        if (pixel <= this.edge && Math.abs(this.edge - pixel) > this.requestedInsets.top) {
            this.requestedInsets.top = Math.abs(this.edge - pixel);
        }
    }

    protected void resetInsets() {
        this.insets.bottom = 0;
        this.insets.top = 0;
        this.insets.left = 0;
        this.insets.right = 0;
        this.requestedInsets.bottom = 0;
        this.requestedInsets.top = 0;
        this.requestedInsets.left = 0;
        this.requestedInsets.right = 0;
    }

    public void roundCoords(int percent, int adjust) {
        CoordinateRect2D rounded = Scene2D.roundCoords(percent, adjust, this.getCoordinates());
        this.setLimits(rounded);
    }

    public static CoordinateRect2D roundCoords(int percent, int adjust, CoordinateRect2D coords) {
        double ymin = coords.ymin;
        double ymax = coords.ymax;
        double xmin = coords.xmin;
        double xmax = coords.xmax;
        double newymin = ymin;
        double newymax = ymax;
        double newxmin = xmin;
        double newxmax = xmax;
        double distx = Math.abs((xmax - xmin) / 100.0 * (double)percent);
        double disty = Math.abs((ymax - ymin) / 100.0 * (double)percent);
        if (adjust == 2 || adjust == 1) {
            newymax = Rounder.getUpperRoundValue((double)ymax, (double)disty);
            newymin = Rounder.getLowerRoundValue((double)ymin, (double)disty);
        }
        if (adjust == 0 || adjust == 1) {
            newxmax = Rounder.getUpperRoundValue((double)xmax, (double)distx);
            newxmin = Rounder.getLowerRoundValue((double)xmin, (double)distx);
        }
        if (adjust == 2 || adjust == 1) {
            if (ymin > 0.0 && ymin - disty < 0.0) {
                newymin = 0.0;
            }
            if (ymax < 0.0 && ymax + disty > 0.0) {
                newymax = 0.0;
            }
        }
        if (adjust == 0 || adjust == 1) {
            if (xmin > 0.0 && xmin - distx < 0.0) {
                newxmin = 0.0;
            }
            if (xmax < 0.0 && xmax + distx > 0.0) {
                newxmax = 0.0;
            }
        }
        return new CoordinateRect2D(newxmin, newxmax, newymin, newymax);
    }

    public void setEdge(int edge) {
        if (this.edge != edge) {
            this.changed = true;
            this.edge = edge;
        }
    }

    public void setLimits(CoordinateRect2D coordinates) {
        this.setLimits(coordinates.xmin, coordinates.xmax, coordinates.ymin, coordinates.ymax);
    }

    public void setLimits(double xmin, double xmax, double ymin, double ymax) {
        this.checkAndSetLimits(xmin, xmax, ymin, ymax);
    }

    public void ensureLimits(CoordinateRect2D coordinates) {
        double newxmin = this.xmin < coordinates.xmin ? this.xmin : coordinates.xmin;
        double newxmax = this.xmax < coordinates.xmax ? coordinates.xmax : this.xmax;
        double newymin = this.ymin < coordinates.ymin ? this.ymin : coordinates.ymin;
        double newymax = this.ymax < coordinates.ymax ? coordinates.ymax : this.ymax;
        this.setLimits(newxmin, newxmax, newymin, newymax);
    }

    public void ensureZeroY() {
        if (this.ymin > 0.0) {
            this.setLimits(this.xmin, this.xmax, 0.0, this.ymax);
            return;
        }
        if (this.ymax < 0.0) {
            this.setLimits(this.xmin, this.xmax, this.ymin, 0.0);
            return;
        }
    }

    public void ensureZeroX() {
        if (this.xmin > 0.0) {
            this.setLimits(0.0, this.xmax, this.ymin, this.ymax);
            return;
        }
        if (this.xmax < 0.0) {
            this.setLimits(this.xmin, 0.0, this.ymin, this.ymax);
            return;
        }
    }

    private void checkAndSetLimits(double xmin, double xmax, double ymin, double ymax) {
        if (this.xmin != xmin || this.xmax != xmax || this.ymin != ymin || this.ymax != ymax) {
            this.changed = true;
        }
        if (xmin == xmax) {
            this.xmin = xmin - 1.0;
            this.xmax = xmin + 1.0;
        } else {
            this.xmin = xmin;
            this.xmax = xmax;
        }
        if (ymin == ymax) {
            this.ymin = ymin - 1.0;
            this.ymax = ymin + 1.0;
        } else {
            this.ymin = ymin;
            this.ymax = ymax;
        }
        if (this.ensurezero) {
            this.ensureZeroX();
            this.ensureZeroY();
        }
    }

    public void ensureZero(boolean ensure) {
        this.ensurezero = ensure;
    }

    public void setPanel(MathPanel2D mathpanel2d) {
        this.mathpanel2d = mathpanel2d;
    }

    public String toString() {
        return "[xmin=" + this.xmin + ",xmax=" + this.xmax + " ymin=" + this.ymin + ",ymax=" + this.ymax + "]";
    }

    public int xToPixel(double x) {
        int xInt = this.edge + this.insets.left + (int)Math.round((x - this.xmin) / (this.xmax - this.xmin) * (double)(this.mathpanel2d.getWidth() - 2 * this.edge - this.insets.left - this.insets.right - 1));
        return xInt;
    }

    public int yToPixel(double y) {
        int yInt = this.edge + this.insets.top + (int)Math.round((this.ymax - y) / (this.ymax - this.ymin) * (double)(this.mathpanel2d.getHeight() - 2 * this.edge - this.insets.top - this.insets.bottom - 1));
        return yInt;
    }

    public Point project(Punkt2D a) {
        return new Point(this.xToPixel(a.x), this.yToPixel(a.y));
    }

    public Punkt2D projectdouble(Punkt2D a) {
        return new Punkt2D(this.xToPixel(a.x), this.yToPixel(a.y));
    }

    public CoordinateRect2D getLimits() {
        return new CoordinateRect2D(this.xmin, this.xmax, this.ymin, this.ymax);
    }

    public double getXRange() {
        return Math.abs(this.xmax - this.xmin);
    }

    public double getYRange() {
        return Math.abs(this.ymax - this.ymin);
    }

    public double getMinRange() {
        return Math.min(this.getYRange(), this.getXRange());
    }

    public int getArea() {
        if (this.ymin >= 0.0) {
            if (this.xmin >= 0.0) {
                return 1;
            }
            if (this.xmax <= 0.0) {
                return 0;
            }
            return 2;
        }
        if (this.ymax <= 0.0) {
            if (this.xmin >= 0.0) {
                return 4;
            }
            if (this.xmax <= 0.0) {
                return 3;
            }
            return 5;
        }
        if (this.xmax <= 0.0) {
            return 7;
        }
        if (this.xmin >= 0.0) {
            return 6;
        }
        return 8;
    }
}

