/*
 * Decompiled with CFR 0.152.
 */
package uibk.draw2d.axes2d;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.util.Vector;
import uibk.draw2d.axes2d.Axes2D;
import uibk.draw2d.axes2d.Axis;
import uibk.draw2d.axes2d.Tick;
import uibk.draw2d.base.Scene2D;
import uibk.geom.Punkt2D;

class YAxis
extends Axis {
    public YAxis(Axes2D axes) {
        super(axes);
    }

    @Override
    public void compute(Punkt2D start, Punkt2D end, Punkt2D axisIntersection, int tickAndLabelPos, Graphics2D g2, Scene2D coords2d) {
        if (this.style != 2) {
            Vector tickPositions = this.axes.computeTickPositions(start.y, end.y);
            if (tickPositions != null && tickPositions.size() > 0) {
                this.ticks = this.axes.createTicks(tickPositions, tickAndLabelPos, coords2d.getYPixelScale(), start.x);
            }
            if (this.ticks != null) {
                int i = 0;
                while (i < this.ticks.size()) {
                    ((Tick)this.ticks.elementAt(i)).compute(g2, coords2d);
                    ++i;
                }
            }
        }
        int startX = coords2d.xToPixel(start.x);
        int startY = coords2d.yToPixel(start.y);
        int endX = coords2d.xToPixel(end.x);
        int endY = coords2d.yToPixel(end.y);
        if (axisIntersection != null && Math.abs(start.y - axisIntersection.y) > Math.abs(end.y - axisIntersection.y)) {
            this.startPix.x = endX;
            this.startPix.y = endY;
            this.endPix.x = startX;
            this.endPix.y = startY;
            coords2d.requestSpaceBottom(this.endPix.y + this.arrowLength);
            if (this.axes.area == 8 || this.axes.area == 6 || this.axes.area == 7) {
                this.startPix.y -= this.arrowLength;
                coords2d.requestSpaceTop(this.startPix.y);
            }
        } else {
            this.startPix.x = startX;
            this.startPix.y = startY;
            this.endPix.x = endX;
            this.endPix.y = endY;
            coords2d.requestSpaceTop(this.endPix.y - this.arrowLength);
            if (this.axes.area == 8 || this.axes.area == 6 || this.axes.area == 7) {
                this.startPix.y += this.arrowLength;
                coords2d.requestSpaceBottom(this.startPix.y);
            }
        }
        FontMetrics metrics = g2.getFontMetrics();
        int height = metrics.getHeight();
        this.captionpos.x = this.endPix.x + 4;
        this.captionpos.y = this.endPix.y + height / 4;
        coords2d.requestSpaceRight(this.startPix.x + this.offsetWings);
        coords2d.requestSpaceLeft(this.startPix.x - this.offsetWings);
    }

    public void draw(Graphics2D g2, Scene2D coords2d) {
        g2.setColor(Color.black);
        Stroke oldStroke = g2.getStroke();
        g2.setStroke(new BasicStroke(1.5f));
        if (this.axes.style == 1) {
            if (this.startPix.y > this.endPix.y) {
                this.drawArrow(g2, this.endPix.x, this.endPix.y, 2);
            } else {
                this.drawArrow(g2, this.endPix.x, this.endPix.y, 3);
            }
            g2.drawLine(this.startPix.x, this.startPix.y, this.endPix.x, this.endPix.y);
        }
        g2.setStroke(oldStroke);
        if (this.ticks != null && this.style != 2) {
            boolean drawLabels = this.style == 1;
            int i = 0;
            while (i < this.ticks.size()) {
                ((Tick)this.ticks.elementAt(i)).draw(g2, coords2d, drawLabels);
                ++i;
            }
        }
        if (this.style == 1 && this.caption != null && !this.caption.equals("")) {
            g2.drawString(this.caption, this.captionpos.x, this.captionpos.y);
        }
    }
}

