/*
 * Decompiled with CFR 0.152.
 */
package uibk.draw2d.axes2d;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.util.Vector;
import uibk.draw2d.axes2d.Axes2D;
import uibk.draw2d.axes2d.Axis;
import uibk.draw2d.axes2d.Tick;
import uibk.draw2d.base.Scene2D;
import uibk.geom.Punkt2D;

class XAxis
extends Axis {
    public XAxis(Axes2D axes) {
        super(axes);
    }

    @Override
    public void compute(Punkt2D start, Punkt2D end, Punkt2D axisIntersection, int tickAndLabelPos, Graphics2D g2, Scene2D scene2d) {
        if (this.style != 2) {
            Vector tickPositions = this.axes.computeTickPositions(start.x, end.x);
            if (tickPositions != null && tickPositions.size() > 0) {
                this.ticks = this.axes.createTicks(tickPositions, tickAndLabelPos, scene2d.getXPixelScale(), start.y);
            }
            if (this.ticks != null) {
                int i = 0;
                while (i < this.ticks.size()) {
                    ((Tick)this.ticks.elementAt(i)).compute(g2, scene2d);
                    ++i;
                }
            }
        }
        int startX = scene2d.xToPixel(start.x);
        int startY = scene2d.yToPixel(start.y);
        int endX = scene2d.xToPixel(end.x);
        int endY = scene2d.yToPixel(end.y);
        if (axisIntersection != null && Math.abs(start.x - axisIntersection.x) > Math.abs(end.x - axisIntersection.x)) {
            this.startPix.x = endX;
            this.startPix.y = endY;
            this.endPix.x = startX;
            this.endPix.y = startY;
            scene2d.requestSpaceLeft(this.endPix.x - this.arrowLength);
            if (this.axes.area == 2 || this.axes.area == 5 || this.axes.area == 8) {
                this.startPix.x += this.arrowLength;
                scene2d.requestSpaceRight(this.startPix.x);
            }
        } else {
            this.startPix.x = startX;
            this.startPix.y = startY;
            this.endPix.x = endX;
            this.endPix.y = endY;
            scene2d.requestSpaceRight(this.endPix.x + this.arrowLength);
            if (this.axes.area == 2 || this.axes.area == 5 || this.axes.area == 8) {
                this.startPix.x -= this.arrowLength;
                scene2d.requestSpaceLeft(this.startPix.x);
            }
        }
        FontMetrics metrics = g2.getFontMetrics();
        int length = metrics.stringWidth(this.caption);
        int height = metrics.getHeight();
        this.captionpos.x = this.endPix.x - length / 2;
        this.captionpos.y = this.endPix.y - 4;
        this.captionpos.y = tickAndLabelPos == 3 ? this.endPix.y - 4 : this.endPix.y + 4 + height / 2;
        scene2d.requestSpaceTop(this.startPix.y - this.offsetWings);
        scene2d.requestSpaceBottom(this.startPix.y + this.offsetWings);
    }

    public void draw(Graphics2D g2, Scene2D coords2d) {
        g2.setColor(Color.black);
        Stroke oldStroke = g2.getStroke();
        g2.setStroke(new BasicStroke(1.5f));
        if (this.axes.style == 1) {
            if (this.startPix.x < this.endPix.x) {
                this.drawArrow(g2, this.endPix.x, this.endPix.y, 0);
            } else {
                this.drawArrow(g2, this.endPix.x, this.endPix.y, 1);
            }
            g2.drawLine(this.startPix.x, this.startPix.y, this.endPix.x, this.endPix.y);
        }
        g2.setStroke(oldStroke);
        if (this.ticks != null && this.style != 2) {
            boolean drawLabels = this.style == 1;
            int i = 0;
            while (i < this.ticks.size()) {
                ((Tick)this.ticks.elementAt(i)).draw(g2, coords2d, drawLabels);
                ++i;
            }
        }
        if (this.style == 1 && this.caption != null && !this.caption.equals("")) {
            g2.drawString(this.caption, this.captionpos.x, this.captionpos.y);
        }
    }
}

