/*
 * Decompiled with CFR 0.152.
 */
package uibk.draw2d.axes2d;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Stroke;
import java.awt.image.BufferedImage;
import java.util.Vector;
import uibk.draw2d.axes2d.Tick;
import uibk.draw2d.axes2d.XAxis;
import uibk.draw2d.axes2d.YAxis;
import uibk.draw2d.base.Drawable2D;
import uibk.geom.Punkt2D;
import uibk.lang.Options;
import uibk.lang.PrepaintComputable;
import uibk.text.Formatter;

public class Axes2D
extends Drawable2D
implements PrepaintComputable {
    int style = 1;
    public static final int STYLE_BOX = 0;
    public static final int STYLE_INTELLIGENT = 1;
    public static final int AXES_DRAW_ALWAYS = 0;
    public static final int AXES_DRAW_STRICT = 1;
    public static final int AXES_DRAW_NEVER = 2;
    public static final int AXES_STYLE_TICKS = 0;
    public static final int AXES_STYLE_TICKS_AND_LABELS = 1;
    public static final int AXES_STYLE_NOTICKS = 2;
    Formatter format = new Formatter();
    protected Font font;
    protected int area;
    private XAxis xaxis = new XAxis(this);
    private YAxis yaxis = new YAxis(this);
    private int visibilityXAxis;
    private int visibilityYAxis;
    private int numTicks;
    private Punkt2D pointAxesIntersect;

    public Axes2D() {
        this.setStyleXAxis(1);
        this.setStyleYAxis(1);
        this.numTicks = 11;
    }

    public void setAxesStyle(int style) {
        this.style = style;
    }

    public int getAxesStyle() {
        return this.style;
    }

    public void setVisibilityXAxis(int visibility) {
        this.visibilityXAxis = visibility;
    }

    public void setVisibilityYAxis(int visibility) {
        this.visibilityYAxis = visibility;
    }

    public void setStyleXAxis(int style) {
        this.xaxis.setStyle(style);
    }

    public void setStyleYAxis(int style) {
        this.yaxis.setStyle(style);
    }

    public void setNumTicks(int numTicks) {
        this.numTicks = numTicks;
    }

    private void colorEdge(Graphics2D g2) {
        g2.setColor(Options.COMPONENTSCOLOR);
        Insets insets = this.scene2d.getInsets();
        int edge = this.scene2d.getEdge();
        g2.fillRect(1, 1, insets.left + edge, this.panel.getHeight() - 1);
        g2.fillRect(1, 1, this.panel.getWidth() - 1, insets.top + edge);
        g2.fillRect(1, this.panel.getHeight() - insets.top - edge, this.panel.getWidth() - 1, insets.top + edge);
        g2.fillRect(this.panel.getWidth() - edge - insets.right, 1, this.panel.getWidth(), this.panel.getHeight() - 1);
        g2.setColor(Color.BLACK);
        g2.drawRect(0, 0, this.panel.getWidth() - 1, this.panel.getHeight() - 1);
    }

    @Override
    public void draw(BufferedImage framebuffer, Graphics2D g2) {
        if (this.style == 0) {
            this.colorEdge(g2);
        }
        if (this.xAxisVisible()) {
            this.xaxis.draw(g2, this.scene2d);
        }
        if (this.yAxisVisible()) {
            this.yaxis.draw(g2, this.scene2d);
        }
        if (this.style == 0) {
            g2.setColor(Color.black);
            Stroke oldStroke = g2.getStroke();
            g2.setStroke(new BasicStroke(1.5f));
            int xmin = this.scene2d.xToPixel(this.scene2d.getXmin());
            int xmax = this.scene2d.xToPixel(this.scene2d.getXmax());
            int ymin = this.scene2d.yToPixel(this.scene2d.getYmin());
            int ymax = this.scene2d.yToPixel(this.scene2d.getYmax());
            g2.drawLine(xmin, ymin, xmax, ymin);
            g2.drawLine(xmin, ymin, xmin, ymax);
            g2.drawLine(xmax, ymin, xmax, ymax);
            g2.drawLine(xmin, ymax, xmax, ymax);
            g2.setStroke(oldStroke);
        }
    }

    private boolean xAxisVisible() {
        return this.visibilityXAxis != 2 && (this.visibilityXAxis != 1 || this.pointAxesIntersect.y == 0.0);
    }

    private boolean yAxisVisible() {
        return this.visibilityYAxis != 2 && (this.visibilityYAxis != 1 || this.pointAxesIntersect.x == 0.0);
    }

    @Override
    public void prepaintcompute() {
        double xmax = this.scene2d.getXmax();
        double xmin = this.scene2d.getXmin();
        double ymax = this.scene2d.getYmax();
        double ymin = this.scene2d.getYmin();
        this.pointAxesIntersect = new Punkt2D();
        this.area = this.scene2d.getArea();
        Punkt2D pointXAxesStart = new Punkt2D();
        Punkt2D pointXAxesEnd = new Punkt2D();
        Punkt2D pointYAxesStart = new Punkt2D();
        Punkt2D pointYAxesEnd = new Punkt2D();
        int tickPosX = 0;
        int tickPosY = 0;
        if (this.style == 0) {
            this.area = 1;
        }
        switch (this.area) {
            case 1: {
                pointXAxesStart.x = xmin;
                pointXAxesStart.y = ymin;
                pointXAxesEnd.x = xmax;
                pointXAxesEnd.y = ymin;
                pointYAxesStart.x = xmin;
                pointYAxesStart.y = ymin;
                pointYAxesEnd.x = xmin;
                pointYAxesEnd.y = ymax;
                this.pointAxesIntersect.x = xmin;
                this.pointAxesIntersect.y = ymin;
                tickPosX = 3;
                tickPosY = 0;
                break;
            }
            case 6: {
                pointXAxesStart.x = xmin;
                pointXAxesStart.y = 0.0;
                pointXAxesEnd.x = xmax;
                pointXAxesEnd.y = 0.0;
                pointYAxesStart.x = xmin;
                pointYAxesStart.y = ymin;
                pointYAxesEnd.x = xmin;
                pointYAxesEnd.y = ymax;
                this.pointAxesIntersect.x = xmin;
                this.pointAxesIntersect.y = 0.0;
                tickPosX = 3;
                tickPosY = 0;
                break;
            }
            case 4: {
                pointXAxesStart.x = xmin;
                pointXAxesStart.y = ymax;
                pointXAxesEnd.x = xmax;
                pointXAxesEnd.y = ymax;
                pointYAxesStart.x = xmin;
                pointYAxesStart.y = ymin;
                pointYAxesEnd.x = xmin;
                pointYAxesEnd.y = ymax;
                this.pointAxesIntersect.x = xmin;
                this.pointAxesIntersect.y = ymax;
                tickPosX = 3;
                tickPosY = 0;
                break;
            }
            case 2: {
                pointXAxesStart.x = xmin;
                pointXAxesStart.y = ymin;
                pointXAxesEnd.x = xmax;
                pointXAxesEnd.y = ymin;
                pointYAxesStart.x = 0.0;
                pointYAxesStart.y = ymin;
                pointYAxesEnd.x = 0.0;
                pointYAxesEnd.y = ymax;
                this.pointAxesIntersect.x = 0.0;
                this.pointAxesIntersect.y = ymin;
                tickPosX = 3;
                tickPosY = 0;
                break;
            }
            case 8: {
                pointXAxesStart.x = xmin;
                pointXAxesStart.y = 0.0;
                pointXAxesEnd.x = xmax;
                pointXAxesEnd.y = 0.0;
                pointYAxesStart.x = 0.0;
                pointYAxesStart.y = ymin;
                pointYAxesEnd.x = 0.0;
                pointYAxesEnd.y = ymax;
                this.pointAxesIntersect.x = 0.0;
                this.pointAxesIntersect.y = 0.0;
                tickPosX = 3;
                tickPosY = 0;
                break;
            }
            case 7: {
                pointXAxesStart.x = xmin;
                pointXAxesStart.y = 0.0;
                pointXAxesEnd.x = xmax;
                pointXAxesEnd.y = 0.0;
                pointYAxesStart.x = xmax;
                pointYAxesStart.y = ymin;
                pointYAxesEnd.x = xmax;
                pointYAxesEnd.y = ymax;
                this.pointAxesIntersect.x = xmax;
                this.pointAxesIntersect.y = 0.0;
                tickPosX = 3;
                tickPosY = 1;
                break;
            }
            case 0: {
                pointXAxesStart.x = xmin;
                pointXAxesStart.y = ymin;
                pointXAxesEnd.x = xmax;
                pointXAxesEnd.y = ymin;
                pointYAxesStart.x = xmax;
                pointYAxesStart.y = ymin;
                pointYAxesEnd.x = xmax;
                pointYAxesEnd.y = ymax;
                this.pointAxesIntersect.x = xmax;
                this.pointAxesIntersect.y = ymin;
                tickPosX = 3;
                tickPosY = 1;
                break;
            }
            case 3: {
                pointXAxesStart.x = xmin;
                pointXAxesStart.y = ymax;
                pointXAxesEnd.x = xmax;
                pointXAxesEnd.y = ymax;
                pointYAxesStart.x = xmax;
                pointYAxesStart.y = ymin;
                pointYAxesEnd.x = xmax;
                pointYAxesEnd.y = ymax;
                this.pointAxesIntersect.x = xmax;
                this.pointAxesIntersect.y = ymax;
                tickPosX = 2;
                tickPosY = 1;
                break;
            }
            case 5: {
                pointXAxesStart.x = xmin;
                pointXAxesStart.y = ymax;
                pointXAxesEnd.x = xmax;
                pointXAxesEnd.y = ymax;
                pointYAxesStart.x = 0.0;
                pointYAxesStart.y = ymin;
                pointYAxesEnd.x = 0.0;
                pointYAxesEnd.y = ymax;
                this.pointAxesIntersect.x = 0.0;
                this.pointAxesIntersect.y = ymax;
                tickPosX = 2;
                tickPosY = 0;
                break;
            }
        }
        if (!this.xAxisVisible() || !this.yAxisVisible()) {
            this.pointAxesIntersect = null;
        }
        if (this.xAxisVisible()) {
            this.xaxis.compute(pointXAxesStart, pointXAxesEnd, this.pointAxesIntersect, tickPosX, (Graphics2D)this.panel.getGraphics(), this.scene2d);
        }
        if (this.yAxisVisible()) {
            this.yaxis.compute(pointYAxesStart, pointYAxesEnd, this.pointAxesIntersect, tickPosY, (Graphics2D)this.panel.getGraphics(), this.scene2d);
        }
    }

    protected Vector computeTickPositions(double min, double max) {
        Vector<TickPosition> tickPos = new Vector<TickPosition>();
        switch (this.style) {
            case 1: {
                if (max >= 0.0 && min <= 0.0 && this.area != 1) {
                    boolean bigTick;
                    tickPos.add(new TickPosition(0.0, true, 0));
                    double maximum = Math.abs(max) >= Math.abs(min) ? Math.abs(max) : Math.abs(min);
                    double step = Double.valueOf(this.format.roundtoleadingdec(Math.abs(maximum))) / (double)(this.numTicks - 1);
                    int i = 1;
                    double pos = step;
                    while (pos <= max + step / 2.0) {
                        bigTick = i % 5 == 0;
                        tickPos.add(new TickPosition(pos, bigTick, 0));
                        pos = step * (double)(++i);
                    }
                    pos = -step;
                    i = 1;
                    while (pos >= min - step / 2.0) {
                        bigTick = i % 5 == 0;
                        tickPos.add(new TickPosition(pos, bigTick, 0));
                        pos = -step * (double)(++i);
                    }
                } else {
                    int i = 1;
                    if (this.area == 2 || this.area == 1 || this.area == 0 || this.area == 6) {
                        tickPos.add(new TickPosition(min, true, 1));
                        double step = Double.valueOf(this.format.roundtoleadingdec(Math.abs(max - min))) / (double)(this.numTicks - 1);
                        double pos = min + step;
                        while (pos <= max) {
                            boolean bigTick = i % 5 == 0;
                            tickPos.add(new TickPosition(pos, bigTick, 0));
                            pos = min + step * (double)(++i);
                        }
                    } else {
                        double step = Double.valueOf(this.format.roundtoleadingdec(Math.abs(max - min))) / (double)(this.numTicks - 1);
                        tickPos.add(new TickPosition(max, true, 2));
                        double pos = max - step;
                        while (pos >= min) {
                            boolean bigTick = i % 5 == 0;
                            tickPos.add(new TickPosition(pos, bigTick, 0));
                            pos = max - step * (double)(++i);
                        }
                    }
                }
                if (tickPos.size() >= this.numTicks) break;
                tickPos.clear();
                tickPos.add(new TickPosition(min, true, 1));
                tickPos.add(new TickPosition(max, true, 2));
                break;
            }
            case 0: {
                tickPos.add(new TickPosition(min, true, 1));
                double step = (max - min) / (double)(this.numTicks - 1);
                double pos = min + step;
                int i = 1;
                while (pos < max) {
                    boolean bigTick = i % 5 == 0;
                    tickPos.add(new TickPosition(pos, bigTick, 0));
                    pos = min + step * (double)(++i);
                }
                tickPos.add(new TickPosition(max, true, 2));
                break;
            }
        }
        return tickPos;
    }

    protected Vector createTicks(Vector tickPositions, int tickDrawPos, double roundingDiff, double axisPos) {
        Vector<Tick> ticks = new Vector<Tick>();
        int i = 0;
        while (i < tickPositions.size()) {
            TickPosition t = (TickPosition)tickPositions.elementAt(i);
            double posX = tickDrawPos == 0 || tickDrawPos == 1 ? axisPos : t.position;
            double posY = tickDrawPos == 0 || tickDrawPos == 1 ? t.position : axisPos;
            Tick tick = null;
            if (t.bigTick) {
                boolean add = true;
                int movedir = 0;
                if (this.pointAxesIntersect != null) {
                    if (this.area == 8 && posY == this.pointAxesIntersect.y && posX == this.pointAxesIntersect.x) {
                        add = false;
                    }
                    if ((tickDrawPos == 0 || tickDrawPos == 1) && posY == this.pointAxesIntersect.y) {
                        movedir = this.moveLabel(tickDrawPos);
                    }
                    if ((tickDrawPos == 2 || tickDrawPos == 3) && posX == this.pointAxesIntersect.x) {
                        movedir = this.moveLabel(tickDrawPos);
                    }
                }
                if (add) {
                    String str = null;
                    switch (t.type) {
                        case 0: {
                            str = this.format.commonformat(t.position, roundingDiff);
                            break;
                        }
                        case 1: {
                            str = this.format.commonformat(t.position, roundingDiff);
                            break;
                        }
                        case 2: {
                            str = this.format.commonformat(t.position, roundingDiff);
                            break;
                        }
                    }
                    tick = new Tick(tickDrawPos, posX, posY, t.bigTick, str, movedir, this);
                }
            } else {
                tick = new Tick(tickDrawPos, posX, posY, t.bigTick, null, 0, this);
            }
            if (tick != null) {
                ticks.add(tick);
            }
            ++i;
        }
        return ticks;
    }

    private int moveLabel(int tickDrawPos) {
        if (this.pointAxesIntersect != null && this.area == 6 && tickDrawPos == 3) {
            return 3;
        }
        if (this.pointAxesIntersect != null && this.area == 4 && tickDrawPos == 3) {
            return 3;
        }
        if (this.pointAxesIntersect != null && this.area == 2 && tickDrawPos == 0) {
            return 1;
        }
        if (this.pointAxesIntersect != null && this.area == 5 && tickDrawPos == 0) {
            return 2;
        }
        if (this.pointAxesIntersect != null && this.area == 7 && tickDrawPos == 3) {
            return 4;
        }
        return 0;
    }

    public void setCaptionXAxis(String label) {
        this.xaxis.caption = label;
    }

    public void setCaptionYAxis(String label) {
        this.yaxis.caption = label;
    }

    private static class TickPosition {
        double position;
        boolean bigTick;
        static final int NORMAL = 0;
        static final int MIN = 1;
        static final int MAX = 2;
        int type;

        TickPosition(double position, boolean bigTick, int type) {
            this.position = position;
            this.bigTick = bigTick;
            this.type = type;
        }
    }
}

