/*
 * Decompiled with CFR 0.152.
 */
package jaba.math;

import Jama.Matrix;
import jaba.math.Complex;
import jaba.math.Function;
import jaba.math.Nullspace;
import jaba.math.Vektor;

public class MathUtil {
    private MathUtil() {
    }

    public static double max(double[] t) {
        double maximum = t[0];
        int i = 1;
        while (i < t.length) {
            if (t[i] > maximum) {
                maximum = t[i];
            }
            ++i;
        }
        return maximum;
    }

    public static double min(double[] t) {
        double minimum = t[0];
        int i = 1;
        while (i < t.length) {
            if (t[i] < minimum) {
                minimum = t[i];
            }
            ++i;
        }
        return minimum;
    }

    public static double norm1(double[] t) {
        double norm = 0.0;
        int i = 0;
        while (i < t.length) {
            norm += Math.abs(t[i]);
            ++i;
        }
        return norm;
    }

    public static int sign(double x) {
        if (x < 0.0) {
            return -1;
        }
        if (x > 0.0) {
            return 1;
        }
        return 0;
    }

    public static Complex getCriticalHopfEigenvalue(Complex[] eigenvals) {
        int pos = 0;
        double min = Double.MAX_VALUE;
        int i = 0;
        while (i < eigenvals.length) {
            if (eigenvals[i].imag != 0.0 && !(eigenvals[i].imag < 0.0) && Math.abs(eigenvals[i].real) + 1.0 / Math.abs(eigenvals[i].imag) < min) {
                pos = i;
                min = eigenvals[i].real;
            }
            ++i;
        }
        return eigenvals[pos];
    }

    public static Vektor[] getCriticalHopfEigenvector(Complex[] eigenvals, Vektor[] eigenvectsreal, Vektor[] eigenvectsimag) {
        int pos = 0;
        double min = Double.MAX_VALUE;
        int i = 0;
        while (i < eigenvals.length) {
            if (eigenvals[i].imag != 0.0 && !(eigenvals[i].imag < 0.0) && Math.abs(eigenvals[i].real) + 1.0 / Math.abs(eigenvals[i].imag) < min) {
                pos = i;
                min = eigenvals[i].real;
            }
            ++i;
        }
        Vektor criticalreal = new Vektor(eigenvectsreal[pos]);
        Vektor criticalimag = new Vektor(eigenvectsimag[pos]);
        double norm = 0.0;
        int i2 = 0;
        while (i2 < criticalreal.getLength()) {
            norm += criticalreal.get(i2) * criticalreal.get(i2) + criticalimag.get(i2) * criticalimag.get(i2);
            ++i2;
        }
        criticalreal.timesEquals(1.0 / Math.sqrt(norm));
        criticalimag.timesEquals(1.0 / Math.sqrt(norm));
        Vektor[] critical = new Vektor[]{criticalreal, criticalimag};
        return critical;
    }

    public static Vektor getTangent(Function f, Vektor start, boolean forward) {
        Matrix J = f.getJacobian(start);
        Vektor[] nullvectors = Nullspace.getNullSpace((Matrix)J, (int)0);
        int n = start.getLength();
        Vektor dir = new Vektor(n);
        int d = forward ? 1 : -1;
        Vektor v = nullvectors[0];
        double min = Double.MAX_VALUE;
        double max = Double.MIN_VALUE;
        int posmin = 0;
        int posmax = 0;
        int i = 0;
        while (i < n - 1) {
            if (v.get(i) <= min) {
                min = v.get(i);
                posmin = i;
            }
            if (v.get(i) >= max) {
                max = v.get(i);
                posmax = i;
            }
            ++i;
        }
        if (posmin != n - 1) {
            dir.set(n - 1, d);
        } else {
            dir.set(posmax, d);
        }
        return dir;
    }
}

