/*
 * Decompiled with CFR 0.152.
 */
package ds.swing;

import ds.lang.Options;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;
import uibk.draw3d.base.MathPanel3D;
import uibk.swing.ButtonNoFocus;

public class JPanelView3D
extends JPanel
implements ActionListener {
    ButtonGroup groupProjectionOpt = new ButtonGroup();
    JButton jButtonDefaultView;
    JComboBox jComboPlanes;
    JLabel jLabelDistance;
    JRadioButton optParallelProj;
    JRadioButton optPerspectiveProj;
    ButtonNoFocus jButtonNearer;
    ButtonNoFocus jButtonFarer;
    MathPanel3D mathpanel3d;
    protected String strtitle = "Projection";
    protected String strperspective = "Perspective";
    protected String strparallel = "Parallel projection";
    protected String strplane = "Plane of projection";
    protected String strplanexy = "xy-plane";
    protected String strplanexz = "xz-plane";
    protected String strplaneyz = "yz-plane";
    protected String strdistance = "Distance";
    protected String strdefault = "Default";

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (!enabled) {
            this.jButtonNearer.setEnabled(false);
            this.jButtonFarer.setEnabled(false);
        }
    }

    public JPanelView3D(MathPanel3D mathpanel3d) {
        this.mathpanel3d = mathpanel3d;
        this.initComponents();
    }

    public JPanelView3D(MathPanel3D mathpanel3d, String strplanexy, String strplanexz, String strplaneyz) {
        this.strplanexy = strplanexy;
        this.strplanexz = strplanexz;
        this.strplaneyz = strplaneyz;
        this.mathpanel3d = mathpanel3d;
        this.initComponents();
    }

    void initComponents() {
        this.jButtonDefaultView = new JButton(this.strdefault);
        this.optParallelProj = new JRadioButton(this.strparallel);
        this.optPerspectiveProj = new JRadioButton(this.strperspective);
        this.groupProjectionOpt.add(this.optParallelProj);
        this.groupProjectionOpt.add(this.optPerspectiveProj);
        this.optPerspectiveProj.setSelected(true);
        this.optPerspectiveProj.setActionCommand("perspective");
        this.optParallelProj.setActionCommand("parallel");
        this.optPerspectiveProj.addActionListener(this);
        this.optParallelProj.addActionListener(this);
        this.optParallelProj.setBackground(Options.componentsColor);
        this.optPerspectiveProj.setBackground(Options.componentsColor);
        this.setLayout(new GridBagLayout());
        this.setMaximumSize(new Dimension(2000, 280));
        this.setPreferredSize(new Dimension(300, 280));
        this.setBackground(Options.componentsColor);
        URL urlIconPlus = this.getClass().getResource("res/plus.gif");
        URL urlIconMinus = this.getClass().getResource("res/minus.gif");
        this.jButtonNearer = new ButtonNoFocus(new ImageIcon(urlIconPlus));
        this.jButtonFarer = new ButtonNoFocus(new ImageIcon(urlIconMinus));
        this.jButtonNearer.setActionCommand("nearer");
        this.jButtonFarer.setActionCommand("farer");
        this.jButtonDefaultView.setActionCommand("defaultview");
        this.jButtonDefaultView.addActionListener(this);
        this.jButtonNearer.setBorder(null);
        this.jButtonFarer.setBorder(null);
        this.jButtonFarer.addActionListener(this);
        this.jButtonNearer.addActionListener(this);
        this.jButtonFarer.setBackground(Options.componentsColor);
        this.jButtonNearer.setBackground(Options.componentsColor);
        this.jButtonDefaultView.setBackground(Options.componentsColor);
        TitledBorder border = BorderFactory.createTitledBorder(this.strtitle);
        this.setBorder(border);
        this.jLabelDistance = new JLabel(this.strdistance);
        this.jComboPlanes = new JComboBox<String>(new String[]{this.strplanexy, this.strplanexz, this.strplaneyz});
        this.jComboPlanes.addActionListener(this);
        this.jComboPlanes.setActionCommand("planes");
        this.jComboPlanes.setPreferredSize(new Dimension(80, 20));
        this.jComboPlanes.setMaximumSize(new Dimension(80, 20));
        this.jComboPlanes.setMinimumSize(new Dimension(80, 20));
        this.add((Component)this.optPerspectiveProj, new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.jLabelDistance, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 30, 0, 0), 0, 0));
        this.add((Component)this.jButtonFarer, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
        this.add((Component)this.jButtonNearer, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
        this.add((Component)this.optParallelProj, new GridBagConstraints(0, 2, 3, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)new JLabel(this.strplane), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(20, 0, 0, 0), 0, 0));
        this.add((Component)this.jComboPlanes, new GridBagConstraints(1, 3, 2, 1, 0.0, 0.0, 17, 0, new Insets(20, 5, 0, 0), 0, 0));
        this.add((Component)this.jButtonDefaultView, new GridBagConstraints(0, 5, 3, 1, 0.0, 0.0, 10, 0, new Insets(50, 0, 0, 0), 0, 0));
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        double dist;
        if (ev.getActionCommand().equals("nearer")) {
            dist = this.mathpanel3d.getScene3D().getDistance();
            this.mathpanel3d.getScene3D().setDistance(dist - 0.1);
            this.mathpanel3d.repaint();
        }
        if (ev.getActionCommand().equals("farer")) {
            dist = this.mathpanel3d.getScene3D().getDistance();
            this.mathpanel3d.getScene3D().setDistance(dist + 0.1);
            this.mathpanel3d.repaint();
        }
        if (ev.getActionCommand().equals("planes")) {
            JComboBox cb = (JComboBox)ev.getSource();
            String strplane = (String)cb.getSelectedItem();
            if (strplane.equals(this.strplanexy)) {
                this.mathpanel3d.getScene3D().projectXYPlane();
            }
            if (strplane.equals(this.strplanexz)) {
                this.mathpanel3d.getScene3D().projectXZPlane();
            }
            if (strplane.equals(this.strplaneyz)) {
                this.mathpanel3d.getScene3D().projectYZPlane();
            }
            this.mathpanel3d.repaint();
        }
        if (ev.getActionCommand().equals("defaultview")) {
            this.mathpanel3d.getScene3D().defaultview();
            this.jButtonFarer.setEnabled(true);
            this.jButtonNearer.setEnabled(true);
            this.optPerspectiveProj.setSelected(true);
            this.mathpanel3d.repaint();
        }
        if (ev.getActionCommand().equals("perspective")) {
            this.mathpanel3d.getScene3D().setProjectionType(0);
            this.jButtonFarer.setEnabled(true);
            this.jButtonNearer.setEnabled(true);
            this.jLabelDistance.setForeground(Color.black);
            this.mathpanel3d.repaint();
        }
        if (ev.getActionCommand().equals("parallel")) {
            this.mathpanel3d.getScene3D().setProjectionType(1);
            this.jButtonFarer.setEnabled(false);
            this.jButtonNearer.setEnabled(false);
            this.jLabelDistance.setForeground(Color.gray);
            this.mathpanel3d.repaint();
        }
    }
}

