/*
 * Decompiled with CFR 0.152.
 */
package ds.swing;

import ds.lang.Options;
import ds.parsing.UtilParser;
import jaba.math.ODESolver;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class JPanelODESolverOptions
extends JPanel
implements ActionListener {
    JTextField jTxtEps;
    JTextField jTxtH;
    JTextField jTxtMaxIterations;
    JCheckBox jCheckDenseOutput;
    JCheckBox jCheckStepControl;
    ODESolver odesolver;
    JLabel report;
    private int minsteps = 1;
    private int maxsteps = 50000;

    public JPanelODESolverOptions(JLabel report, ODESolver odesolver) {
        this.report = report;
        this.odesolver = odesolver;
        this.initComponents();
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getActionCommand().equals("applychanges")) {
            int maxiter = 0;
            try {
                maxiter = Integer.parseInt(this.jTxtMaxIterations.getText());
            }
            catch (NumberFormatException e) {
                this.report.setText("<html><font color=red>Entered max. number of steps is not a natural number<font>");
                return;
            }
            if (maxiter < this.minsteps || maxiter > this.maxsteps) {
                this.report.setText("<html><font color=red>Entered max. number of steps must be between " + this.minsteps + " and " + this.maxsteps + "+<font>");
                return;
            }
            this.odesolver.enableDenseOutput(this.jCheckDenseOutput.isSelected());
            this.odesolver.enabelStepSizeControl(this.jCheckStepControl.isSelected());
            if (this.jCheckStepControl.isSelected()) {
                double eps = 0.0;
                try {
                    eps = UtilParser.parseConstantExpr(this.jTxtEps.getText());
                }
                catch (Exception ex) {
                    this.report.setText("<html><font color=red>Entered accuracy is not a positive real number<font>");
                    return;
                }
                if (eps <= 0.0) {
                    this.report.setText("<html><font color=red>Entered accuracy is not a positive real number<font>");
                    return;
                }
                this.odesolver.setTOL(eps);
            }
            double h = 0.0;
            try {
                h = UtilParser.parseConstantExpr(this.jTxtH.getText());
            }
            catch (Exception ex) {
                this.report.setText("<html><font color=red>Entered stepsize is not a positive real number<font>");
                return;
            }
            if (h <= 0.0) {
                this.report.setText("<html><font color=red>Entered stepsize is not a positive real number<font>");
                return;
            }
            this.odesolver.setInitialStepsize(h);
            this.odesolver.setMaxSteps(maxiter);
            this.report.setText("<html><font color=green>Options set<font>");
        }
        if (event.getActionCommand().equals("checkstep")) {
            this.jTxtEps.setEnabled(this.jCheckStepControl.isSelected());
        }
    }

    void initGeneralPanel() {
        JPanel general = new JPanel();
        general.setBackground(Options.componentsColor);
        TitledBorder border = BorderFactory.createTitledBorder("General options");
        general.setBorder(border);
        general.setLayout(new GridBagLayout());
        this.jTxtMaxIterations = new JTextField(String.valueOf(this.odesolver.getMaxSteps()));
        this.jTxtMaxIterations.setPreferredSize(new Dimension(80, 20));
        this.jTxtMaxIterations.setMaximumSize(new Dimension(80, 20));
        this.jTxtMaxIterations.setMinimumSize(new Dimension(80, 20));
        this.jCheckDenseOutput = new JCheckBox("Dense-Output");
        this.jCheckDenseOutput.setSelected(this.odesolver.isDenseOutputEnabled());
        this.jCheckDenseOutput.setBackground(Options.componentsColor);
        general.add((Component)new JLabel("Max. steps:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 0, 0), 0, 0));
        general.add((Component)this.jTxtMaxIterations, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        general.add((Component)this.jCheckDenseOutput, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.add(general);
    }

    void initStepsizePanel() {
        JPanel stepsize = new JPanel();
        stepsize.setBackground(Options.componentsColor);
        TitledBorder border = BorderFactory.createTitledBorder("Step size options");
        stepsize.setBorder(border);
        stepsize.setLayout(new GridBagLayout());
        this.jCheckStepControl = new JCheckBox("step-size control");
        this.jCheckStepControl.setSelected(this.odesolver.isStepSizeControlEnabled());
        this.jCheckStepControl.setBackground(Options.componentsColor);
        this.jCheckStepControl.setActionCommand("checkstep");
        this.jCheckStepControl.addActionListener(this);
        this.jTxtEps = new JTextField(String.valueOf(this.odesolver.getTOL()));
        this.jTxtEps.setPreferredSize(new Dimension(80, 20));
        this.jTxtEps.setMaximumSize(new Dimension(80, 20));
        this.jTxtEps.setMinimumSize(new Dimension(80, 20));
        this.jTxtH = new JTextField(String.valueOf(this.odesolver.getInitialStepsize()));
        this.jTxtH.setPreferredSize(new Dimension(80, 20));
        this.jTxtH.setMaximumSize(new Dimension(80, 20));
        this.jTxtH.setMinimumSize(new Dimension(80, 20));
        stepsize.add((Component)new JLabel("(Initial) stepsize:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        stepsize.add((Component)this.jTxtH, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        stepsize.add((Component)this.jCheckStepControl, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        stepsize.add((Component)new JLabel("Local error"), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 20, 0, 0), 0, 0));
        stepsize.add((Component)this.jTxtEps, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.add(stepsize);
    }

    void initApplyButton() {
        JPanel panel = new JPanel();
        panel.setBackground(Options.componentsColor);
        JButton jButtonApply = new JButton(" set ");
        jButtonApply.setBackground(Options.componentsColor);
        jButtonApply.setActionCommand("applychanges");
        jButtonApply.addActionListener(this);
        panel.add(jButtonApply);
        this.setBackground(Options.componentsColor);
        this.add(panel);
    }

    void initComponents() {
        this.setLayout(new BoxLayout(this, 1));
        this.initGeneralPanel();
        this.initStepsizePanel();
        this.initApplyButton();
    }
}

