/*
 * Decompiled with CFR 0.152.
 */
package bacon.parser;

class Token {
    public static final int TT_ERROR = -1;
    public static final int TT_EOF = -2;
    public static final int TT_NUMBER = -3;
    public static final int TT_WORD = -4;
    public static final int TT_LE = -5;
    public static final int TT_NE = -6;
    public static final int TT_GE = -7;
    public int ttype;
    public String sval;
    public double nval;
    public int location;
    public int leadingWhitespace;
    public int trailingWhitespace;

    public Token(int ttype, double nval, String input, int start, int end) {
        this.ttype = ttype;
        this.sval = input.substring(start, end);
        this.nval = nval;
        this.location = start;
        int count = 0;
        int i = start - 1;
        while (i >= 0) {
            if (!Character.isWhitespace(input.charAt(i))) break;
            ++count;
            --i;
        }
        this.leadingWhitespace = count;
        count = 0;
        i = end;
        while (i < input.length()) {
            if (!Character.isWhitespace(input.charAt(i))) break;
            ++count;
            ++i;
        }
        this.trailingWhitespace = count;
    }

    Token(int ttype, double nval, String sval, Token token) {
        this.ttype = ttype;
        this.sval = sval;
        this.nval = nval;
        this.location = token.location;
        this.leadingWhitespace = token.leadingWhitespace;
        this.trailingWhitespace = token.trailingWhitespace;
    }
}

