/*
 * Decompiled with CFR 0.152.
 */
package bacon.parser;

import bacon.parser.Token;
import bacon.parser.Variable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

class Scanner {
    private String s;
    private String operatorChars;
    private Hashtable variables;
    Vector tokens = new Vector();
    int index = -1;

    public Scanner(String string, String operatorChars, Hashtable variables) {
        this.s = string;
        this.variables = variables;
        this.operatorChars = String.valueOf(operatorChars) + "()";
        int i = 0;
        while ((i = this.scanToken(i)) < this.s.length()) {
        }
        this.addAsterisk();
    }

    private boolean isVariable(Token t) {
        boolean isVar = false;
        if (this.variables.size() > 0) {
            String var = null;
            Enumeration e = this.variables.elements();
            while (e.hasMoreElements()) {
                var = ((Variable)e.nextElement()).toString();
                if (!t.sval.equals(var)) continue;
                isVar = true;
            }
        }
        return isVar;
    }

    private void addAsterisk() {
        int i = 0;
        while (i < this.tokens.size() - 1) {
            Token tokenleft = (Token)this.tokens.elementAt(i);
            Token tokenright = (Token)this.tokens.elementAt(i + 1);
            if (tokenleft.ttype == -3 && (tokenright.ttype == 40 || tokenright.ttype == -4)) {
                this.tokens.add(i + 1, new Token(42, 0.0, "*", 0, 1));
            }
            if (tokenleft.ttype == 41 && (tokenright.ttype == 40 || tokenright.ttype == -4 || tokenright.ttype == -3)) {
                this.tokens.add(i + 1, new Token(42, 0.0, "*", 0, 1));
            }
            if (this.isVariable(tokenleft) && tokenright.ttype == 40) {
                this.tokens.add(i + 1, new Token(42, 0.0, "*", 0, 1));
            }
            ++i;
        }
    }

    public String getInput() {
        return this.s;
    }

    public String getOperatorChars() {
        return this.operatorChars;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        int whitespace = 0;
        int i = 0;
        while (i < this.tokens.size()) {
            int spaces;
            Token t = (Token)this.tokens.elementAt(i);
            int n = spaces = whitespace != 0 ? whitespace : t.leadingWhitespace;
            if (i == 0) {
                spaces = 0;
            } else if (spaces == 0 && !this.joinable((Token)this.tokens.elementAt(i - 1), t)) {
                spaces = 1;
            }
            int j = spaces;
            while (j > 0) {
                sb.append(" ");
                --j;
            }
            sb.append(t.sval);
            whitespace = t.trailingWhitespace;
            ++i;
        }
        return sb.toString();
    }

    private boolean joinable(Token s, Token t) {
        return !this.isAlphanumeric(s) || !this.isAlphanumeric(t);
    }

    private boolean isAlphanumeric(Token t) {
        return t.ttype == -4 || t.ttype == -3;
    }

    public boolean isEmpty() {
        return this.tokens.size() == 0;
    }

    public boolean atStart() {
        return this.index <= 0;
    }

    public boolean atEnd() {
        return this.tokens.size() <= this.index;
    }

    public Token nextToken() {
        ++this.index;
        return this.getCurrentToken();
    }

    public Token getCurrentToken() {
        if (this.atEnd()) {
            return new Token(-2, 0.0, this.s, this.s.length(), this.s.length());
        }
        return (Token)this.tokens.elementAt(this.index);
    }

    private int scanToken(int i) {
        while (i < this.s.length() && Character.isWhitespace(this.s.charAt(i))) {
            ++i;
        }
        if (i == this.s.length()) {
            return i;
        }
        if (this.operatorChars.indexOf(this.s.charAt(i)) >= 0) {
            if (i + 1 < this.s.length()) {
                String pair = this.s.substring(i, i + 2);
                int ttype = 0;
                if (pair.equals("<=")) {
                    ttype = -5;
                } else if (pair.equals(">=")) {
                    ttype = -7;
                } else if (pair.equals("<>")) {
                    ttype = -6;
                }
                if (ttype != 0) {
                    this.tokens.addElement(new Token(ttype, 0.0, this.s, i, i + 2));
                    return i + 2;
                }
            }
            this.tokens.addElement(new Token(this.s.charAt(i), 0.0, this.s, i, i + 1));
            return i + 1;
        }
        if (Character.isLetter(this.s.charAt(i))) {
            return this.scanSymbol(i);
        }
        if (Character.isDigit(this.s.charAt(i)) || '.' == this.s.charAt(i)) {
            return this.scanNumber(i);
        }
        this.tokens.addElement(this.makeErrorToken(i, i + 1));
        return i + 1;
    }

    private int scanSymbol(int i) {
        if (this.variables.size() > 0) {
            Variable var = null;
            Enumeration e = this.variables.elements();
            while (e.hasMoreElements()) {
                var = (Variable)e.nextElement();
                String v = var.toString();
                if (i + v.length() > this.s.length() || !this.s.substring(i, i + v.length()).equals(v)) continue;
                boolean addToken = true;
                int k = 0;
                while (k < this.tokens.size()) {
                    if (((Token)this.tokens.elementAt((int)k)).sval.equals(this.s)) {
                        addToken = false;
                    }
                    ++k;
                }
                if (i + v.length() < this.s.length() && (Character.isLetter(this.s.charAt(i + v.length())) || Character.isDigit(this.s.charAt(i + v.length())))) {
                    addToken = false;
                }
                if (!addToken) continue;
                this.tokens.addElement(new Token(-4, 0.0, this.s, i, i + v.length()));
                return i + v.length();
            }
        }
        int from = i;
        while (i < this.s.length() && (Character.isLetter(this.s.charAt(i)) || Character.isDigit(this.s.charAt(i)))) {
            ++i;
        }
        this.tokens.addElement(new Token(-4, 0.0, this.s, from, i));
        return i;
    }

    private int scanNumber(int i) {
        double nval;
        int from = i;
        while (i < this.s.length()) {
            if ('.' != this.s.charAt(i) && !Character.isDigit(this.s.charAt(i)) && this.s.charAt(i) != 'E' && !this.s.substring(i - 1, i + 1).equals("E-")) break;
            ++i;
        }
        String text = this.s.substring(from, i);
        try {
            nval = Double.valueOf(text);
        }
        catch (NumberFormatException nfe) {
            this.tokens.addElement(this.makeErrorToken(from, i));
            return i;
        }
        this.tokens.addElement(new Token(-3, nval, this.s, from, i));
        return i;
    }

    private Token makeErrorToken(int from, int i) {
        return new Token(-1, 0.0, this.s, from, i);
    }
}

