/*
 * Decompiled with CFR 0.152.
 */
package bacon.parser;

import bacon.parser.Expr;
import bacon.parser.Scanner;
import bacon.parser.SyntaxException;
import bacon.parser.Token;
import bacon.parser.Variable;
import java.util.Hashtable;
import java.util.Vector;

public class Parser {
    private Hashtable variables = new Hashtable();
    Scanner tokens = null;
    private Token token = null;
    private static final String[] procs1 = new String[]{"abs", "acos", "asin", "atan", "ceil", "cos", "exp", "floor", "log", "round", "sin", "sqrt", "tan"};
    private static final int[] rators1 = new int[]{100, 101, 102, 103, 104, 105, 106, 107, 108, 110, 111, 112, 113};
    private static final String[] procs2 = new String[]{"atan2", "max", "min"};
    private static final int[] rators2 = new int[]{5, 6, 7};

    public Parser() {
        Variable pi = new Variable("pi");
        pi.setValue(Math.PI);
        this.addVariable(pi);
    }

    public synchronized void addVariable(Variable var) {
        Variable result = (Variable)this.variables.get(var.name);
        if (result == null) {
            this.variables.put(var.name, var);
        }
    }

    public Expr parseString(String input) throws SyntaxException {
        String operatorChars = "*/+-^<>=,";
        this.tokens = new Scanner(input, operatorChars, this.variables);
        return this.reparse();
    }

    private Expr reparse() throws SyntaxException {
        this.tokens.index = -1;
        this.nextToken();
        Expr expr = this.parseExpr(0);
        if (this.token.ttype != -2) {
            throw this.error("Incomplete expression", 0, null);
        }
        return expr;
    }

    private void nextToken() {
        this.token = this.tokens.nextToken();
    }

    private Expr parseExpr(int precedence) throws SyntaxException {
        Expr expr = this.parseFactor();
        block13: while (true) {
            int rator;
            int r;
            int l;
            switch (this.token.ttype) {
                case 60: {
                    l = 20;
                    r = 21;
                    rator = 8;
                    break;
                }
                case -5: {
                    l = 20;
                    r = 21;
                    rator = 9;
                    break;
                }
                case 61: {
                    l = 20;
                    r = 21;
                    rator = 10;
                    break;
                }
                case -6: {
                    l = 20;
                    r = 21;
                    rator = 11;
                    break;
                }
                case -7: {
                    l = 20;
                    r = 21;
                    rator = 12;
                    break;
                }
                case 62: {
                    l = 20;
                    r = 21;
                    rator = 13;
                    break;
                }
                case 43: {
                    l = 30;
                    r = 31;
                    rator = 0;
                    break;
                }
                case 45: {
                    l = 30;
                    r = 31;
                    rator = 1;
                    break;
                }
                case 47: {
                    l = 40;
                    r = 41;
                    rator = 3;
                    break;
                }
                case 42: {
                    l = 40;
                    r = 41;
                    rator = 2;
                    break;
                }
                case 94: {
                    l = 50;
                    r = 50;
                    rator = 4;
                    break;
                }
                default: {
                    if (this.token.ttype == -4 && this.token.sval.equals("and")) {
                        l = 5;
                        r = 6;
                        rator = 14;
                        break;
                    }
                    if (this.token.ttype != -4 || !this.token.sval.equals("or")) break block13;
                    l = 10;
                    r = 11;
                    rator = 15;
                }
            }
            if (l < precedence) break;
            this.nextToken();
            expr = Expr.makeApp2(rator, expr, this.parseExpr(r));
        }
        return expr;
    }

    private Expr parseFactor() throws SyntaxException {
        switch (this.token.ttype) {
            case -3: {
                Expr lit = Expr.makeLiteral(this.token.nval);
                this.nextToken();
                return lit;
            }
            case -4: {
                int i = 0;
                while (i < procs1.length) {
                    if (procs1[i].equals(this.token.sval)) {
                        this.nextToken();
                        this.expect(40);
                        Expr rand = this.parseExpr(0);
                        this.expect(41);
                        return Expr.makeApp1(rators1[i], rand);
                    }
                    ++i;
                }
                i = 0;
                while (i < procs2.length) {
                    if (procs2[i].equals(this.token.sval)) {
                        this.nextToken();
                        this.expect(40);
                        Expr rand1 = this.parseExpr(0);
                        this.expect(44);
                        Expr rand2 = this.parseExpr(0);
                        this.expect(41);
                        return Expr.makeApp2(rators2[i], rand1, rand2);
                    }
                    ++i;
                }
                if (this.token.sval.equals("if")) {
                    this.nextToken();
                    this.expect(40);
                    Expr test = this.parseExpr(0);
                    this.expect(44);
                    Expr consequent = this.parseExpr(0);
                    this.expect(44);
                    Expr alternative = this.parseExpr(0);
                    this.expect(41);
                    return Expr.makeIfThenElse(test, consequent, alternative);
                }
                Expr var = (Expr)this.variables.get(this.token.sval);
                if (this.variables == null || this.variables.get(this.token.sval) == null) {
                    throw this.error("Unknown variable: " + this.token.sval, 4, null);
                }
                this.nextToken();
                return var;
            }
            case 40: {
                this.nextToken();
                Expr enclosed = this.parseExpr(0);
                this.expect(41);
                return enclosed;
            }
            case 45: {
                this.nextToken();
                return Expr.makeApp1(109, this.parseExpr(35));
            }
            case -2: {
                throw this.error("Factor expected", 2, null);
            }
        }
        throw this.error("Factor expected", 1, null);
    }

    private SyntaxException error(String complaint, int reason, String expected) {
        return new SyntaxException(complaint, this, reason, expected);
    }

    private void expect(int ttype) throws SyntaxException {
        if (this.token.ttype != ttype) {
            throw this.error("'" + (char)ttype + "' expected", 3, "" + (char)ttype);
        }
        this.nextToken();
    }

    boolean tryCorrections() {
        return this.tryInsertions() || this.tryDeletions() || this.trySubstitutions();
    }

    private boolean tryInsertions() {
        Vector v = this.tokens.tokens;
        int i = this.tokens.index;
        while (i >= 0) {
            Token t;
            if (i < v.size()) {
                t = (Token)v.elementAt(i);
            } else {
                String s = this.tokens.getInput();
                t = new Token(-2, 0.0, s, s.length(), s.length());
            }
            Token[] candidates = this.possibleInsertions(t);
            int j = 0;
            while (j < candidates.length) {
                v.insertElementAt(candidates[j], i);
                try {
                    this.reparse();
                    return true;
                }
                catch (SyntaxException se) {
                    v.removeElementAt(i);
                    ++j;
                }
            }
            --i;
        }
        return false;
    }

    private boolean tryDeletions() {
        Vector v = this.tokens.tokens;
        int i = this.tokens.index;
        while (i >= 0) {
            if (v.size() > i) {
                Object t = v.elementAt(i);
                v.removeElementAt(i);
                try {
                    this.reparse();
                    return true;
                }
                catch (SyntaxException se) {
                    v.insertElementAt(t, i);
                }
            }
            --i;
        }
        return false;
    }

    private boolean trySubstitutions() {
        Vector v = this.tokens.tokens;
        int i = this.tokens.index;
        while (i >= 0) {
            if (v.size() > i) {
                Token t = (Token)v.elementAt(i);
                Token[] candidates = this.possibleSubstitutions(t);
                int j = 0;
                while (j < candidates.length) {
                    v.setElementAt(candidates[j], i);
                    try {
                        this.reparse();
                        return true;
                    }
                    catch (SyntaxException syntaxException) {
                        ++j;
                    }
                }
                v.setElementAt(t, i);
            }
            --i;
        }
        return false;
    }

    private Token[] possibleInsertions(Token t) {
        String ops = this.tokens.getOperatorChars();
        Token[] ts = new Token[ops.length() + 6 + procs1.length + procs2.length];
        int i = 0;
        Token one = new Token(-3, 1.0, "1", t);
        ts[i++] = one;
        int j = 0;
        while (j < ops.length()) {
            ts[i++] = new Token(ops.charAt(j), 0.0, "" + ops.charAt(j), t);
            ++j;
        }
        ts[i++] = new Token(-4, 0.0, "x", t);
        int k = 0;
        while (k < procs1.length) {
            ts[i++] = new Token(-4, 0.0, procs1[k], t);
            ++k;
        }
        int m = 0;
        while (m < procs2.length) {
            ts[i++] = new Token(-4, 0.0, procs2[m], t);
            ++m;
        }
        ts[i++] = new Token(-5, 0.0, "<=", t);
        ts[i++] = new Token(-6, 0.0, "<>", t);
        ts[i++] = new Token(-7, 0.0, ">=", t);
        ts[i++] = new Token(-4, 0.0, "if", t);
        return ts;
    }

    public void clearVariables() {
        if (this.variables != null) {
            this.variables.clear();
        }
        Variable pi = new Variable("pi");
        pi.setValue(Math.PI);
        this.addVariable(pi);
    }

    private Token[] possibleSubstitutions(Token t) {
        return this.possibleInsertions(t);
    }
}

