set term windows enhanced size 1200,900
set encoding iso_8859_1
#
#x- and y-ranges for plotting
#
xmin=0
xmax=320
ymin=118.48
ymax=118.52
#
#Increments for the labels on the x- and y-axis
#
xincr=50
yincr=0.01
deltax=xmax-xmin
deltay=ymax-ymin
#
#Dimensions of the lengths of the axes in "cm" according to the size 1200,900
#Used for positioning of the numerical values of the fit parameters
#
width=26.5
length=17.5
xunit=deltax/width
yunit=deltay/length
#
#Name of the input file
#
filename="Gypsum_beta.dat"
#
#Column no. of the temperature data
#
nt=1
#
#Column no. of the relevant angle
#
np=2
#
#Column no. of the standard uncertainty of the relevant angle
#
nsu=3
set xrange [xmin:xmax]
set yrange [ymin:ymax]
set format y "%6.3f"
set xtics out nomirror scale 2 xmin,xincr,xmax
set ytics out nomirror scale 2 ymin,yincr,ymax
set mxtics 4
set mytics 2
set xtics font "Calibri,17"
set ytics font "Calibri,17"
#
#Title of the plot
#
set title 'Gypsum: Schofield, Knight and Stretton (1996) Am. Mineral. 81, 847' 
set title font "Calibri,20"
set xlabel font "Calibri,18" 
set ylabel font "Calibri,18" offset -4.0
set key font "Calibri,20"
set key on
set key right bottom
set key spacing 2.0
#
#Temperature unit C or K
#Remark: degree sign = \260
#
tu=" [K]"
set xlabel "Temperature".tu
#
#Relevant lattice parameter symbol a,b or c
#
lap=" beta "
set ylabel "Angle".lap."[\260]"
#
# Plot symbols
# 1:+,2:x,3:*,4:square,6:circle,8:rhomb,10:triangle
psym=4
set samples 100000
f(x)=beta_0+A*cos(B*x)
#
#Fit parameters
#
beta_0=118.50
A=0.01
B=0.015
#
#Fitting
#
fit f(x) filename u nt:np:nsu via beta_0,A,B
set label 1 sprintf('{/Symbol b}_0=%6.3f',beta_0) at xmin+xunit,ymax-yunit font "calibri, 17"
set label 2 sprintf('A=%5.4e',A) at xmin+xunit*6,ymax-yunit font "calibri, 17"
set label 3 sprintf('B=%5.4e',B) at xmin+xunit*11,ymax-yunit font "calibri, 17"
chisq = (FIT_STDFIT)**2	
set label 7 sprintf("{/Symbol c}^2 = %5.4f", chisq) at xmin+xunit*16,ymax-yunit font "calibri, 17"
plot filename u nt:np:nsu with yerrorbars pt psym ps 1 title 'Exp. data ', f(x) lc 3 title '{/symbol b}_0+A\327cos(B\327T)'