set term windows enhanced size 1200,900
set encoding iso_8859_1
#
#x- and y-ranges for plotting
#
xmin=0
xmax=1225
ymin=10.28
ymax=10.38
#
#Increments for the labels on the x- and y-axis
#
xincr=100
yincr=0.02
deltax=xmax-xmin
deltay=ymax-ymin
#
#Dimensions of the lengths of the axes in "cm" according to the size 1200,900
#Used for positioning of the numerical values of the fit parameters
#
width=26.5
length=17.5
xunit=deltax/width
yunit=deltay/length
#
#Name of the input file
#
filename="Li2B4O7_latt.dat"
#
#Column no. of the temperature data
#
nt=1
#
#Column no. of the relevant lattice parameter
#
np=4
#
#Column no. of the standard uncertainty of the relevant lattice parameter
#
nsu=5
set xrange [xmin:xmax]
set yrange [ymin:ymax]
set format y "%6.3f"
set xtics out nomirror scale 2 xmin,xincr,xmax
set ytics out nomirror scale 2 ymin,yincr,ymax
set mxtics 4
set mytics 2
set xtics font "Calibri,17"
set ytics font "Calibri,17"
set xlabel font "Calibri,18"
set ylabel font "Calibri,18" offset -4.0
#
#Title of the plot
#
set title "Li_2B_4O_7: Senyshyn et al. (2012) J. Phys. D 45, 175305" 
set title font "Calibri,20"
set key font "Calibri,20"
set key on
set key right bottom
set key spacing 2.0
#
#Temperature unit C or K
#Remark: degree sign = \260
#
tu=" [K]"
set xlabel "Temperature".tu
#
#Relevant lattice parameter symbol a,b or c
#
lap=" c "
set ylabel "Lattice parameter".lap."[\305]"
#
# Plot symbols
# 1:+,2:x,3:*,4:square,6:circle,8:rhomb,10:triangle
psym=4
set samples 100000
pi=3.14159265359
! Parametrisation of the Debye function according to Masyukov & Dmitriev
C1=-0.07713
C2=0.02433
C3=0.30548
C4=0.06513
C5=0.03487
C6=-0.00324
d(x)=x*(1+C1*(TD/x)+C2*(TD/x)**2)/(1+C3*(TD/x)+C4*(TD/x)**2+C5*(TD/x)**3+C6*(TD/x)**4+C2*(5/pi**4)*(TD/x)**5)
!
! Einstein-term
e(x)=1/(exp(TE/x)-1)
!
! Anharmonic term (Original form from the paper of Senyshyn et al.)
!a(x)=(TD/x)*(x*exp(3*TD/x)+9*x*exp(2*TD/x)-12*TD*exp(2*TD/x)-9*x*exp(TD/x)-12*TD*exp(TD/x)-x)*((exp(TD/x)-1)**3)**-1
! Anharmonic term (Contracted form); Both forms are equivalent
a(x)=TD*(exp(3*TD/x)+3*(3-4*TD/x)*exp(2*TD/x)-3*(3+4*TD/x)*exp(TD/x)-1)/(exp(TD/x)-1)**3
!
#Fit parameters
c0=10.3235
TD=700
TE=200
xD=0.001
xE=-0.01
xA=-0.0001
h(x)=c0+xD*d(x)+xE*e(x)+xA*a(x)
#
#Fitting
#
fit [3.5:1163] h(x) filename u nt:np:nsu via c0,xD,xE,xA,TD,TE
set label 1 sprintf('c_0=%6.5f',c0) at xmin+xunit,ymax-yunit font "calibri, 17"
set label 2 sprintf('x_D=%4.3e',xD) at xmin+xunit*6,ymax-yunit font "calibri, 17"
set label 3 sprintf('{/Symbol q}_{D}=%3.0f',TD) at xmin+xunit*11,ymax-yunit font "calibri, 17"
set label 4 sprintf('x_E=%4.3e',xE) at xmin+xunit*6,ymax-yunit*2 font "calibri, 17"
set label 5 sprintf('{/Symbol q}_{E}=%3.0f',TE) at xmin+xunit*11,ymax-yunit*2 font "calibri, 17"
set label 6 sprintf('x_A=%4.3e',xA) at xmin+xunit*6,ymax-yunit*3 font "calibri, 17"
chisq = (FIT_STDFIT)**2	
#stats filename using np:(f(column(nt))) name "A"
#r2=A_correlation**2	
set label 7 sprintf("{/Symbol c}^2 = %5.4f", chisq) at xmin+xunit*11,ymax-yunit*3 font "calibri, 17"
#set label 8 sprintf("R^2 = %5.4f", r2) at xmin+16*xunit,ymax-yunit*5 font "calibri, 17"
plot filename u nt:np:nsu w yerrorbars pt psym ps 1 title 'Exp. data', h(x) lc 3 title 'Einstein+Debye+Anharmonic'

 
