set term windows enhanced size 1200,900
set encoding iso_8859_1
#
#x- and y-ranges for plotting
#
xmin=0
xmax=410
ymin=5.510
ymax=5.535
#
#Increments for the labels on the x- and y-axis
#
xincr=50
yincr=0.005
deltax=xmax-xmin
deltay=ymax-ymin
#
#Dimensions of the lengths of the axes in "cm" according to the size 1200,900
#Used for positioning of the numerical values of the fit parameters
#
width=26.5
length=17.5
xunit=deltax/width
yunit=deltay/length
#
#Name of the input file
#
filename="LaGaO3.dat"
#
#Column no. of the temperature data
#
nt=1
#
#Column no. of the relevant lattice parameter
#
np=2
#
#Column no. of the standard uncertainty of the relevant lattice parameter
#
nsu=3
set xrange [xmin:xmax]
set yrange [ymin:ymax]
set format y "%6.3f"
set xtics out nomirror scale 2 xmin,xincr,xmax
set ytics out nomirror scale 2 ymin,yincr,ymax
set mxtics 4
set mytics 2
set xtics font "Calibri,17"
set ytics font "Calibri,17"
set xlabel font "Calibri,18"
set ylabel font "Calibri,18" offset -4.0
#
#Title of the plot
#
set title 'LaGaO_3: Knight (2012) J. Solid State Chem. 194, 286'  
set title 'LaGaO_3: Knight (2012) J. Solid State Chem. 194, 286' 
set title font "Calibri,20"
set key font "Calibri,20"
set key spacing 2.0
set key right bottom
#
#Temperature unit C or K
#Remark: degree sign = \260
#
tu=" [K]"
set xlabel "Temperature".tu
#
#Relevant lattice parameter symbol a,b or c
#
lap=" a "
set ylabel "Lattice parameter".lap."[\305]"
#
# Plot symbols
# 1:+,2:x,3:*,4:square,6:circle,8:rhomb,10:triangle
psym=4
#
#Fit parameters
#
a0=5.5
xE1=0.005
TE1=20
xE2=0.00005
TE2=1000
g(x)=a0+xE1/(exp(TE1/x)-1)+xE2/(exp(TE2/x)-1)
#
#Fitting
#
fit g(x) filename u 1:2:3 via a0,xE1,TE1,xE2,TE2
set sample 100000
set label 1 sprintf('a_0=%6.5f',a0) at xmin+xunit,ymax-yunit font "calibri, 17"
set label 2 sprintf('x_{E1}=%4.3e',xE1) at xmin+xunit*6,ymax-yunit font "calibri, 17"
set label 3 sprintf('{/Symbol q}_{E1}=%3.0f',TE1) at xmin+xunit*11,ymax-yunit font "calibri, 17"
set label 4 sprintf('x_{E2}=%4.3e',xE2) at xmin+xunit*6,ymax-yunit*2 font "calibri, 17"
set label 5 sprintf('{/Symbol q}_{E2}=%3.0f',TE2) at xmin+xunit*11,ymax-yunit*2 font "calibri, 17"
chisq = (FIT_STDFIT)**2
#stats filename using np:(f(column(nt))) name "A"
#r2=A_correlation**2	
set label 6 sprintf("{/Symbol c}^2 = %5.4f", chisq) at xmin+xunit*6,ymax-yunit*3 font "calibri, 17"
#set label 8 sprintf("R^2 = %5.4f", r2) at xmin+11*xunit,ymax-yunit*3 font "calibri, 17"
plot filename u nt:np:nsu w yerrorbars pt psym ps 1 title 'Exp. data ', g(x) lc 3 title '2-term Einstein function'