set term windows enhanced size 1200,900
set encoding iso_8859_1
#
#x- and y-ranges for plotting
#
xmin=0
xmax=300
ymin=5.510
ymax=5.535
#
#Increments for the labels on the x- and y-axis
#
xincr=50
yincr=0.005
deltax=xmax-xmin
deltay=ymax-ymin
#
#Dimensions of the lengths of the axes in "cm" according to the size 1200,900
#Used for positioning of the numerical values of the fit parameters
#
width=26.5
length=17.5
xunit=deltax/width
yunit=deltay/length
#
#Name of the input file
#
filename="LaGaO3.dat"
#
#Column no. of the temperature data
#
nt=1
#
#Column no. of the relevant lattice parameter
#
np=2
#
#Column no. of the standard uncertainty of the relevant lattice parameter
#
nsu=3
set xrange [xmin:xmax]
set yrange [ymin:ymax]
set format y "%6.3f"
set xtics out nomirror scale 2 xmin,xincr,xmax
set ytics out nomirror scale 2 ymin,yincr,ymax
set mxtics 4
set mytics 2
set xtics font "Calibri,17"
set ytics font "Calibri,17"
set xlabel font "Calibri,18"
set ylabel font "Calibri,18" offset -4.0
set key font "Calibri,20"
set key spacing 2.0
set key right bottom
#
#Title of the plot
#
set title 'LaGaO_3: Knight (2012) J. Solid State Chem. 194, 286' 
set title font "Calibri,20"
#
#Temperature unit C or K
#Remark: degree sign = \260
#
tu=" [K]"
set xlabel "Temperature".tu
#
#Relevant lattice parameter symbol a,b or c
#
lap=" a "
set ylabel "Lattice parameter".lap."[\305]"
#
# Plot symbols
# 1:+,2:x,3:*,4:square,6:circle,8:rhomb,10:triangle
psym=4
set samples 100000
pi=3.14159265359
! Parametrisation of the Debye function according to Masyukov & Dmitriev
C1=-0.07713
C2=0.02433
C3=0.30548
C4=0.06513
C5=0.03487
C6=-0.00324
f(x)=x*(1+C1*(TD1/x)+C2*(TD1/x)**2)/(1+C3*(TD1/x)+C4*(TD1/x)**2+C5*(TD1/x)**3+C6*(TD1/x)**4+C2*(5/pi**4)*(TD1/x)**5)
g(x)=x*(1+C1*(TD2/x)+C2*(TD2/x)**2)/(1+C3*(TD2/x)+C4*(TD2/x)**2+C5*(TD2/x)**3+C6*(TD2/x)**4+C2*(5/pi**4)*(TD2/x)**5)
h(x)=a0+xD1*f(x)+xD2*g(x)
#
#Fit parameters
#
a0=5.51546
TD1=327
xD1=0.01
xD2=0.005
TD2=977
#
#Fitting
#
fit h(x) filename u nt:np:nsu via a0,TD1,xD1,TD2,xD2
set label 1 sprintf('a_0=%6.5f',a0) at xmin+xunit,ymax-yunit font "calibri, 17"
set label 2 sprintf('x_{D1}=%4.3e',xD1) at xmin+xunit*6,ymax-yunit font "calibri, 17"
set label 3 sprintf('{/Symbol q}_{D1}=%3.0f',TD1) at xmin+xunit*11,ymax-yunit font "calibri, 17"
set label 4 sprintf('x_{D2}=%4.3e',xD2) at xmin+xunit*6,ymax-yunit*2 font "calibri, 17"
set label 5 sprintf('{/Symbol q}_{D2}=%3.0f',TD2) at xmin+xunit*11,ymax-yunit*2 font "calibri, 17"
chisq = (FIT_STDFIT)**2	
#stats filename using np:(f(column(nt))) name "A"
#r2=A_correlation**2	
set label 7 sprintf("{/Symbol c}^2 = %5.4f", chisq) at xmin+xunit*6,ymax-yunit*3 font "calibri, 17"
#set label 8 sprintf("R^2 = %5.4f", r2) at xmin+11*xunit,ymax-yunit*3 font "calibri, 17"
plot filename u nt:np:nsu w yerrorbars pt psym ps 1 title 'Exp. data ', h(x) lc 3 title '2-term Debye function'