function swmm_inpwirte(areas,nodes,links,rainfile,pollutants,networkname,location)
% Autor: Michael Mderl
n_areas=length(areas.a);
n_nodes=length(nodes.x);
n_links=length(links.start);

fid = fopen([location networkname '.inp'],'w');

%[TITLE]
fprintf(fid,'[TITLE]\r\n');
fprintf(fid,'csg\r\n');
fprintf(fid,'\r\n');


%[OPTIONS]
fprintf(fid,'[OPTIONS]\r\n');

fprintf(fid,'FLOW_UNITS LPS\r\n');
fprintf(fid,'FLOW_ROUTING DYNWAVE\r\n');
fprintf(fid,'INFILTRATION         HORTON\r\n');
fprintf(fid,'START_DATE 1/1/2000\r\n');
fprintf(fid,'START_TIME 00:00\r\n');
fprintf(fid,'END_DATE 1/2/2000\r\n');
fprintf(fid,'END_TIME 00:00\r\n');
fprintf(fid,'REPORT_START_DATE 1/1/2000\r\n');
fprintf(fid,'REPORT_START_TIME 00:00\r\n');
fprintf(fid,'SWEEP_START          01/01\r\n');
fprintf(fid,'SWEEP_END            12/31\r\n');
fprintf(fid,'DRY_DAYS             0\r\n');
fprintf(fid,'REPORT_STEP          00:05:00\r\n');
fprintf(fid,'WET_STEP             00:01:00\r\n');
fprintf(fid,'DRY_STEP             00:01:00\r\n');
fprintf(fid,'ROUTING_STEP         0:01:00 \r\n');
fprintf(fid,'ALLOW_PONDING        YES\r\n');
fprintf(fid,'INERTIAL_DAMPING     PARTIAL\r\n');
fprintf(fid,'VARIABLE_STEP        0.75\r\n');
fprintf(fid,'LENGTHENING_STEP     300\r\n');
fprintf(fid,'MIN_SURFAREA         0\r\n');
fprintf(fid,'NORMAL_FLOW_LIMITED  BOTH\r\n');
fprintf(fid,'SKIP_STEADY_STATE    NO\r\n');
fprintf(fid,'IGNORE_RAINFALL      NO\r\n');
fprintf(fid,'FORCE_MAIN_EQUATION  H-W\r\n');
fprintf(fid,'LINK_OFFSETS         DEPTH\r\n');
fprintf(fid,'\r\n');

%[REPORT]
fprintf(fid,'[REPORT]\r\n');
fprintf(fid,'INPUT NO\r\n');
fprintf(fid,'CONTINUITY YES\r\n');
fprintf(fid,'FLOWSTATS YES\r\n');
fprintf(fid,'CONTROLS NO\r\n');
fprintf(fid,'SUBCATCHMENTS NONE\r\n');
fprintf(fid,'NODES NONE\r\n');
fprintf(fid,'LINKS NONE\r\n');
fprintf(fid,'\r\n');

% %[FILES]
% fprintf(fid,'[FILES]\r\n');
% fprintf(fid,'USE RAINFALL C:\\_Eigene_Dateien\\MATLAB\\csg\\rain.rff\r\n');
% fprintf(fid,'\r\n');

%[RAINGAGES]
fprintf(fid,'[RAINGAGES]\r\n');
fprintf(fid,['RG01 VOLUME 0:05 1.0 FILE ' rainfile ' STA01 MM\r\n']);
fprintf(fid,'\r\n');

%[SUBCATCHMENTS]
fprintf(fid,'[SUBCATCHMENTS]\r\n');
for i=1:n_areas
    fprintf(fid,['subcatchment' num2str(i) ' RG01 ' 'node' num2str(i) ' ' num2str(areas.a(i)) ' ' num2str(areas.imperv(i)*100) ' ' num2str(areas.width(i)) ' ' num2str(areas.slope(i)*100) ' ' num2str(areas.clength(i))  '\r\n']);
end
fprintf(fid,'\r\n');

%[SUBAREAS]
fprintf(fid,'[SUBAREAS]\r\n');
for i=1:n_areas
    fprintf(fid,['subcatchment' num2str(i) ' ' num2str(areas.nimp(i)) ' ' num2str(areas.nperf(i))  ' ' num2str(areas.sinp(i))  ' ' num2str(areas.sperv(i))  ' ' num2str(areas.zero(i)) ' OUTLET\r\n']);
end
fprintf(fid,'\r\n');

%[INFILTRATION]
fprintf(fid,'[INFILTRATION]\r\n');
for i=1:n_areas
    fprintf(fid,['subcatchment' num2str(i) ' 60 6.12 3 6 0\r\n']);
end
fprintf(fid,'\r\n');

%[JUNCTIONS]
fprintf(fid,'[JUNCTIONS]\r\n');
for i=1:n_nodes
    if nodes.type(i)==0;
        fprintf(fid,['node' num2str(i) ' ' num2str(nodes.elev(i)) ' ' num2str(nodes.ymax(i)) ' ' num2str(nodes.y0(i)) ' 0 ' num2str(areas.a(i)*100*100+1) '\r\n']);
    end
end
fprintf(fid,'\r\n');

%[OUTFALLS]
fprintf(fid,'[OUTFALLS]\r\n');
for i=1:n_nodes
    if nodes.type(i)==1;
        fprintf(fid,['node' num2str(i) ' ' num2str(nodes.elev(i)) ' FREE NO\r\n']);
    end
end
fprintf(fid,'\r\n');

%[STORAGE]
fprintf(fid,'[STORAGE]\r\n');
for i=1:n_nodes
    if nodes.type(i)==2;
        fprintf(fid,['node' num2str(i) ' ' num2str(nodes.elev(i))  ' ' num2str(nodes.ymax(i)) ' ' num2str(nodes.y0(i)) ' FUNCTIONAL 0 0 '  num2str(nodes.v(i)/nodes.ymax(i)) ' ' num2str(areas.a(i)*100*100+1) '\r\n']);
    end
end
fprintf(fid,'\r\n');

%[CONDUITS]
fprintf(fid,'[CONDUITS]\r\n');
for i=1:n_links
    if links.type(i)==0;
        fprintf(fid,['link' num2str(i) ' node' num2str(links.start(i)) ' node' num2str(links.end(i)) ' ' num2str(links.length(i)) ' ' num2str(links.n(i)) ' ' num2str(links.z1(i)) ' ' num2str(links.z2(i))    '\r\n']);
    end
end
fprintf(fid,'\r\n');

%[WEIRS]
fprintf(fid,'[WEIRS]\r\n');
for i=1:n_links
    if links.type(i)==1;
        fprintf(fid,['link' num2str(i) ' node' num2str(links.start(i)) ' node' num2str(links.end(i)) ' ' ' TRANSVERSE ' num2str(links.height(i)) ' ' num2str(links.cd(i)) ' \r\n']);
    end
end
fprintf(fid,'\r\n');

%[XSECTIONS]
fprintf(fid,'[XSECTIONS]\r\n');
for i=1:n_links
    if links.type(i)==0
        fprintf(fid,['link' num2str(i) ' CIRCULAR ' num2str(links.diam(i)) ' 0 0 0\r\n']);
    elseif links.type(i)==1
        fprintf(fid,['link' num2str(i) ' RECT_OPEN ' num2str(links.diam(i)) ' ' num2str(links.l(i)) ' 0 0\r\n']);
    end
end
fprintf(fid,'\r\n');
if isempty(pollutants)
else
    %[POLLUTANTS]
    fprintf(fid,'[POLLUTANTS]\r\n');
    for i=1:length(pollutants)
        fprintf(fid,[pollutants{i} ' MG/L 0 0 0 0 NO\r\n']);
    end
    fprintf(fid,'\r\n');
end

%[DWF]
fprintf(fid,'[DWF]\r\n');
for i=1:n_areas
    %if nodes.type(i)==0;
    fprintf(fid,['node' num2str(i) ' FLOW ' num2str(areas.dwf(i)) ' \r\n']);
    %end
end
fprintf(fid,'\r\n');


%[COORDINATES]
fprintf(fid,'[COORDINATES]\r\n');
for i=1:n_nodes
    fprintf(fid,['node' num2str(i) ' ' num2str(nodes.x(i)) ' ' num2str(nodes.y(i))  '\r\n']);
end
fprintf(fid,'\r\n');

fclose all;