function [links,nodes]=gettheweirs(nodes,links,elevgradient,sewerlength)
% Autor: Michael Mderl
offsetfactor=1/80;
% Add outfall nodes and weirs to the network
index_store=find(nodes.type==2);
len=length(links.end);
for ii=1:length(index_store)
        nodes.x=[nodes.x nodes.x(index_store(ii))+sewerlength*offsetfactor];
        nodes.y=[nodes.y nodes.y(index_store(ii))+sewerlength*offsetfactor];
        nodes.type=[nodes.type 1];
        nodes.elev=[nodes.elev nodes.elev(index_store(ii))-sewerlength*offsetfactor*elevgradient];

        links.end=[links.end ii+len+1];
        links.start=[links.start index_store(ii)];
        links.type=[links.type 1];
end

%add finall outfall
nodes.x=[nodes.x nodes.x(1)];
nodes.y=[nodes.y nodes.y(1)+sewerlength*offsetfactor];
nodes.type=[nodes.type 1];
nodes.elev=[nodes.elev nodes.elev(1)-sewerlength*offsetfactor*elevgradient];
if isempty(index_store)
    links.end=[links.end length(nodes.x)];
else
    links.end=[links.end ii+len+2];
end

links.start=[links.start 1];
links.type=[links.type 0];