function [areas,links,nodes]=gettheproberties(areas,links,nodes,valuegradient,sewerlength,rint,links_diams)
% Autor: Michael Mderl
n_areas=sum(nodes.type~=1);
n_nodes=length(nodes.x);
n_gen=max(nodes.gen);
n_links=length(links.start);
index_weirs=find(links.type);
diam_n=ones(1,n_links)*links_diams(end);
%links
for i=1:n_links
    Qpipemax=areas.aimpcon(links.start(i))*rint*1/1000;%v=1m/s => Q=A
    links.diam(i)=(4*Qpipemax/pi)^0.5;
end

for i=1:length(links_diams)
    if i==1
        diam_n(find( (links.diam < links_diams(i))  ))=links_diams(i);
    else
        diam_n(find( (links.diam < links_diams(i)) & (links.diam > links_diams(i-1)) ))=links_diams(i);
    end
end
links.diam=diam_n;

for i=1:length(index_weirs)
    d0(i)=min(links.diam(find(links.start(index_weirs(i))==links.end)));
    links.l(index_weirs(i))=10;
end
if isempty(index_weirs)
else
    links.height(index_weirs)=d0.*(0.7+rand(1,length(index_weirs))/10);
    links.diam(index_weirs)=max(links.diam);
end

links.length=((nodes.x(links.start)-nodes.x(links.end)).^2+(nodes.y(links.start)-nodes.y(links.end)).^2).^0.5;
links.n=0.015*ones(1,length(links.start));
links.z1=0*ones(1,length(links.start));
links.z2=0*ones(1,length(links.start));
links.cd=1.8*ones(1,length(links.start));


%Areas
areas.width=            sewerlength/n_gen*ones(1,n_areas);
areas.slope=            valuegradient*ones(1,n_areas);
areas.clength=          1*ones(1,n_areas);
areas.nimp=             0.015*ones(1,n_areas);
areas.nperf=            0.200*ones(1,n_areas);
areas.sinp=             1.8*ones(1,n_areas);
areas.sperv=            5*ones(1,n_areas);
areas.zero=             0*ones(1,n_areas);

%Nodes
for i=1:n_nodes
    if nodes.type(i)==1
    else
        if isempty(find(links.end==i))
            nodes.ymax(i)=max(links.diam(find(links.start==i)))+2;
        else
            nodes.ymax(i)=max(links.diam(find(links.end==i)))+2;
        end
        if nodes.type(i)==2
            nodes.v(i)=sum( areas.aimpcon( links.start(find(links.end==i)) )) * (5+45*rand(1))+1;
        end
    end
end
nodes.y0=0*ones(1,length(nodes.x));