function nodes = getthenodes(nodes,sewerlength,elevwwtp,elevgradient)
% Autor: Michael Mderl
% extended original code by Ingemar Kaj and Raimundas Gaigalas
% taken from http://www.math.uu.se/research/telecom/software/

parent=nodes.parent;
n = length(parent);
pv = [];

a = parent;
a(a==0) = n+1;
pv = 1:n;

niter = 0;
while(1)
    k = find(a<(1:n));
    if isempty(k), break; end
    k = k(1);
    j = a(k);

    % Put node k before its parent node j
    a  = [ a(1:j-1)  a(k)  a(j:k-1)  a(k+1:end)];
    pv = [pv(1:j-1) pv(k) pv(j:k-1) pv(k+1:end)];
    t = (a >= j & a < k);
    a(a==k) = j;
    a(t) = a(t) + 1;

    niter = niter+1;
    if (niter>n*(n-1)/2), error('Bad vector of parent pointers.'); end
end

a(a>n) = 0;
parent=a;

j = find(parent);
A = sparse (parent(j), j, 1, n, n);
A = A + A' + speye(n,n);
[ignore, post] = etree(A);


% Add a dummy root node #n+1, and identify the leaves.

parent = rem(parent+n, n+1) + 1;  % change all 0s to n+1s
isaleaf = ones(1,n+1);
isaleaf(parent) = zeros(n,1);

% In postorder, compute heights and descendant leaf intervals.
% Space leaves evenly in x (in postorder).

xmin = n(1,ones(1,n+1)); % n+1 copies of n
xmax = zeros(1,n+1);
height = zeros(1,n+1);
nkids = zeros(1,n+1);
nleaves = 0;

for i = 1:n,
    node = post(i);
    if isaleaf(node),
        nleaves = nleaves+1;
        xmin(node) = nleaves;
        xmax(node) = nleaves;
    end;
    dad = parent(node);
    xmin(dad)   = min (xmin(dad),   xmin(node));
    xmax(dad)   = max (xmax(dad),   xmax(node));
    nkids(dad)  = nkids(dad)+1;
end;

% RG compute heights
% traverse the tree from the root downwards in a layer-manner
lay_ind = n+1;
par_ind = n+1;
while(1)
    lay_ind = find(ismember(parent, lay_ind));
    if isempty(lay_ind)
        break;
    end
    par_ind = [par_ind lay_ind];
    height(par_ind) = height(par_ind)+1;
end
height(1:n) = height(1:n)-1;

% Compute coordinates, leaving a little space on all sides.
treeht = height(n+1) - 1;

deltax = 1/(nleaves+1);
deltay = 1/(treeht);
% nodes.deltax=deltax*sewerlength/2;
% nodes.deltay=deltay*sewerlength;
x = deltax * (xmin+xmax)/2;
y = deltay * (height);

% Omit the dummy node.
x = x(1:n);

y = y(1:n);
h=height(1:n);
nkids=nkids(1:n);

% Return the height and top separator size.
if ~isempty(pv)
    x(pv) = x;
    y(pv) = y;
    h(pv) = h;
    nkids(pv) = nkids;
end
nodes.gen=max(h)-h;
nodes.x=x*sewerlength/2+ (rand(1,length(x))-1)*deltax*sewerlength/2;
nodes.y=y*sewerlength+( (rand(1,length(x))-1)/(1+max(nodes.gen))*sewerlength);
nodes.type=0*ones(1,length(nodes.x)); 

nodes.elev(1)=elevwwtp;
for i=1:max(nodes.parent)
    kids=find(nodes.parent==i);
    elevgrad=elevgradient/2+elevgradient*(mean(nodes.gen(kids))-1)/max(nodes.gen-1);
    nodes.elev(kids)=nodes.elev(i)+(nodes.y(i)-nodes.y(kids)).*(elevgrad*.9+0.2*rand(1,length(kids))*elevgrad);
end



