% Case Study Generator
% Autor: Michael Mderl
%% initialization
clear all;clc;close all;rand('twister',sum(100*clock));
%number of generated virtual case studies (VCS)
n=5;

%allow storage units (1 -> Yes,  0 -> No )
as=1;

%constant boundary conditions
%rain fall intensity for pipe diameter design
rint=100;% [l/s/ha] r15(1)* time depending factor
%elevation of waste water treatement plant (WWTP)
elevwwtp=500;% [m]

%location of mfiles and rainfall file
location='C:\Daten\pa_papers\CSG\05-Bearbeitung\online\';
rainfile='euler_II_133_120.dat';

%probability matrix of children
prob_mat(1:4,1)= [0.00 0.50 0.50 0.00];
for i=2:5
    prob_mat(1:4,i)= [0.00 0.45 0.55 0.00];
end
for ii=i:14
    prob_mat(1:4,ii)= [0.20 0.44 0.34 0.02];
end
for iii=ii:ii+4
    prob_mat(1:4,iii)=   [0.50 0.30 0.20 0.00];
end

% min and max of uniform distributed boundery condtions
% minimum and maximum of average elevation gradient
min_eg=0.5;% [%]
max_eg=1.5;% [%]
% minimum and maximum of longest path through urban drainage system (UDS)
min_sl=5000;% [m]
max_sl=10000;% [m]
% minimum and maximum population density
min_pd=1500;% [inhabitants/km]
max_pd=2500;% [inhabitants/km]
% waste water per population equivalent
min_pe=200;% [l/day/pe]
max_pe=300;% [l/day/pe]

pollutants=[];%pollutants={'ssolid';'vssolid';'cod';'cods';'nh4';'no3'};
%% Generation of VCS
for i=1:n
    % random variables
    elevgradient=(min_eg+(max_eg-min_eg)*rand(1))/100;
    pe=(min_pe+(max_pe-min_pe)*rand(1))/86400;
    populationdensity=(min_pd+(max_pd-min_pd)*rand(1))/1000^2*10000;
    sewerlength=min_sl+(max_sl-min_sl)*rand(1);
    % used pipe dimaeter
    links_diams=[0.2:0.1:0.6 0.8 1:0.2:2];
    % get the parents of each node for tree generation
    nodes=gettheparents(prob_mat);
    % get the nodes of the tree
    nodes=getthenodes(nodes,sewerlength,elevwwtp,elevgradient);
    % get the links of the tree
    links=getthelinks(nodes);
    % create a surface raster
    gridareas=getthegrid(sewerlength,nodes,elevgradient);
    % allocate sub catchments to nodes
    [areas gridareas]=gettheareas(gridareas,nodes,populationdensity,pe,sewerlength);
    % introduce storage nodes
    if as==1
        nodes=getthestorages(nodes,links,areas);
    else
        nodes.v=[];
    end
    % introduce weirs
    [links,nodes]=gettheweirs(nodes,links,elevgradient,sewerlength);
    % allocate sub catchments for pipe design
    areas=gettheareasconnected(areas,nodes,links);
    % design of properties (e.g. pipe roughness)
    [areas,links,nodes]=gettheproberties(areas,links,nodes,elevgradient,sewerlength,rint,links_diams);
    % store characteristics
    CSC.nareas(i)=length(areas.a);
    CSC.nnodes(i)=length(nodes.x);
    CSC.nstor(i)=sum(nodes.type==2);
    CSC.area(i)=sum(areas.a);
    CSC.areaimp(i)=sum(areas.a.*areas.imperv);
    CSC.linklength(i)=sum(links.length);
    CSC.vcso(i)=sum(nodes.v);
    CSC.diam(i,1:3)=[min(links.diam) mean(links.diam) max(links.diam)];
    % write input file for swmm simulation
    networkname=['vcs_' num2str(i)];
    swmm_inpwirte(areas,nodes,links,rainfile,pollutants,networkname,location)
   if n>1
        clear('areas','links','nodes','gridareas');
   end
end