/*
 * Decompiled with CFR 0.152.
 */
package uibk.mtk.draw2d.objects;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.event.MouseEvent;
import java.awt.geom.Line2D;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Vector;
import uibk.mtk.draw2d.base.Drawable2D;
import uibk.mtk.draw2d.base.MathPanel2D;
import uibk.mtk.draw2d.objects.DragablePoint2D;
import uibk.mtk.draw2d.objects.Graph2D;
import uibk.mtk.draw2d.objects.MathPoint2D;
import uibk.mtk.draw2d.util.GraphUtil;
import uibk.mtk.geom.CoordinateRect2D;
import uibk.mtk.lang.Clickable;
import uibk.mtk.lang.Dragable;
import uibk.mtk.lang.PrepaintComputable;
import uibk.mtk.math.Interval;
import uibk.mtk.math.functions.Function1D;
import uibk.mtk.util.IntervalIterator;

public class RiemannSum
extends Drawable2D
implements PrepaintComputable,
Dragable,
Clickable {
    private Color edgecolor = new Color(200, 200, 200, 130);
    private Color linescolor = new Color(153, 210, 166);
    Function1D function;
    private Color pointcolor = Color.darkGray;
    private Color negativecolor = new Color(174, 215, 255);
    private Color shapecolor = new Color(255, 255, 0, 100);
    Color errorcolor = new Color(255, 100, 100, 100);
    boolean intervalsenabled;
    boolean random = true;
    int pointradius = 1;
    double sum;
    Dragable dragged = null;
    Vector shapes = new Vector();
    Interval interval = new Interval(0.0, 1.0);
    Graph2D graph = new Graph2D();
    int numpointsgraph = 400;
    Vector points = new Vector();
    int n = 10;
    boolean negative_samecolor = true;
    Vector lines = new Vector();

    public RiemannSum() {
        this.graph.setColor(Color.blue);
        this.setColor(this.shapecolor);
    }

    @Override
    public boolean isDragEnabled() {
        return this.intervalsenabled;
    }

    private void leftandright() {
        int k = this.points.size();
        if (k == 0) {
            return;
        }
        int i = 0;
        while (i < k) {
            IntervalPoint p = (IntervalPoint)this.points.elementAt(i);
            if (i < k - 1) {
                p.right = (IntervalPoint)this.points.elementAt(i + 1);
            }
            if (i > 0) {
                p.left = (IntervalPoint)this.points.elementAt(i - 1);
            }
            ++i;
        }
        IntervalPoint p = (IntervalPoint)this.points.elementAt(k - 1);
        p.right = null;
    }

    public void enableIntervals(boolean enable) {
        this.intervalsenabled = enable;
    }

    private void addNewIntervallPoint(double x) {
        double min = ((IntervalPoint)this.points.elementAt(0)).getX();
        double max = ((IntervalPoint)this.points.elementAt(this.points.size() - 1)).getX();
        if (x < min) {
            IntervalPoint newpoint = this.createpoint(x);
            IntervalPoint right = (IntervalPoint)this.points.elementAt(0);
            double mid = (newpoint.getX() + right.getX()) / 2.0;
            this.points.add(0, newpoint);
            this.points.add(1, this.createpointmid(mid));
            return;
        }
        if (x > max) {
            IntervalPoint newpoint = this.createpoint(x);
            IntervalPoint left = (IntervalPoint)this.points.elementAt(this.points.size() - 1);
            double mid = (left.getX() + newpoint.getX()) / 2.0;
            this.points.add(this.points.size(), this.createpointmid(mid));
            this.points.add(this.points.size(), newpoint);
            return;
        }
        ListIterator it = this.points.listIterator();
        MathPoint2D left = null;
        int i = 0;
        while (it.hasNext()) {
            IntervalPoint p = (IntervalPoint)it.next();
            if (left != null && x > left.getX() && x < p.getX()) {
                if (left instanceof SamplingPoint) {
                    IntervalPoint newpoint = this.createpoint(x);
                    IntervalPoint right = (IntervalPoint)this.points.elementAt(i);
                    double mid = (newpoint.getX() + right.getX()) / 2.0;
                    this.points.add(i, newpoint);
                    this.points.add(i + 1, this.createpointmid(mid));
                } else {
                    IntervalPoint newpoint = this.createpoint(x);
                    double mid = (left.getX() + newpoint.getX()) / 2.0;
                    this.points.add(i, this.createpointmid(mid));
                    this.points.add(i + 1, newpoint);
                }
                return;
            }
            ++i;
            left = p;
        }
    }

    @Override
    public boolean clickcontains(int x, int y) {
        double xx = this.scene2d.pixelToX(x);
        if (xx < this.interval.a || xx > this.interval.b) {
            return false;
        }
        return this.scene2d.yToPixel(0.0) - y <= 10;
    }

    @Override
    public void click(MouseEvent ev) {
        if (!this.intervalsenabled) {
            return;
        }
        double x = this.scene2d.pixelToX(ev.getX());
        if (this.onlyRightButton(ev)) {
            this.addNewIntervallPoint(x);
        }
        if (this.onlyMiddleButton(ev)) {
            if (this.points.size() < 4) {
                return;
            }
            ListIterator it = this.points.listIterator();
            int i = 0;
            while (it.hasNext()) {
                IntervalPoint p = (IntervalPoint)it.next();
                if (!(p instanceof SamplingPoint) && p.dragcontains(ev.getX(), ev.getY())) {
                    this.points.remove(i);
                    if (i == 0) {
                        this.points.remove(0);
                        break;
                    }
                    if (i == this.points.size() - 1) {
                        this.points.remove(this.points.size() - 1);
                        break;
                    }
                    this.points.remove(i - 1);
                    break;
                }
                ++i;
            }
        }
        this.leftandright();
        this.computesum();
        this.panel.repaint();
    }

    private boolean onlyLeftButton(MouseEvent ev) {
        return ev.getModifiers() == 16;
    }

    private boolean onlyRightButton(MouseEvent ev) {
        return ev.getModifiers() == 4;
    }

    private boolean onlyMiddleButton(MouseEvent ev) {
        return ev.getModifiers() == 8;
    }

    public boolean intervalsEnabled() {
        return this.intervalsenabled;
    }

    public boolean randomEnabled() {
        return this.random;
    }

    private double[] rand() {
        int k = this.n + 1;
        double xmin = this.interval.a;
        double xmax = this.interval.b;
        double delta = this.interval.getLength() / (double)this.n;
        double minlength = delta / 2.0;
        double maxlength = delta * 1.5;
        Double[] numbers = new Double[this.n];
        double summe = 0.0;
        int i = 0;
        while (i < this.n / 2) {
            double t = RiemannSum.rand(minlength, maxlength);
            numbers[i] = new Double(t);
            summe += t;
            ++i;
        }
        double dt = (this.interval.getLength() - summe) / (double)(this.n / 2 + 1);
        int i2 = this.n / 2;
        while (i2 < this.n) {
            numbers[i2] = new Double(dt);
            ++i2;
        }
        Collections.shuffle(Arrays.asList(numbers));
        double[] limits = new double[k];
        double pos = xmin;
        limits[0] = xmin;
        limits[k - 1] = xmax;
        int i3 = 1;
        while (i3 < k - 1) {
            limits[i3] = pos += numbers[i3].doubleValue();
            ++i3;
        }
        return limits;
    }

    private static double rand(double xmin, double xmax) {
        return xmin + Math.random() * (xmax - xmin);
    }

    public void randomSubDivisions(boolean b) {
        this.random = b;
    }

    @Override
    public void drag(MouseEvent ev) {
        if (!this.intervalsenabled || !this.onlyLeftButton(ev)) {
            return;
        }
        this.dragged.drag(ev);
        this.computesum();
    }

    @Override
    public boolean dragcontains(int xm, int ym) {
        for (DragablePoint2D mathpoint : this.points) {
            if (!mathpoint.dragcontains(xm, ym)) continue;
            this.dragged = mathpoint;
            return true;
        }
        return false;
    }

    @Override
    public void enabledrag(boolean enable) {
    }

    public void setFunction(Function1D func) {
        this.function = func;
    }

    public void setInterval(Interval inter) {
        this.interval = (Interval)inter.clone();
    }

    public void setNumberSubDivisions(int size) {
        if (size != this.n) {
            this.computesum();
            this.n = size;
        }
    }

    private void createIntervalPoints() {
        this.points.clear();
        if (this.random) {
            double[] limits = this.rand();
            MathPoint2D last = null;
            int i = 0;
            while (i < limits.length) {
                IntervalPoint p = this.createpoint(limits[i]);
                if (last != null) {
                    SamplingPoint m = this.createpointmid((last.getX() + p.getX()) / 2.0);
                    this.points.add(m);
                }
                this.points.add(p);
                last = p;
                ++i;
            }
        } else {
            IntervalIterator it = new IntervalIterator(this.interval, this.n + 1);
            MathPoint2D last = null;
            while (it.hasNext()) {
                IntervalPoint p = this.createpoint(it.nextdouble());
                if (last != null) {
                    SamplingPoint m = this.createpointmid((last.getX() + p.getX()) / 2.0);
                    this.points.add(m);
                }
                this.points.add(p);
                last = p;
            }
        }
        this.leftandright();
    }

    IntervalPoint createpoint(double x) {
        IntervalPoint p = new IntervalPoint(x);
        p.setColor(this.pointcolor);
        p.setRadius(this.pointradius);
        p.setMathPanel2D(this.panel);
        return p;
    }

    SamplingPoint createpointmid(double x) {
        SamplingPoint p = new SamplingPoint(x);
        p.setColor(this.linescolor);
        p.setRadius(this.pointradius);
        p.setMathPanel2D(this.panel);
        return p;
    }

    @Override
    public void setMathPanel2D(MathPanel2D panel) {
        super.setMathPanel2D(panel);
        this.graph.setMathPanel2D(panel);
    }

    @Override
    public void prepaintcompute() throws Exception {
        this.computeshapes();
    }

    private void computeshapes() {
        this.shapes.clear();
        this.lines.clear();
        int yPix0 = this.scene2d.yToPixel(0.0);
        MathPoint2D left = null;
        IntervalPoint right = null;
        IntervalPoint mid = null;
        for (IntervalPoint p : this.points) {
            if (!(p instanceof SamplingPoint)) {
                right = p;
            } else {
                mid = p;
            }
            if (left != null) {
                double xl = left.getX();
                double xm = mid.getX();
                double xr = right.getX();
                int xPixLeft = this.scene2d.xToPixel(xl);
                int xPixRight = this.scene2d.xToPixel(xr);
                int xPixMid = this.scene2d.xToPixel(xm);
                int yPixFMid = this.scene2d.yToPixel(this.function.getValue(xm));
                MyPolygon poly = new MyPolygon();
                poly.addPoint(xPixLeft, yPix0);
                poly.addPoint(xPixLeft, yPixFMid);
                poly.addPoint(xPixRight, yPixFMid);
                poly.addPoint(xPixRight, yPix0);
                poly.fillcolor = yPixFMid > yPix0 && !this.negative_samecolor ? this.negativecolor : this.color;
                this.shapes.add(poly);
                Line2D.Double line = new Line2D.Double(xPixMid, yPix0, xPixMid, yPixFMid);
                this.lines.add(line);
            }
            left = right;
        }
    }

    @Override
    public void draw(BufferedImage framebuffer, Graphics2D g2) {
        for (MyPolygon shape : this.shapes) {
            g2.setColor(shape.fillcolor);
            g2.fill(shape);
            g2.setColor(this.edgecolor);
            g2.draw(shape);
        }
        Iterator it = this.lines.iterator();
        g2.setColor(this.linescolor);
        while (it.hasNext()) {
            g2.draw((Line2D.Double)it.next());
        }
        this.graph.draw(framebuffer, g2);
        if (this.intervalsenabled) {
            for (DragablePoint2D mathpoint : this.points) {
                mathpoint.draw(framebuffer, g2);
            }
        }
    }

    public void create() throws Exception {
        this.createIntervalPoints();
        this.graph.setPoints(GraphUtil.compute(this.function, this.interval.a, this.interval.b, this.numpointsgraph));
        this.computesum();
        this.computeshapes();
    }

    public CoordinateRect2D getLimits() {
        return this.graph.getLimits();
    }

    public int getNumberSubDivisions() {
        return this.n;
    }

    public double getSum() {
        return this.sum;
    }

    private void computesum() {
        this.sum = 0.0;
        int i = 2;
        while (i < this.points.size()) {
            IntervalPoint left = (IntervalPoint)this.points.elementAt(i - 2);
            IntervalPoint middle = (IntervalPoint)this.points.elementAt(i - 1);
            IntervalPoint right = (IntervalPoint)this.points.elementAt(i);
            this.sum += (right.getX() - left.getX()) * this.function.getValue(middle.getX());
            i += 2;
        }
    }

    public Function1D getFunction() {
        return this.function;
    }

    public Interval getInterval() {
        return (Interval)this.interval.clone();
    }

    public void enableSameColor(boolean b) {
        this.negative_samecolor = b;
    }

    public boolean isEnabledSameColor() {
        return this.negative_samecolor;
    }

    class IntervalPoint
    extends DragablePoint2D {
        IntervalPoint left;
        IntervalPoint right;

        public IntervalPoint(double x) {
            super(x, 0.0);
            this.left = null;
            this.right = null;
        }

        @Override
        public void drag(MouseEvent ev) {
            double t = this.scene2d.pixelToX(ev.getX());
            if (this.left == null && t < RiemannSum.this.interval.a) {
                return;
            }
            if (this.right == null && t > RiemannSum.this.interval.b) {
                return;
            }
            if (this.left != null && t <= this.left.x) {
                return;
            }
            if (this.right != null && t >= this.right.x) {
                return;
            }
            this.x = t;
        }
    }

    class MyPolygon
    extends Polygon {
        Color fillcolor;

        MyPolygon() {
        }
    }

    class SamplingPoint
    extends IntervalPoint {
        public SamplingPoint(double x) {
            super(x);
        }
    }
}

