/*
 * Decompiled with CFR 0.152.
 */
package uibk.applets.riemann;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import javax.swing.JLabel;
import uibk.applets.riemann.Messages;
import uibk.mtk.draw2d.objects.RiemannSum;
import uibk.mtk.swing.base.TitledPanel;

public class PanelOutput
extends TitledPanel {
    DecimalFormat format = new DecimalFormat("0.0000000000", new DecimalFormatSymbols(Locale.US));
    JLabel labelsum = new JLabel("");
    JLabel labelsubdiv = new JLabel("");
    JLabel labelexact = new JLabel(Messages.getString("PanelOutput.4"));
    JLabel labelerror = new JLabel("");
    private static String FORMATCOLOR = Messages.getString("PanelOutput.6");
    double exactvalue = 0.0;

    public PanelOutput() {
        super(Messages.getString("PanelOutput.0"));
        this.initComponents();
    }

    void initComponents() {
        this.setLayout(new GridBagLayout());
        this.add((Component)this.labelsubdiv, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 11, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.labelsum, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 11, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.labelerror, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 11, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.labelexact, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 11, 2, new Insets(5, 5, 5, 5), 0, 0));
    }

    public void createOutput(RiemannSum integrationvis) {
        double sum = integrationvis.getSum();
        String n = String.valueOf(integrationvis.getNumberSubDivisions());
        this.labelsubdiv.setText(this.makeString(Messages.getString("PanelOutput.7"), n));
        this.labelsum.setText(this.makeString(Messages.getString("PanelOutput.8"), this.format.format(sum)));
        this.labelerror.setText(this.makeString(Messages.getString("PanelOutput.9"), this.format.format(Math.abs(this.exactvalue - sum))));
        this.labelexact.setText(this.makeString(Messages.getString("PanelOutput.10"), this.format.format(this.exactvalue)));
    }

    public void clear() {
        this.labelsum.setText("");
        this.labelsubdiv.setText("");
        this.labelsum.setText("");
        this.labelerror.setText("");
        this.labelexact.setText("");
        this.labelsum.setText("");
    }

    String makeString(String name, String value) {
        String str = "<html><font color=" + FORMATCOLOR + ">" + name + ": </font>" + value;
        return str;
    }

    public void setExactValue(double v) {
        this.exactvalue = v;
    }
}

