/*
 * Decompiled with CFR 0.152.
 */
package uibk.mtk.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JRadioButton;
import uibk.mtk.draw3d.base.MathPanel3D;
import uibk.mtk.draw3d.objects.surface3d.ColorModel;
import uibk.mtk.draw3d.objects.surface3d.ColorModelXY;
import uibk.mtk.draw3d.objects.surface3d.ColorModelXYZ;
import uibk.mtk.draw3d.objects.surface3d.ColorModelZ;
import uibk.mtk.draw3d.objects.surface3d.Surface3D;
import uibk.mtk.swing.Messages;
import uibk.mtk.swing.base.TitledPanel;

public class PanelColoring
extends TitledPanel
implements ActionListener {
    MathPanel3D mathpanel3d;
    Surface3D surface3d;

    public PanelColoring(MathPanel3D mathpanel3d, Surface3D surface3d) {
        super(Messages.getString("PanelColoring.0"));
        if (mathpanel3d == null) {
            throw new NullPointerException(Messages.getString("PanelColoring.1"));
        }
        this.mathpanel3d = mathpanel3d;
        this.surface3d = surface3d;
        this.initComponents();
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getActionCommand().equals("xyz")) {
            this.surface3d.setColorMode(1);
            this.surface3d.setVertexColorModel(new ColorModelXYZ());
        }
        if (event.getActionCommand().equals("z")) {
            this.surface3d.setColorMode(1);
            this.surface3d.setVertexColorModel(new ColorModelZ());
        }
        if (event.getActionCommand().equals("xy")) {
            this.surface3d.setColorMode(1);
            this.surface3d.setVertexColorModel(new ColorModelXY());
        }
        if (event.getActionCommand().equals("frontback")) {
            this.surface3d.setColorMode(0);
        }
        this.mathpanel3d.repaint();
    }

    void initComponents() {
        this.setLayout(new GridBagLayout());
        this.setMaximumSize(new Dimension(1000, 130));
        JRadioButton radioZ = new JRadioButton("z");
        radioZ.setActionCommand("z");
        radioZ.addActionListener(this);
        JRadioButton radioXY = new JRadioButton("xy");
        radioXY.setActionCommand("xy");
        radioXY.addActionListener(this);
        JRadioButton radioXYZ = new JRadioButton("xyz");
        radioXYZ.setActionCommand("xyz");
        radioXYZ.addActionListener(this);
        JRadioButton radioFrontBack = new JRadioButton(Messages.getString("PanelColoring.12"));
        radioFrontBack.setActionCommand("frontback");
        radioFrontBack.addActionListener(this);
        ButtonGroup groupShadingOpt = new ButtonGroup();
        groupShadingOpt.add(radioZ);
        groupShadingOpt.add(radioXY);
        groupShadingOpt.add(radioXYZ);
        groupShadingOpt.add(radioFrontBack);
        if (this.surface3d.getColorMode() == 0) {
            radioFrontBack.setSelected(true);
        } else {
            ColorModel colormodel = this.surface3d.getColorModel();
            if (colormodel instanceof ColorModelXY) {
                radioXY.setSelected(true);
            }
            if (colormodel instanceof ColorModelZ) {
                radioZ.setSelected(true);
            }
            if (colormodel instanceof ColorModelXYZ) {
                radioXYZ.setSelected(true);
            }
        }
        this.add((Component)radioZ, new GridBagConstraints(0, 0, 1, 1, 0.1, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.add((Component)radioXY, new GridBagConstraints(0, 1, 1, 1, 0.1, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)radioXYZ, new GridBagConstraints(0, 2, 1, 1, 0.1, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)radioFrontBack, new GridBagConstraints(0, 3, 1, 1, 0.1, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
    }
}

