/*
 * Decompiled with CFR 0.152.
 */
package uibk.mtk.draw3d.base;

import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;
import uibk.mtk.draw3d.base.Drawable3D;
import uibk.mtk.draw3d.base.Scene3D;
import uibk.mtk.lang.Highlightable;
import uibk.mtk.lang.MathPanel;
import uibk.mtk.lang.PrepaintComputable;

public class MathPanel3D
extends MathPanel {
    boolean listenforSceneRot = false;
    private static final double ROT = 0.05;
    protected double[][] zbuffer;
    protected Scene3D scene3d;
    private MyMouseMotionListening mouseMotionListener = new MyMouseMotionListening();
    int oldy;
    int oldx;

    public MathPanel3D() {
        this.scene3d = new Scene3D();
        this.scene3d.setPanel(this);
        this.setListenForSceneRotation(true);
    }

    public Scene3D getScene3D() {
        return this.scene3d;
    }

    public void setListenForSceneRotation(boolean listenForDrags) {
        if (listenForDrags == this.listenforSceneRot) {
            return;
        }
        this.listenforSceneRot = listenForDrags;
        if (listenForDrags) {
            this.addMouseMotionListener(this.mouseMotionListener);
        } else {
            this.removeMouseMotionListener(this.mouseMotionListener);
        }
    }

    @Override
    public void add(Object obj) {
        if (obj == null || !(obj instanceof Drawable3D)) {
            throw new IllegalArgumentException("");
        }
        if (!this.drawItems.contains(obj)) {
            Drawable3D draw = (Drawable3D)obj;
            super.add(draw);
            draw.setMathPanel3D(this);
        }
    }

    private void resetZBuffer() {
        int i = 0;
        while (i < this.getWidth() - 1) {
            int j = 0;
            while (j < this.getHeight() - 1) {
                this.zbuffer[i][j] = Double.POSITIVE_INFINITY;
                ++j;
            }
            ++i;
        }
    }

    @Override
    protected void preparebuffer() {
        super.preparebuffer();
        int w = this.getWidth();
        int h = this.getHeight();
        if (this.zbuffer == null || w > this.zbuffer.length || h > this.zbuffer[0].length) {
            this.zbuffer = new double[w][h];
        }
        this.resetZBuffer();
    }

    @Override
    protected synchronized void drawDrawables(BufferedImage framebuffer, Graphics2D g2) {
        int i;
        this.scene3d.prepareScene();
        this.options.setRenderingHints(g2);
        int ct = this.drawItems.size();
        if (this.repaintrequested) {
            i = 0;
            while (i < ct) {
                if (this.drawItems.elementAt(i) instanceof PrepaintComputable && ((Drawable3D)this.drawItems.elementAt(i)).isVisible()) {
                    try {
                        ((PrepaintComputable)this.drawItems.elementAt(i)).prepaintcompute();
                    }
                    catch (Exception ex) {
                        this.reportError(ex);
                    }
                }
                ++i;
            }
        }
        i = 0;
        while (i < ct) {
            Drawable3D d = (Drawable3D)this.drawItems.elementAt(i);
            if (d.isVisible()) {
                if (d == this.highlighted) {
                    ((Highlightable)((Object)d)).highlight(framebuffer, g2);
                } else {
                    d.draw(framebuffer, g2);
                }
            }
            ++i;
        }
        this.repaintrequested = false;
    }

    private class MyMouseMotionListening
    extends MouseMotionAdapter {
        private MyMouseMotionListening() {
        }

        @Override
        public void mouseDragged(MouseEvent ev) {
            double max = Math.max(Math.abs(ev.getY() - MathPanel3D.this.oldy), Math.abs(ev.getX() - MathPanel3D.this.oldx));
            if (max == 0.0) {
                max = 1.0;
            }
            double offx = ev.getY() < MathPanel3D.this.oldy ? 0.05 : -0.05;
            MathPanel3D.this.scene3d.setRotationX(MathPanel3D.this.scene3d.getRotationX() + (offx *= (double)Math.abs(ev.getY() - MathPanel3D.this.oldy) / max));
            MathPanel3D.this.oldy = ev.getY();
            double offz = ev.getX() < MathPanel3D.this.oldx ? -0.05 : 0.05;
            MathPanel3D.this.scene3d.setRotationZ(MathPanel3D.this.scene3d.getRotationZ() + (offz *= (double)Math.abs(ev.getX() - MathPanel3D.this.oldx) / max));
            MathPanel3D.this.oldx = ev.getX();
            MathPanel3D.this.repaint();
        }
    }
}

